package com.cuelinks;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.provider.Browser;
import android.text.Layout;
import android.text.method.LinkMovementMethod;
import android.text.style.URLSpan;
import android.view.MotionEvent;

public class CuelinksMovementMethod extends LinkMovementMethod {

    @SuppressLint("StaticFieldLeak")
    private static CuelinksMovementMethod linkMovementMethod;
    private Context context;
    private CuelinksListener mCuelinksListener;
    private String[] mSubId;

    /**
     * @param context applicationContext
     * @return android.text.method.MovementMethod
     */
    public static android.text.method.MovementMethod getInstance(Context context) {
        return getInstance(context, (String) null);
    }

    /**
     * @param c     applicationContext
     * @param subId sub ids
     * @return android.text.method.MovementMethod
     */
    public static android.text.method.MovementMethod getInstance(Context c, String... subId) {
        return getInstance(c, null, subId);
    }

    /**
     * @param c        applicationContext
     * @param subId    sub ids
     * @param listener CuelinksListener to be handled by developer
     * @return android.text.method.MovementMethod
     */
    public static android.text.method.MovementMethod getInstance(Context c, CuelinksListener listener, String... subId) {
        synchronized (CuelinksMovementMethod.class) {
            if (linkMovementMethod == null) {
                linkMovementMethod = new CuelinksMovementMethod();
            }
            linkMovementMethod.context = c;
            linkMovementMethod.mCuelinksListener = listener;
            linkMovementMethod.mSubId = subId;
        }

        return linkMovementMethod;
    }

    public boolean onTouchEvent(android.widget.TextView widget,
                                android.text.Spannable buffer, MotionEvent event) {
        int action = event.getAction();

        if (action == MotionEvent.ACTION_UP) {
            int x = (int) event.getX();
            int y = (int) event.getY();
            x -= widget.getTotalPaddingLeft();
            y -= widget.getTotalPaddingTop();
            x += widget.getScrollX();
            y += widget.getScrollY();
            Layout layout = widget.getLayout();
            int line = layout.getLineForVertical(y);
            int off = layout.getOffsetForHorizontal(line, x);
            URLSpan[] link = buffer.getSpans(off, off, URLSpan.class);
            if (link.length != 0) {
                String url = link[0].getURL();
                if (!(url.startsWith("tel") || url.startsWith("mailto"))) {
                    url = CuelinksUtil.getAffiliatedUrl(url, mSubId);
                    if (mCuelinksListener == null) {
                        Intent intent = new Intent(Intent.ACTION_VIEW, Uri.parse(url));
                        if (context != null) {
                            intent.putExtra(Browser.EXTRA_APPLICATION_ID, context.getPackageName());
                            context.startActivity(intent);
                        }
                    } else {
                        mCuelinksListener.openUrl(url, context);
                    }
                } else {
                    if (mCuelinksListener != null) {
                        mCuelinksListener.openUrl(url, context);
                    }
                }
                return true;
            }
        }

        return super.onTouchEvent(widget, buffer, event);
    }
}
