/*
 * Decompiled with CFR 0.152.
 */
package com.cuelinks;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;

public class Cuelinks {
    private static final String PUBLISHER_ID_PROPERTY = "com.cuelinks.publisherId";
    private static final String INTERNAL_URL_DOMAIN = "com.cuelinks.internalUrl";
    private static final String SUBID_PROPERTY = "com.cuelinks.subId";
    private static Boolean isInitialized = false;
    private static Context mApplicationContext;
    private static String mPublisherId;
    private static String mInternalUrl;
    private static String mSubId;

    private static void notNull(Object arg, String name) {
        if (arg == null) {
            throw new NullPointerException("Argument '" + name + "' cannot be null");
        }
    }

    public static void initialize(Context applicationContext) {
        if (isInitialized.booleanValue()) {
            return;
        }
        Cuelinks.notNull(applicationContext, "applicationContext");
        mApplicationContext = applicationContext;
        Cuelinks.loadDefaultsFromMetadata();
        isInitialized = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void loadDefaultsFromMetadata() {
        Object subId;
        ApplicationInfo ai;
        try {
            ai = mApplicationContext.getPackageManager().getApplicationInfo(mApplicationContext.getPackageName(), 128);
        }
        catch (PackageManager.NameNotFoundException e) {
            return;
        }
        if (ai == null || ai.metaData == null) throw new NullPointerException("Specify publisherId in your AndroidManifest file - com.cuelinks.publisherId.");
        Object appId = ai.metaData.get(PUBLISHER_ID_PROPERTY);
        if (appId == null) throw new NullPointerException("Specify publisherId in your AndroidManifest file - com.cuelinks.publisherId.");
        mPublisherId = appId.toString();
        Object url = ai.metaData.get(INTERNAL_URL_DOMAIN);
        if (url != null) {
            mInternalUrl = url.toString();
        }
        if ((subId = ai.metaData.get(SUBID_PROPERTY)) == null) return;
        mSubId = subId.toString();
    }

    public static String getPublisherId() {
        Cuelinks.notNull(mApplicationContext, "applicationContext");
        Cuelinks.notNull(mPublisherId, "publisherId");
        return mPublisherId;
    }

    public static String getInternalUrl() {
        Cuelinks.notNull(mApplicationContext, "applicationContext");
        return mInternalUrl;
    }

    public static String getSubId() {
        Cuelinks.notNull(mApplicationContext, "applicationContext");
        return mSubId;
    }
}

