package com.cuelinks;

import android.text.Html;
import android.text.Spanned;
import android.text.TextUtils;
import android.util.Patterns;

import java.util.regex.Pattern;

/**
 * Created by tasneem on 11/4/16.
 */
public class CuelinkUtil {

    /**
     * Convert provided link into cuelink affiliated links except the urls start with provided internal url domain.
     * @param url Url to be affiliated
     * @param subId subId to capture in cuelinks
     * @return String
     */
    public static String getAffiliatedUrl(String url, String subId) {
        if (!TextUtils.isEmpty(url) || Patterns.WEB_URL.matcher(url).matches()) {
            String internalUrl = Cuelinks.getInternalUrl();
            String appSubId = Cuelinks.getSubId();
            StringBuilder affiliatedLinkBuilder = new StringBuilder();
            if (!TextUtils.isEmpty(internalUrl) && url.contains(internalUrl)) {
              return url;
            }
            affiliatedLinkBuilder.append("https://linksredirect.com/?pub_id=").append(Cuelinks.getPublisherId())
                    .append("&subid=cua_");
            if (!TextUtils.isEmpty(appSubId) || !TextUtils.isEmpty(subId)) {
                affiliatedLinkBuilder.append(TextUtils.isEmpty(subId) ? appSubId : subId);
            } else {
                affiliatedLinkBuilder.append(Cuelinks.getPublisherId());
            }
            url = affiliatedLinkBuilder.append("&source=android&url=" ).append(url).toString();
        }
        return url;
    }

    /**
     * Method to convert html data to android readable
     * @param html html data to parse
     * @return Spanned
     */
    @SuppressWarnings("deprecation")
    public static Spanned fromHtml(String html) {
        Spanned result;
        if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.N) {
            result = Html.fromHtml(html,Html.FROM_HTML_MODE_LEGACY);
        } else {
            result = Html.fromHtml(html);
        }
        return result;
    }
}
