/*
 * Decompiled with CFR 0.152.
 */
package com.cuelinks;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.Layout;
import android.text.Spannable;
import android.text.method.LinkMovementMethod;
import android.text.method.MovementMethod;
import android.text.style.URLSpan;
import android.view.MotionEvent;
import android.widget.TextView;
import com.cuelinks.CuelinkListener;
import com.cuelinks.CuelinkUtil;

public class CuelinkMovementMethod
extends LinkMovementMethod {
    private static Context context;
    private static CuelinkListener mCuelinkListener;
    private static String mSubId;
    private static CuelinkMovementMethod linkMovementMethod;

    public boolean onTouchEvent(TextView widget, Spannable buffer, MotionEvent event) {
        int action = event.getAction();
        if (action == 1) {
            int line;
            int x = (int)event.getX();
            int y = (int)event.getY();
            x -= widget.getTotalPaddingLeft();
            y -= widget.getTotalPaddingTop();
            Layout layout = widget.getLayout();
            int off = layout.getOffsetForHorizontal(line = layout.getLineForVertical(y += widget.getScrollY()), (float)(x += widget.getScrollX()));
            URLSpan[] link = (URLSpan[])buffer.getSpans(off, off, URLSpan.class);
            if (link.length != 0) {
                String url = link[0].getURL();
                if (!url.startsWith("tel") && !url.startsWith("mailto")) {
                    url = CuelinkUtil.getAffiliatedUrl(url, mSubId);
                    if (mCuelinkListener == null) {
                        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
                        if (context != null && intent != null) {
                            intent.putExtra("com.android.browser.application_id", context.getPackageName());
                            context.startActivity(intent);
                        }
                    } else {
                        mCuelinkListener.openUrl(url, context);
                    }
                } else if (mCuelinkListener != null) {
                    mCuelinkListener.openUrl(url, context);
                }
                return true;
            }
        }
        return super.onTouchEvent(widget, buffer, event);
    }

    public static MovementMethod getInstance(Context c) {
        context = c;
        mCuelinkListener = null;
        mSubId = null;
        return linkMovementMethod;
    }

    public static MovementMethod getInstance(Context c, String subId) {
        context = c;
        mSubId = subId;
        mCuelinkListener = null;
        return linkMovementMethod;
    }

    public static MovementMethod getInstance(Context c, CuelinkListener listener) {
        context = c;
        mCuelinkListener = listener;
        mSubId = null;
        return linkMovementMethod;
    }

    public static MovementMethod getInstance(Context c, CuelinkListener listener, String subId) {
        context = c;
        mCuelinkListener = listener;
        mSubId = subId;
        return linkMovementMethod;
    }

    static {
        linkMovementMethod = new CuelinkMovementMethod();
    }
}

