package com.cuelinks;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.provider.Browser;
import android.text.Layout;
import android.text.method.LinkMovementMethod;
import android.text.style.URLSpan;
import android.view.MotionEvent;

public class CuelinkMovementMethod extends LinkMovementMethod {

    private static Context context;
    private static CuelinkListener mCuelinkListener;
    private static String mSubId;

    private static CuelinkMovementMethod linkMovementMethod = new CuelinkMovementMethod();

    public boolean onTouchEvent(android.widget.TextView widget,
                                android.text.Spannable buffer, MotionEvent event) {
        int action = event.getAction();

        if (action == MotionEvent.ACTION_UP) {
            int x = (int) event.getX();
            int y = (int) event.getY();
            x -= widget.getTotalPaddingLeft();
            y -= widget.getTotalPaddingTop();
            x += widget.getScrollX();
            y += widget.getScrollY();
            Layout layout = widget.getLayout();
            int line = layout.getLineForVertical(y);
            int off = layout.getOffsetForHorizontal(line, x);
            URLSpan[] link = buffer.getSpans(off, off, URLSpan.class);
            if (link.length != 0) {
                String url = link[0].getURL();
                if (!(url.startsWith("tel") || url.startsWith("mailto"))) {
                    url = CuelinkUtil.getAffiliatedUrl(url, mSubId);
                    if (mCuelinkListener == null) {
                        Intent intent = new Intent(Intent.ACTION_VIEW, Uri.parse(url));
                        if (context != null && intent != null) {
                            intent.putExtra(Browser.EXTRA_APPLICATION_ID, context.getPackageName());
                            context.startActivity(intent);
                        }
                    } else {
                        mCuelinkListener.openUrl(url, context);
                    }
                } else {
                    if (mCuelinkListener != null) {
                        mCuelinkListener.openUrl(url, context);
                    }
                }
                return true;
            }
        }

        return super.onTouchEvent(widget, buffer, event);
    }

    /**
     *
     * @param c applicationContext
     * @return android.text.method.MovementMethod
     */
    public static android.text.method.MovementMethod getInstance(Context c) {
        context = c;
        mCuelinkListener = null;
        mSubId = null;
        return linkMovementMethod;
    }

    /**
     *
     * @param c applicationContext
     * @return android.text.method.MovementMethod
     */
    public static android.text.method.MovementMethod getInstance(Context c, String subId) {
        context = c;
        mSubId = subId;
        mCuelinkListener = null;
        return linkMovementMethod;
    }

    /**
     *
     * @param c applicationContext
     * @param listener CuelinkListener to be handled by developer
     * @return android.text.method.MovementMethod
     */
    public static android.text.method.MovementMethod getInstance(Context c, CuelinkListener listener) {
        context = c;
        mCuelinkListener = listener;
        mSubId = null;
        return linkMovementMethod;
    }

    /**
     *
     * @param c applicationContext
     * @param listener CuelinkListener to be handled by developer
     * @return android.text.method.MovementMethod
     */
    public static android.text.method.MovementMethod getInstance(Context c, CuelinkListener listener, String subId) {
        context = c;
        mCuelinkListener = listener;
        mSubId = subId;
        return linkMovementMethod;
    }
}