package com.cuelinks;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;

/**
 * Created by tasneem on 20/05/16.
 */
public class Cuelinks {

    private static final String PUBLISHER_ID_PROPERTY = "com.cuelinks.publisherId";
    private static final String INTERNAL_URL_DOMAIN = "com.cuelinks.internalUrl";
    private static final String SUBID_PROPERTY = "com.cuelinks.subId";
    private static Boolean isInitialized = false;
    private static Context mApplicationContext;
    private static String mPublisherId;
    private static String mInternalUrl;
    private static String mSubId;

    /**
     *
     * @param arg Object to be verified
     * @param name Message to user if the Object is null
     */
    private static void notNull(Object arg, String name) {
        if (arg == null) {
            throw new NullPointerException("Argument '" + name + "' cannot be null");
        }
    }

    /**
     *
     * @param applicationContext applicationContext
     */
    public static void initialize(Context applicationContext) {
        if (isInitialized) {
            return;
        }
        notNull(applicationContext, "applicationContext");
        mApplicationContext = applicationContext;
        // Make sure we've loaded default settings if we haven't already.
        loadDefaultsFromMetadata();
        isInitialized = true;
    }

    /**
     *
     */
    private static void loadDefaultsFromMetadata() {
        ApplicationInfo ai;
        try {
            ai = mApplicationContext.getPackageManager().getApplicationInfo(
                    mApplicationContext.getPackageName(), PackageManager.GET_META_DATA);
        } catch (PackageManager.NameNotFoundException e) {
            return;
        }
        if (ai != null && ai.metaData != null) {
            Object appId = ai.metaData.get(PUBLISHER_ID_PROPERTY);
            if (appId != null) {
                mPublisherId = appId.toString();
                Object url = ai.metaData.get(INTERNAL_URL_DOMAIN);
                if (url != null) {
                    mInternalUrl = url.toString();
                }
                Object subId = ai.metaData.get(SUBID_PROPERTY);
                if (subId != null) {
                    mSubId = subId.toString();
                }
            } else {
                throw new NullPointerException("Specify publisherId in your AndroidManifest file - com.cuelinks.publisherId.");
            }
        } else {
            throw new NullPointerException("Specify publisherId in your AndroidManifest file - com.cuelinks.publisherId.");
        }
    }

    /**
     * Get publisher id
     * @return String
     */
    public static String getPublisherId() {
        notNull(mApplicationContext, "applicationContext");
        notNull(mPublisherId, "publisherId");
        return mPublisherId;
    }

    /**
     * Get domain url that user does not want to affiliate with cuelinks
     * @return String
     */
    public static String getInternalUrl() {
        notNull(mApplicationContext, "applicationContext");
        return mInternalUrl;
    }

    /**
     *
     * @return
     */
    public static String getSubId(){
        notNull(mApplicationContext, "applicationContext");
        return mSubId;
    }
}
