package com.cuelinks;

import android.text.TextUtils;
import android.util.Patterns;

import java.util.regex.Pattern;

/**
 * Created by tasneem on 11/4/16.
 */
public class CuelinkUtil {

    /**
     * Convert provided link into cuelink affiliated links except the urls start with provided internal url domain.
     * @param url Url to be affiliated
     * @param subId
     * @return String
     */
    public static String getAffiliatedUrl(String url, String subId) {
        if (!TextUtils.isEmpty(url) || Patterns.WEB_URL.matcher(url).matches()) {
            String internalUrl = Cuelinks.getInternalUrl();
            String appSubId = Cuelinks.getSubId();
            String affiliatedUrlPrefix = "";
            if (!TextUtils.isEmpty(internalUrl) && url.contains(internalUrl)) {
              return url;
            } else {
                affiliatedUrlPrefix = "https://linksredirect.com/?pub_id="+Cuelinks.getPublisherId();
            }
            if (!TextUtils.isEmpty(appSubId) || !TextUtils.isEmpty(subId)) {
                affiliatedUrlPrefix = affiliatedUrlPrefix + "&subid=" + (TextUtils.isEmpty(subId) ? appSubId : subId);
            }
            url = affiliatedUrlPrefix + "&url=" + url;
        }
        return url.replace(url, url);
    }
}
