package com.cuelinks;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.provider.Browser;
import android.text.Html;
import android.text.Spannable;
import android.text.method.LinkMovementMethod;
import android.text.style.URLSpan;
import android.view.View;
import android.widget.TextView;

/**
 * This code will perfectly work if user is using html data.
 * @author tasneem
 */
public class CuelinkSpan extends URLSpan {
    private static final String TAG = CuelinkSpan.class.getSimpleName();
    private static CuelinkListener mListener;
    private static String mSubId;

    public CuelinkSpan(String url) {
        super(url);
    }

    @Override
    public void onClick(View widget) {
        String url = CuelinkUtil.getAffiliatedUrl(getURL(), mSubId);
        Context context = widget.getContext();
        if (mListener == null) {
            Intent intent = new Intent(Intent.ACTION_VIEW, Uri.parse(url));
            if (context != null && intent != null) {
                intent.putExtra(Browser.EXTRA_APPLICATION_ID, context.getPackageName());
                context.startActivity(intent);
            }
        } else if (mListener instanceof CuelinkListener) {
            mListener.openUrl(url, context);
        }
    }

    /**
     * Pass encoded html data
     * @param text Html Encoded Text
     * @param view TextView
     * @return CharSequence
     */
    private static CharSequence replaceSpan(CharSequence text, TextView view) {
        view.setAutoLinkMask(0);
        view.setMovementMethod(LinkMovementMethod.getInstance());
        if (text instanceof Spannable) {
            final Spannable s = (Spannable)text;
            final URLSpan[] spans = s.getSpans(0, s.length(), URLSpan.class);
            if (spans != null && spans.length > 0) {
                for (int i = spans.length - 1; i >= 0; i--) {
                    final URLSpan span = spans[i];
                    final int start = s.getSpanStart(span);
                    final int end = s.getSpanEnd(span);
                    final int flags = s.getSpanFlags(span);
                    s.removeSpan(span);
                    s.setSpan(new CuelinkSpan(span.getURL()), start, end, flags);
                }
            }
        }
        return text;
    }

    /**
     *
     * @param text
     * @param view
     * @return
     */
    public static CharSequence affiliateHrefUrls(CharSequence text, TextView view) {
        mListener = null;
        mSubId = null;
        return replaceSpan(text, view);
    }

    /**
     *
     * @param text encoded text
     * @param view TextView
     * @param cuelinkListener CuelinkListener to be handled
     * @return CharSequence
     */
    public static CharSequence affiliateHrefUrls(CharSequence text, TextView view, CuelinkListener cuelinkListener) {
        mListener = cuelinkListener;
        mSubId = null;
        return replaceSpan(text, view);
    }

    /**
     *
     * @param text
     * @param view
     * @param cuelinkListener
     * @param subId
     * @return
     */
    public static CharSequence affiliateHrefUrls(CharSequence text, TextView view, CuelinkListener cuelinkListener, String subId) {
        mListener = cuelinkListener;
        mSubId = subId;
        return replaceSpan(text, view);
    }

    /**
     *
     * @param text
     * @param view
     * @param subId
     * @return
     */
    public static CharSequence affiliateHrefUrls(CharSequence text, TextView view, String subId) {
        mListener = null;
        mSubId = subId;
        return replaceSpan(text, view);
    }

    /**
     * Parse the html code into normal code and then convert the normal links to affiliate links.
     * This will extract link from <a></a> tag.
     * @param html Htmltext
     * @param view TextView
     * @return CharSequence
     */
    public static CharSequence affiliateHrefUrlsFromHtml(CharSequence html, TextView view) {
        return affiliateHrefUrls(Html.fromHtml(html.toString()), view);
    }

    /**
     *
     * @param html
     * @param view
     * @param subId
     * @return
     */
    public static CharSequence affiliateHrefUrlsFromHtml(CharSequence html, TextView view, String subId) {
        return affiliateHrefUrls(Html.fromHtml(html.toString()), view, subId);
    }

    /**
     * Parse the html code into normal code and then convert the normal links to affiliate links.
     * This will extract link from <a></a> tag.
     * @param html Html Text
     * @param view TextView
     * @param cuelinkListener CuelinkListener to be handled
     * @return CharSequence
     */
    public static CharSequence affiliateHrefUrlsFromHtml(CharSequence html, TextView view, CuelinkListener cuelinkListener) {
        return affiliateHrefUrls(Html.fromHtml(html.toString()), view, cuelinkListener);
    }

    /**
     *
     * @param html
     * @param view
     * @param cuelinkListener
     * @param subId
     * @return
     */
    public static CharSequence affiliateHrefUrlsFromHtml(CharSequence html, TextView view, CuelinkListener cuelinkListener, String subId) {
        return affiliateHrefUrls(Html.fromHtml(html.toString()), view, cuelinkListener, subId);
    }

}