/*
 * Decompiled with CFR 0.152.
 */
package com.cuelinks;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;

public class Cuelinks {
    private static final String PUBLISHER_ID_PROPERTY = "com.cuelinks.publisherId";
    private static Boolean isInitialized = false;
    private static Context mApplicationContext;
    private static String mPublisherId;

    private static void notNull(Object arg, String name) {
        if (arg == null) {
            throw new NullPointerException("Argument '" + name + "' cannot be null");
        }
    }

    public static synchronized void initialize(Context applicationContext) {
        if (isInitialized.booleanValue()) {
            return;
        }
        Cuelinks.notNull(applicationContext, "applicationContext");
        mApplicationContext = applicationContext;
        Cuelinks.loadDefaultsFromMetadata();
        isInitialized = true;
    }

    private static void loadDefaultsFromMetadata() {
        ApplicationInfo ai;
        if (mApplicationContext == null) {
            return;
        }
        try {
            ai = mApplicationContext.getPackageManager().getApplicationInfo(mApplicationContext.getPackageName(), 128);
        }
        catch (PackageManager.NameNotFoundException e) {
            return;
        }
        if (ai == null || ai.metaData == null) {
            return;
        }
        if (mPublisherId == null) {
            Object appId = ai.metaData.get(PUBLISHER_ID_PROPERTY);
            mPublisherId = appId.toString();
        }
    }

    public static String getPublisherId() {
        Cuelinks.notNull(mApplicationContext, "applicationContext");
        Cuelinks.notNull(mPublisherId, "publisherId");
        return mPublisherId;
    }
}

