/*
 * Decompiled with CFR 0.152.
 */
package com.cuelinks;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.Html;
import android.text.Spannable;
import android.text.method.LinkMovementMethod;
import android.text.style.URLSpan;
import android.util.Log;
import android.view.View;
import android.widget.TextView;
import com.cuelinks.CuelinkListener;
import com.cuelinks.CuelinkUtil;

public class CuelinkSpan
extends URLSpan {
    private static final String TAG = CuelinkSpan.class.getSimpleName();
    private static CuelinkListener mListener;

    public CuelinkSpan(String url) {
        super(url);
    }

    public void onClick(View widget) {
        try {
            Log.d((String)TAG, (String)this.getURL());
            String url = CuelinkUtil.getAffiliatedUrl(this.getURL());
            Context context = widget.getContext();
            if (mListener == null) {
                Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
                if (context != null && intent != null) {
                    intent.putExtra("com.android.browser.application_id", context.getPackageName());
                    context.startActivity(intent);
                }
            } else if (mListener instanceof CuelinkListener) {
                mListener.openUrl(url, context);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public static CharSequence affiliateHrefUrlsFromHtml(CharSequence html, TextView view) {
        return CuelinkSpan.affiliateHrefUrls((CharSequence)Html.fromHtml((String)html.toString()), view);
    }

    public static CharSequence affiliateHrefUrlsFromHtml(CharSequence html, TextView view, CuelinkListener cuelinkListener) {
        return CuelinkSpan.affiliateHrefUrls((CharSequence)Html.fromHtml((String)html.toString()), view, cuelinkListener);
    }

    public static CharSequence affiliateHrefUrls(CharSequence text, TextView view, CuelinkListener cuelinkListener) {
        mListener = cuelinkListener;
        return CuelinkSpan.affiliateHrefUrls(text, view);
    }

    public static CharSequence affiliateHrefUrls(CharSequence text, TextView view) {
        Spannable s;
        URLSpan[] spans;
        view.setAutoLinkMask(0);
        view.setMovementMethod(LinkMovementMethod.getInstance());
        if (text instanceof Spannable && (spans = (URLSpan[])(s = (Spannable)text).getSpans(0, s.length(), URLSpan.class)) != null && spans.length > 0) {
            for (int i = spans.length - 1; i >= 0; --i) {
                URLSpan span = spans[i];
                int start = s.getSpanStart((Object)span);
                int end = s.getSpanEnd((Object)span);
                int flags = s.getSpanFlags((Object)span);
                s.removeSpan((Object)span);
                s.setSpan((Object)new CuelinkSpan(span.getURL()), start, end, flags);
            }
        }
        return text;
    }
}

