/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.spring.annotation;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigChangeListener;
import com.ctrip.framework.apollo.ConfigService;
import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import com.ctrip.framework.apollo.spring.annotation.ApolloConfig;
import com.ctrip.framework.apollo.spring.annotation.ApolloConfigChangeListener;
import com.ctrip.framework.apollo.spring.annotation.ApolloProcessor;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;

public class ApolloAnnotationProcessor
extends ApolloProcessor {
    @Override
    protected void processField(Object bean, String beanName, Field field) {
        ApolloConfig annotation = (ApolloConfig)AnnotationUtils.getAnnotation((AnnotatedElement)field, ApolloConfig.class);
        if (annotation == null) {
            return;
        }
        Preconditions.checkArgument((boolean)Config.class.isAssignableFrom(field.getType()), (String)"Invalid type: %s for field: %s, should be Config", (Object[])new Object[]{field.getType(), field});
        String namespace = annotation.value();
        Config config = ConfigService.getConfig(namespace);
        ReflectionUtils.makeAccessible((Field)field);
        ReflectionUtils.setField((Field)field, (Object)bean, (Object)config);
    }

    @Override
    protected void processMethod(final Object bean, String beanName, final Method method) {
        ApolloConfigChangeListener annotation = (ApolloConfigChangeListener)AnnotationUtils.findAnnotation((Method)method, ApolloConfigChangeListener.class);
        if (annotation == null) {
            return;
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        Preconditions.checkArgument((parameterTypes.length == 1 ? 1 : 0) != 0, (String)"Invalid number of parameters: %s for method: %s, should be 1", (Object[])new Object[]{parameterTypes.length, method});
        Preconditions.checkArgument((boolean)ConfigChangeEvent.class.isAssignableFrom(parameterTypes[0]), (String)"Invalid parameter type: %s for method: %s, should be ConfigChangeEvent", (Object[])new Object[]{parameterTypes[0], method});
        ReflectionUtils.makeAccessible((Method)method);
        String[] namespaces = annotation.value();
        Object[] annotatedInterestedKeys = annotation.interestedKeys();
        Object[] annotatedInterestedKeyPrefixes = annotation.interestedKeyPrefixes();
        ConfigChangeListener configChangeListener = new ConfigChangeListener(){

            @Override
            public void onChange(ConfigChangeEvent changeEvent) {
                ReflectionUtils.invokeMethod((Method)method, (Object)bean, (Object[])new Object[]{changeEvent});
            }
        };
        HashSet interestedKeys = annotatedInterestedKeys.length > 0 ? Sets.newHashSet((Object[])annotatedInterestedKeys) : null;
        HashSet interestedKeyPrefixes = annotatedInterestedKeyPrefixes.length > 0 ? Sets.newHashSet((Object[])annotatedInterestedKeyPrefixes) : null;
        for (String namespace : namespaces) {
            Config config = ConfigService.getConfig(namespace);
            if (interestedKeys == null && interestedKeyPrefixes == null) {
                config.addChangeListener(configChangeListener);
                continue;
            }
            config.addChangeListener(configChangeListener, interestedKeys, interestedKeyPrefixes);
        }
    }
}

