/*
 * Decompiled with CFR 0.152.
 */
package com.css.sdk.cservice.view;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.text.method.ScrollingMovementMethod;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import com.css.sdk.R;

public class CommonDialog
extends Dialog {
    private ImageView imageIv;
    private TextView titleTv;
    private TextView messageTv;
    private Button negtiveBn;
    private Button positiveBn;
    private View columnLineView;
    private String message;
    private String title;
    private String positive;
    private String negtive;
    private int positiveColor;
    private int negtiveColor;
    private int imageResId = -1;
    private boolean isSingle = false;
    public OnClickBottomListener onClickBottomListener;

    public CommonDialog(Context context) {
        super(context, R.style.CustomDialog);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.css_notice_dialog);
        this.setCanceledOnTouchOutside(false);
        this.initView();
        this.refreshView();
        this.initEvent();
    }

    private void initEvent() {
        this.positiveBn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (CommonDialog.this.onClickBottomListener != null) {
                    CommonDialog.this.onClickBottomListener.onPositiveClick();
                }
            }
        });
        this.negtiveBn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (CommonDialog.this.onClickBottomListener != null) {
                    CommonDialog.this.onClickBottomListener.onNegtiveClick();
                }
            }
        });
    }

    private void refreshView() {
        if (!TextUtils.isEmpty((CharSequence)this.title)) {
            this.titleTv.setText((CharSequence)this.title);
            this.titleTv.setVisibility(0);
        } else {
            this.titleTv.setVisibility(8);
        }
        if (!TextUtils.isEmpty((CharSequence)this.message)) {
            this.messageTv.setText((CharSequence)this.message);
        }
        if (this.positiveColor != 0) {
            this.positiveBn.setTextColor(this.positiveColor);
        }
        if (this.negtiveColor != 0) {
            this.negtiveBn.setTextColor(this.negtiveColor);
        }
        if (!TextUtils.isEmpty((CharSequence)this.positive)) {
            this.positiveBn.setText((CharSequence)this.positive);
        } else {
            this.positiveBn.setText((CharSequence)"\u786e\u5b9a");
        }
        if (!TextUtils.isEmpty((CharSequence)this.negtive)) {
            this.negtiveBn.setText((CharSequence)this.negtive);
        } else {
            this.negtiveBn.setText((CharSequence)"\u53d6\u6d88");
        }
        if (this.imageResId != -1) {
            this.imageIv.setImageResource(this.imageResId);
            this.imageIv.setVisibility(0);
        } else {
            this.imageIv.setVisibility(8);
        }
        if (this.isSingle) {
            this.columnLineView.setVisibility(8);
            this.negtiveBn.setVisibility(4);
        } else {
            this.negtiveBn.setVisibility(0);
            this.columnLineView.setVisibility(0);
        }
    }

    public void show(Activity activity) {
        if (activity.isFinishing()) {
            return;
        }
        this.show();
        this.refreshView();
    }

    private void initView() {
        this.negtiveBn = (Button)this.findViewById(R.id.css_notice_btn_negtive);
        this.positiveBn = (Button)this.findViewById(R.id.css_notice_btn_positive);
        this.titleTv = (TextView)this.findViewById(R.id.css_notice_tv_title);
        this.messageTv = (TextView)this.findViewById(R.id.css_notice_tv_content);
        this.messageTv.setMovementMethod(ScrollingMovementMethod.getInstance());
        this.imageIv = (ImageView)this.findViewById(R.id.css_notice_iv);
        this.columnLineView = this.findViewById(R.id.column_line);
    }

    public CommonDialog setOnClickBottomListener(OnClickBottomListener onClickBottomListener) {
        this.onClickBottomListener = onClickBottomListener;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public CommonDialog setMessage(String message) {
        this.message = message;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public CommonDialog setTitle(String title) {
        this.title = title;
        return this;
    }

    public CommonDialog setNegtiveBtnText(String title) {
        this.title = title;
        return this;
    }

    public String getPositive() {
        return this.positive;
    }

    public CommonDialog setPositive(String positive) {
        this.positive = positive;
        return this;
    }

    public CommonDialog setPositiveColor(int color2) {
        this.positiveColor = color2;
        return this;
    }

    public String getNegtive() {
        return this.negtive;
    }

    public CommonDialog getNegtiveColor(int color2) {
        this.negtiveColor = color2;
        return this;
    }

    public CommonDialog setNegtive(String negtive) {
        this.negtive = negtive;
        return this;
    }

    public int getImageResId() {
        return this.imageResId;
    }

    public boolean isSingle() {
        return this.isSingle;
    }

    public CommonDialog setSingle(boolean single) {
        this.isSingle = single;
        return this;
    }

    public CommonDialog setImageResId(int imageResId) {
        this.imageResId = imageResId;
        return this;
    }

    public static interface OnClickBottomListener {
        public void onPositiveClick();

        public void onNegtiveClick();
    }
}

