/*
 * Decompiled with CFR 0.152.
 */
package com.css.sdk.cservice.activity;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.text.method.ScrollingMovementMethod;
import android.view.View;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.css.sdk.R;
import com.css.sdk.cservice.activity.AbstractBaseActivity;
import com.css.sdk.cservice.activity.FeedBackActivity;
import com.css.sdk.cservice.activity.SubmitSuccessActivity;
import com.css.sdk.cservice.base.Constants;
import com.css.sdk.cservice.business.BusinessRequest;
import com.css.sdk.cservice.business.RequestCallback;
import com.css.sdk.cservice.data.FaqDetail;
import com.css.sdk.cservice.userdata.GlobalData;
import com.css.sdk.cservice.utils.ToastHelper;
import com.css.sdk.cservice.view.CssQDWebView;
import com.css.sdk.cservice.view.CssRoundBtn;
import com.qmuiteam.qmui.widget.webview.QMUIWebViewClient;

public class FaqDetailActvity
extends AbstractBaseActivity {
    private String recommendId;
    private TextView answerTv;
    private CssRoundBtn unsolve;
    private CssRoundBtn solve;
    private LinearLayout loadingLl;
    private TextView bottomHintTv;
    private FaqDetail detail;
    private RelativeLayout bottomBtnLl;
    private String faqName;
    private String quId = "";
    private CssQDWebView webView;
    private static final int PROGRESS_PROCESS = 0;
    private static final int PROGRESS_GONE = 1;
    private boolean mIsPageFinished = false;
    private boolean mNeedDecodeUrl = false;
    private ProgressBar mProgressBar;
    private ProgressHandler mProgressHandler;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Override
    protected void initExtraData() {
        this.recommendId = this.getIntent().getStringExtra(Constants.KEY_RECOMMEND_ID);
        this.faqName = this.getIntent().getStringExtra(Constants.KEY_RECOMMEND_NAME);
        this.quId = this.getIntent().getStringExtra(Constants.KEY_QU_ID);
    }

    @Override
    public int getLayoutId() {
        return R.layout.css_activity_faq_detail_actvity;
    }

    @Override
    public void initView() {
        super.initView();
        this.showTitleClose(true);
        if (this.faqName.length() >= 60) {
            String substring = this.faqName.substring(0, 60);
            this.faqName = substring + "\n" + this.faqName.substring(60, this.faqName.length());
        }
        this.showTitleName(true, this.faqName);
        this.answerTv = (TextView)this.findViewById(R.id.css_answer);
        this.answerTv.setMovementMethod(ScrollingMovementMethod.getInstance());
        this.answerTv.setVisibility(8);
        this.unsolve = (CssRoundBtn)this.findViewById(R.id.css_rl_unsolveqa);
        this.bottomHintTv = (TextView)this.findViewById(R.id.css_hint);
        this.bottomBtnLl = (RelativeLayout)this.findViewById(R.id.css_bottom_rl);
        this.bottomBtnLl.setVisibility(8);
        this.unsolve.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FaqDetailActvity.this.evaluate(false);
            }
        });
        this.solve = (CssRoundBtn)this.findViewById(R.id.css_rl_solveqa);
        this.solve.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FaqDetailActvity.this.evaluate(true);
            }
        });
        this.mProgressBar = (ProgressBar)this.findViewById(R.id.progress_bar);
        this.mProgressHandler = new ProgressHandler();
        this.loadingLl = (LinearLayout)this.findViewById(R.id.css_loading_layout);
        this.webView = (CssQDWebView)this.findViewById(R.id.css_web);
        this.webView.setVisibility(8);
    }

    private void initWebView(String url) {
        this.webView.setWebChromeClient(new WebChromeClient(){

            public void onProgressChanged(WebView view, int newProgress) {
                super.onProgressChanged(view, newProgress);
                if (newProgress > FaqDetailActvity.this.mProgressHandler.mDstProgressIndex) {
                    FaqDetailActvity.this.sendProgressMessage(0, newProgress, 100);
                }
            }

            public void onReceivedTitle(WebView view, String title) {
                super.onReceivedTitle(view, title);
            }

            public void onShowCustomView(View view, WebChromeClient.CustomViewCallback callback) {
                callback.onCustomViewHidden();
            }
        });
        this.webView.setWebViewClient((WebViewClient)new QMUIWebViewClient(false, true){

            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                super.onPageStarted(view, url, favicon);
                if (FaqDetailActvity.this.mProgressHandler.mDstProgressIndex == 0) {
                    FaqDetailActvity.this.sendProgressMessage(0, 30, 500);
                }
            }

            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                FaqDetailActvity.this.sendProgressMessage(1, 100, 0);
            }
        });
        this.webView.requestFocus(130);
        this.webView.getSettings().setDisplayZoomControls(false);
        this.webView.loadUrl(url);
    }

    private void sendProgressMessage(int progressType, int newProgress, int duration) {
        Message msg = new Message();
        msg.what = progressType;
        msg.arg1 = newProgress;
        msg.arg2 = duration;
        this.mProgressHandler.sendMessage(msg);
    }

    @Override
    public void initData() {
        this.requestData();
    }

    private void showLoading() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (!FaqDetailActvity.this.loadingLl.isShown()) {
                    FaqDetailActvity.this.loadingLl.setVisibility(0);
                }
            }
        });
    }

    private void hideLoading() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (FaqDetailActvity.this.loadingLl.isShown()) {
                    FaqDetailActvity.this.loadingLl.setVisibility(8);
                }
            }
        });
    }

    private void evaluate(final boolean isHelp) {
        this.showLoading();
        BusinessRequest.evaluateFqa(this.recommendId, isHelp, new RequestCallback<String>(){

            @Override
            public void onSuccess(String result) {
                FaqDetailActvity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        FaqDetailActvity.this.hideLoading();
                        if (isHelp) {
                            FaqDetailActvity.this.bottomHintTv.setText(R.string.css_string_thanks_for_evaluate);
                            FaqDetailActvity.this.bottomBtnLl.setVisibility(8);
                            if (TextUtils.isEmpty((CharSequence)FaqDetailActvity.this.quId)) {
                                ToastHelper.showShortToastCenter(FaqDetailActvity.this.getResources().getString(R.string.css_string_thanks_for_evaluate));
                            } else {
                                FaqDetailActvity.this.backToSubmitSuccess(isHelp);
                            }
                            FaqDetailActvity.this.finish();
                        } else if (TextUtils.isEmpty((CharSequence)FaqDetailActvity.this.quId)) {
                            FaqDetailActvity.this.bottomHintTv.setText(R.string.css_text_hint_nohelp);
                            FaqDetailActvity.this.bottomBtnLl.setVisibility(0);
                            FaqDetailActvity.this.solve.setVisibility(8);
                            FaqDetailActvity.this.showFeedback();
                        } else {
                            ToastHelper.showShortToastCenter(FaqDetailActvity.this.getResources().getString(R.string.css_string_thanks_for_evaluate));
                            FaqDetailActvity.this.finish();
                        }
                    }
                });
            }

            @Override
            public void onFail(String msg, int code) {
                FaqDetailActvity.this.hideLoading();
                FaqDetailActvity.this.showError(code);
            }
        });
    }

    private void showFeedback() {
        this.unsolve.setBackground(this.getResources().getDrawable(R.drawable.css_shape_rounded_bg_whitesolied_blueline));
        this.unsolve.changeBgColor(GlobalData.getUiColor(), GlobalData.getUiColor());
        this.unsolve.setText(this.getResources().getString(R.string.css_string_feedback_new));
        this.unsolve.changeTextColor(-1);
        this.unsolve.setImgVisible(8);
        this.unsolve.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent intent = new Intent((Context)FaqDetailActvity.this, FeedBackActivity.class);
                FaqDetailActvity.this.startActivity(intent);
                FaqDetailActvity.this.finish();
            }
        });
    }

    private void backToSubmitSuccess(boolean isHelp) {
        Intent intent = new Intent((Context)this, SubmitSuccessActivity.class);
        intent.putExtra(Constants.KEY_DETIAL_EVALUATE_RESULT, isHelp);
        this.setResult(6001, intent);
    }

    private void requestData() {
        this.showLoading();
        BusinessRequest.getFaqDetail((Context)this, this.recommendId, new RequestCallback<FaqDetail>(){

            @Override
            public void onSuccess(final FaqDetail result) {
                FaqDetailActvity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        FaqDetailActvity.this.hideLoading();
                        if (result == null) {
                            FaqDetailActvity.this.showError(FaqDetailActvity.this.getResources().getString(R.string.css_string_system_error));
                            return;
                        }
                        FaqDetailActvity.this.detail = result;
                        if (!TextUtils.isEmpty((CharSequence)((FaqDetailActvity)FaqDetailActvity.this).detail.content)) {
                            FaqDetailActvity.this.showStyle(((FaqDetailActvity)FaqDetailActvity.this).detail.format);
                            FaqDetailActvity.this.bottomBtnLl.setVisibility(0);
                        } else {
                            FaqDetailActvity.this.answerTv.setVisibility(8);
                            FaqDetailActvity.this.bottomBtnLl.setVisibility(8);
                        }
                    }
                });
            }

            @Override
            public void onFail(String msg, int code) {
                FaqDetailActvity.this.hideLoading();
                FaqDetailActvity.this.showError(code);
            }
        });
    }

    private void showStyle(String content) {
        if (content.equals("text")) {
            this.answerTv.setText((CharSequence)this.detail.content);
            this.answerTv.setVisibility(0);
            this.webView.setVisibility(8);
        } else {
            this.answerTv.setVisibility(8);
            this.webView.setVisibility(0);
            this.initWebView(this.detail.content);
        }
    }

    private class ProgressHandler
    extends Handler {
        private int mDstProgressIndex;
        private int mDuration;
        private ObjectAnimator mAnimator;

        private ProgressHandler() {
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    FaqDetailActvity.this.mIsPageFinished = false;
                    this.mDstProgressIndex = msg.arg1;
                    this.mDuration = msg.arg2;
                    FaqDetailActvity.this.mProgressBar.setVisibility(0);
                    if (this.mAnimator != null && this.mAnimator.isRunning()) {
                        this.mAnimator.cancel();
                    }
                    this.mAnimator = ObjectAnimator.ofInt((Object)FaqDetailActvity.this.mProgressBar, (String)"progress", (int[])new int[]{this.mDstProgressIndex});
                    this.mAnimator.setDuration((long)this.mDuration);
                    this.mAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                        public void onAnimationEnd(Animator animation) {
                            if (FaqDetailActvity.this.mProgressBar.getProgress() == 100) {
                                ProgressHandler.this.sendEmptyMessageDelayed(1, 500L);
                            }
                        }
                    });
                    this.mAnimator.start();
                    break;
                }
                case 1: {
                    this.mDstProgressIndex = 0;
                    this.mDuration = 0;
                    FaqDetailActvity.this.mProgressBar.setProgress(0);
                    FaqDetailActvity.this.mProgressBar.setVisibility(8);
                    if (this.mAnimator != null && this.mAnimator.isRunning()) {
                        this.mAnimator.cancel();
                    }
                    this.mAnimator = ObjectAnimator.ofInt((Object)FaqDetailActvity.this.mProgressBar, (String)"progress", (int[])new int[]{0});
                    this.mAnimator.setDuration(0L);
                    this.mAnimator.removeAllListeners();
                    FaqDetailActvity.this.mIsPageFinished = true;
                    break;
                }
            }
        }
    }
}

