package com.css.sdk.cservice;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;

import com.aly.sdk.ALYAnalysis;
import com.css.sdk.cservice.activity.FaqActivity;
import com.css.sdk.cservice.base.utils.CpLog;
import com.css.sdk.cservice.base.utils.LogUtils;
import com.css.sdk.cservice.base.utils.ThreadHelper;
import com.css.sdk.cservice.business.BusinessRequest;
import com.css.sdk.cservice.business.RequestCallback;
import com.css.sdk.cservice.constant.SubmitEntryModelEnum;
import com.css.sdk.cservice.data.FaqTypeItem;
import com.css.sdk.cservice.data.ProductUIConfigEntity;
import com.css.sdk.cservice.listener.CSSExistNewReplyCallback;
import com.css.sdk.cservice.userdata.AASHelper;
import com.css.sdk.cservice.userdata.AlyTokenHelper;
import com.css.sdk.cservice.userdata.GlobalData;
import com.luck.picture.lib.app.IApp;
import com.luck.picture.lib.app.PictureAppMaster;
import com.qmuiteam.qmui.arch.QMUISwipeBackActivityManager;

import java.util.List;
import java.util.Map;

public class CServiceSdk {
    private static boolean sHasInited;

    public static void initSdk(final Context context, String productId, final InitCallback callback) {
        if (null == context) {
            CpLog.e("context is null, can't init CServiceSdk.");
            return;
        }
        if (TextUtils.isEmpty(productId)) {
            CpLog.e("productId is null, can't init CServiceSdk.");
            return;
        }
        init(context, productId, callback);
    }

    /**
     * 请在初始化前调用
     *
     * @param info
     */
    public static void addExtraMsg(final Map info) {
        if (info != null && info.size() > 0) {
            GlobalData.setCpInfo(info);
        }
    }


    private static void init(final Context context, String ptdid, final InitCallback callback) {

        if (sHasInited) {
            return;
        }
        GlobalData.setProductId(ptdid);
        GlobalData.cacheContext(context);
        // 初始化pictureselect
        PictureAppMaster.getInstance().setApp(new IApp() {
            @Override
            public Context getAppContext() {
                return context;
            }
        });
        // 初始化qmui

//        PictureSelectorCrashUtils.init(new PictureSelectorCrashUtils.CrashAppListener() {
//            @Override
//            public void onFinishApp(Thread thread, Throwable throwable) {
//                notifyInitFail(callback, "failed to init pictureselect" + throwable.getMessage());
//            }
//        });

        try {
            if (!AlyTokenHelper.isExistAlyLib()) {
                CpLog.e("missed alynasis SDK, can't init CServiceSdk.");
                notifyInitCallback(callback, false, "missed alynasis SDK, can't init CServiceSdk.");
                return;
            }
            if (AASHelper.isExistAASLib()) {
                AASHelper.freshGgid();
            }

            AlyTokenHelper.freshPramaters();


            sHasInited = true;


            //追加tag的获得，获得tag之后才算是初始化成功

            BusinessRequest.getFaqTypeList(new RequestCallback<List<FaqTypeItem>>() {
                @Override
                public void onSuccess(List<FaqTypeItem> result) {
                    GlobalData.setTypeItems(result);
                }

                @Override
                public void onFail(String msg, int code) {
                    notifyInitCallback(callback, false, "failed to init CServiceSdk error msg: " + msg + " code : " + code);
                }
            });

            BusinessRequest.getProductUIConfig(new RequestCallback<ProductUIConfigEntity>() {
                @Override
                public void onSuccess(ProductUIConfigEntity result) {
                    LogUtils.i("onSuccess in getProductUIConfig" + result.toString());
                    if (result == null) {
                        GlobalData.setUiColor("#3291F8");
                        GlobalData.setSubmitModel(SubmitEntryModelEnum.WEAK);
                    } else {
                        GlobalData.setUiColor(TextUtils.isEmpty(result.color) ? "#3291F8" : result.color);
                        GlobalData.setSubmitModel(result.modelEnum == null ? SubmitEntryModelEnum.NORMAL : result.modelEnum);
                    }
                    notifyInitCallback(callback, true, "");
                }

                @Override
                public void onFail(String msg, int code) {
                    notifyInitCallback(callback, false, "failed to init CServiceSdk error msg: " + msg + " code : " + code);
                }
            });
        } catch (Exception e) {
            notifyInitCallback(callback, false, "failed to init CServiceSdk, exception: " + e.getMessage());
        }
    }

    /**
     * 反馈问题入口
     */
    public static void feedback(Context context) {
        if (!sHasInited) {
            return;
        }

        AlyTokenHelper.freshPramaters();

        if (!GlobalData.isNecessaryParamtersAvailable()) {
            return;
        }

        if (null == GlobalData.getContext()) {
            GlobalData.cacheContext(context);
        }

        if (null == context) {
            context = GlobalData.getContext();
        }

        if (null == context) {
            return;
        }
        GlobalData.setConfig(context);
        Intent intent = new Intent(context, FaqActivity.class);
        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        context.startActivity(intent);
    }

    private static void notifyInitCallback(InitCallback callback, boolean success, String msg) {
        if (null == callback) {
            return;
        }
        ThreadHelper.runOnMainThread(new Runnable() {
            @Override
            public void run() {
                if (success) {
                    callback.onInitSuccess();
                } else {
                    callback.onInitFailed(msg);
                }

            }
        });

    }

    /**
     * 客服是否有新的反馈信息给游戏玩家
     *
     * @param callback
     */
    public static void setNewReplayCallback(CSSExistNewReplyCallback callback) {
        if (callback == null) {
            CpLog.w("CSSExistNewReplyCallback should not be s null");
            return;
        }
        if (TextUtils.isEmpty(ALYAnalysis.getUserId())) {
            CpLog.w("please  call setNewReplayCallback after initializating analysis sdk");
            return;
        }
        BusinessRequest.getExistNewReply(callback);
    }


}
