/*
 * Decompiled with CFR 0.152.
 */
package com.css.sdk.cservice.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.View;
import android.view.animation.AnimationUtils;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.css.sdk.R;
import com.css.sdk.cservice.activity.AbstractBaseActivity;
import com.css.sdk.cservice.adapter.ChatAdapter;
import com.css.sdk.cservice.base.CSSErrors;
import com.css.sdk.cservice.base.Constants;
import com.css.sdk.cservice.base.utils.LogUtils;
import com.css.sdk.cservice.base.utils.ToastUtil;
import com.css.sdk.cservice.business.BusinessRequest;
import com.css.sdk.cservice.business.RequestCallback;
import com.css.sdk.cservice.data.Chat;
import com.css.sdk.cservice.data.OrderDetail;
import com.css.sdk.cservice.data.Picture;
import com.css.sdk.cservice.glide.GlideCacheEngine;
import com.css.sdk.cservice.glide.GlideEngine;
import com.css.sdk.cservice.userdata.GlobalData;
import com.css.sdk.cservice.utils.ToastHelper;
import com.css.sdk.cservice.view.CssRoundBtn;
import com.luck.picture.lib.PictureSelector;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.engine.CacheResourcesEngine;
import com.luck.picture.lib.engine.ImageEngine;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.listener.OnResultCallbackListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class ChatDetailActivity
extends AbstractBaseActivity {
    private long id;
    private boolean isUnread;
    private OrderDetail detail;
    private LinearLayout bottomLl;
    private TextView bottomHintTv;
    private CssRoundBtn leftBtnRoot;
    private CssRoundBtn rightBtnRoot;
    private ListView chatListview;
    private RelativeLayout appendQuestionRl;
    private RelativeLayout chatContainerLl;
    private String selectedQaType;
    private ChatAdapter chatAdapter;
    private boolean hasClosed;
    private boolean hasReaded;
    private boolean hasChecked;
    private LinearLayout loadingView;
    private ImageView addPicsBtn;
    private TextView sendAppendQaBtn;
    private List<LocalMedia> selectedPics = new ArrayList<LocalMedia>();
    private List<Picture> picNames = new ArrayList<Picture>();
    private List<Picture> videoNames = new ArrayList<Picture>();
    private EditText appendQaContent;
    private boolean isShowAppenedQa;
    private Handler handler = new Handler(){

        public void handleMessage(Message msg) {
            int what = msg.what;
            switch (what) {
                case 1: {
                    if (ChatDetailActivity.this.chatAdapter.getCount() > 0) {
                        ChatDetailActivity.this.chatListview.setSelection(ChatDetailActivity.this.chatAdapter.getCount());
                    }
                    ChatDetailActivity.this.clearData();
                    break;
                }
            }
        }
    };

    private void clearData() {
        this.appendQaContent.setText((CharSequence)"");
        this.picNames.clear();
        this.videoNames.clear();
    }

    @Override
    protected void initExtraData() {
        this.id = this.getIntent().getLongExtra(Constants.KEY_DETAIL_ID, 0L);
        this.isUnread = this.getIntent().getBooleanExtra(Constants.KEY_IS_UNREAD, false);
    }

    @Override
    public int getLayoutId() {
        return R.layout.css_activity_chatdetail;
    }

    @Override
    public void initView() {
        super.initView();
        this.loadingView = (LinearLayout)this.findViewById(R.id.css_loading_layout);
        this.chatContainerLl = (RelativeLayout)this.findViewById(R.id.css_detail_container);
        this.bottomLl = (LinearLayout)this.findViewById(R.id.css_question_detail_bottom_ll);
        this.bottomHintTv = (TextView)this.findViewById(R.id.css_question_detail_hint);
        this.leftBtnRoot = (CssRoundBtn)this.findViewById(R.id.css_question_detail_left_btn);
        this.appendQuestionRl = (RelativeLayout)this.findViewById(R.id.append_question_rl);
        this.appendQuestionRl.setVisibility(8);
        this.appendQuestionRl.setBackgroundColor(GlobalData.getUiColor());
        this.rightBtnRoot = (CssRoundBtn)this.findViewById(R.id.css_question_detail_right_btn);
        this.leftBtnRoot.changeBgColor(GlobalData.getUiColor(), GlobalData.getUiColor());
        this.leftBtnRoot.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ChatDetailActivity.this.leftClick();
            }
        });
        this.chatListview = (ListView)this.findViewById(R.id.css_question_chat_listview);
        this.rightBtnRoot.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ChatDetailActivity.this.rightClick();
            }
        });
        this.addPicsBtn = (ImageView)this.findViewById(R.id.css_detail_add_pics);
        this.addPicsBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ChatDetailActivity.this.openGallery();
            }
        });
        this.appendQaContent = (EditText)this.findViewById(R.id.css_detial_appendqa_content);
        this.sendAppendQaBtn = (TextView)this.findViewById(R.id.css_detail_appendqa_send);
        this.sendAppendQaBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ChatDetailActivity.this.feedBack();
            }
        });
        this.showTitleBack(true);
    }

    @Override
    public void initData() {
        this.requestData();
    }

    private void feedBack() {
        if (TextUtils.isEmpty((CharSequence)this.appendQaContent.getText().toString().trim())) {
            return;
        }
        this.showLoading();
        final String content = this.appendQaContent.getText().toString().trim();
        BusinessRequest.feedBackN((Context)this, String.valueOf(this.id), this.picNames, this.videoNames, new ArrayList<Picture>(), -1, this.selectedQaType, content, new RequestCallback<String>(){

            @Override
            public void onSuccess(String result) {
                ChatDetailActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        ChatDetailActivity.this.hideLoading();
                        Chat chat = new Chat();
                        chat.send = "ask";
                        chat.original = content;
                        ChatDetailActivity.this.selectedPics.clear();
                        ArrayList<String> selected = new ArrayList<String>();
                        for (Picture file : ChatDetailActivity.this.picNames) {
                            selected.add(file.getPicName());
                        }
                        chat.pics = selected;
                        ChatDetailActivity.this.closeAppend();
                        ChatDetailActivity.this.appendQuestion(chat);
                        ChatDetailActivity.this.checkSpHelper();
                    }
                });
            }

            @Override
            public void onFail(String msg, int code) {
                ChatDetailActivity.this.hideLoading();
                ChatDetailActivity.this.showError(code);
            }
        });
    }

    private void closeAppend() {
        this.hideSoftKeyboard();
        this.appendQuestionRl.startAnimation(AnimationUtils.loadAnimation((Context)this, (int)R.anim.css_exit_top_to_bottom));
        this.appendQuestionRl.setVisibility(8);
        this.bottomLl.setVisibility(0);
    }

    @Override
    public void showTitleBack(boolean show) {
        RelativeLayout titleBack = (RelativeLayout)this.findViewById(R.id.css_title_back);
        titleBack.setVisibility(show ? 0 : 8);
        titleBack.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ChatDetailActivity.this.appendQuestionRl.isShown()) {
                    ChatDetailActivity.this.closeAppend();
                    return;
                }
                ChatDetailActivity.this.finish();
            }
        });
    }

    private void leftClick() {
        if (this.detail.status.equals(Constants.QA_STATUS_CLOSED) && !this.detail.evaluated) {
            this.evaluate(false);
        } else {
            this.showAppenQuestView();
        }
    }

    private void showAppenQuestView() {
        this.appendQuestionRl.startAnimation(AnimationUtils.loadAnimation((Context)this, (int)R.anim.css_enter_bottom_to_up));
        this.appendQuestionRl.setVisibility(0);
        this.isShowAppenedQa = true;
        if (!this.hasChecked) {
            this.hasChecked = true;
        }
    }

    private void evaluate(boolean isGood) {
        this.showLoading();
        BusinessRequest.evaluateWorkOrder(String.valueOf(this.id), isGood, new RequestCallback<String>(){

            @Override
            public void onSuccess(String result) {
                ChatDetailActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        ChatDetailActivity.this.hideLoading();
                        ((ChatDetailActivity)ChatDetailActivity.this).detail.status = Constants.QA_STATUS_CLOSED;
                        ((ChatDetailActivity)ChatDetailActivity.this).detail.evaluated = true;
                        ChatDetailActivity.this.dealBottomRl(((ChatDetailActivity)ChatDetailActivity.this).detail.status);
                        ToastHelper.showShortToastCenter(ChatDetailActivity.this.getResources().getString(R.string.css_string_thanks_for_evaluate));
                        ChatDetailActivity.this.finish();
                    }
                });
            }

            @Override
            public void onFail(String msg, int code) {
                ChatDetailActivity.this.hideLoading();
                ChatDetailActivity.this.showError(code);
            }
        });
    }

    private void showLoading() {
        this.loadingView.setVisibility(0);
    }

    private void hideLoading() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                ChatDetailActivity.this.loadingView.setVisibility(8);
            }
        });
    }

    private void commitFinish() {
        this.showLoading();
        BusinessRequest.fqaFinish(String.valueOf(this.id), new RequestCallback<String>(){

            @Override
            public void onSuccess(String result) {
                ChatDetailActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        ChatDetailActivity.this.hideLoading();
                        ChatDetailActivity.this.hasClosed = true;
                        ((ChatDetailActivity)ChatDetailActivity.this).detail.status = Constants.QA_STATUS_CLOSED;
                        ((ChatDetailActivity)ChatDetailActivity.this).detail.evaluated = false;
                        ChatDetailActivity.this.dealBottomRl(((ChatDetailActivity)ChatDetailActivity.this).detail.status);
                    }
                });
            }

            @Override
            public void onFail(String msg, int code) {
                ChatDetailActivity.this.hideLoading();
                ChatDetailActivity.this.showError(code);
            }
        });
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (this.appendQuestionRl.getVisibility() == 0 && keyCode == 4) {
            this.appendQuestionRl.setVisibility(8);
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    private void rightClick() {
        if ((this.detail.status.equals(Constants.QA_STATUS_CLOSED) || this.detail.status.equals(Constants.QA_STATUS_CLOSED_TIMEOUT)) && !this.detail.evaluated) {
            this.evaluate(true);
        } else {
            this.commitFinish();
        }
    }

    private void dealBottomRl(String status) {
        this.leftBtnRoot.setBackgroundResource(R.drawable.css_shape_rounded_bg_blue);
        this.rightBtnRoot.setBackgroundResource(R.drawable.css_shape_rounded_bg_blueline);
        if (status.equals(Constants.QA_STATUS_WAITING) || status.equals(Constants.QA_STATUS_WAITING_APPEND) || status.equals(Constants.QA_STATUS_PROCESSING) || status.equals(Constants.QA_STATUS_PROCESSED) || status.equals(Constants.QA_STATUS_PROCESSED_READ)) {
            this.bottomLl.setVisibility(0);
            this.bottomHintTv.setVisibility(8);
            this.leftBtnRoot.setVisibility(0);
            this.setDrawable(true, R.drawable.css_icon_edit_white, -1, GlobalData.getUiColor(), GlobalData.getUiColor(), R.string.css_string_append_question);
            this.rightBtnRoot.setVisibility(0);
            this.setDrawable(false, R.drawable.css_icon_success, GlobalData.getUiColor(), -1, GlobalData.getUiColor(), R.string.css_string_question_solved_text);
        } else if (status.equals(Constants.QA_STATUS_CLOSED) || status.equals(Constants.QA_STATUS_CLOSED_TIMEOUT)) {
            if (this.detail.evaluated) {
                this.bottomLl.setVisibility(8);
            } else {
                this.leftBtnRoot.setVisibility(0);
                this.rightBtnRoot.setVisibility(0);
                this.leftBtnRoot.setBackgroundResource(R.drawable.css_shape_rounded_bg_blueline);
                this.rightBtnRoot.setBackgroundResource(R.drawable.css_shape_rounded_bg_blue);
                this.bottomLl.setVisibility(0);
                this.bottomHintTv.setVisibility(0);
                this.bottomHintTv.setText(R.string.css_string_wait_comment_hint);
                this.bottomHintTv.setTextColor(GlobalData.getUiColor());
                this.setDrawable(true, R.drawable.css_icon_bad_gray, GlobalData.getUiColor(), -1, GlobalData.getUiColor(), R.string.css_string_satisfy_no);
                this.setDrawable(false, R.drawable.css_icon_good_gray, -1, GlobalData.getUiColor(), GlobalData.getUiColor(), R.string.css_string_satisfy_yes);
            }
        }
    }

    private void setDrawable(boolean isLeft, int resId, int textColor, int bgColor, int strokeColor, int stringId) {
        String text = this.getString(stringId);
        if (isLeft) {
            this.leftBtnRoot.setText(text);
            this.leftBtnRoot.setImgVisible(0);
            this.leftBtnRoot.changeImg(this.getResources().getDrawable(resId));
            this.leftBtnRoot.changeTextColor(textColor);
            this.leftBtnRoot.changeBgColor(bgColor, strokeColor);
        } else {
            this.rightBtnRoot.setText(text);
            this.rightBtnRoot.setImgVisible(0);
            this.rightBtnRoot.changeImg(this.getResources().getDrawable(resId));
            this.rightBtnRoot.changeBgColor(bgColor, strokeColor);
            this.rightBtnRoot.changeTextColor(textColor);
        }
    }

    private void appendQuestion(Chat chat) {
        this.detail.chats.add(chat);
        this.chatAdapter.bindData(this.detail);
        this.chatAdapter.notifyDataSetChanged();
        this.handler.sendEmptyMessage(1);
    }

    private void requestData() {
        this.showLoading();
        BusinessRequest.getDetail(this.id, new RequestCallback<OrderDetail>(){

            @Override
            public void onSuccess(final OrderDetail result) {
                ChatDetailActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        ChatDetailActivity.this.chatContainerLl.setVisibility(0);
                        ChatDetailActivity.this.hideLoading();
                        ChatDetailActivity.this.detail = result;
                        ChatDetailActivity.this.selectedQaType = ((ChatDetailActivity)ChatDetailActivity.this).detail.type;
                        if (ChatDetailActivity.this.isUnread) {
                            ChatDetailActivity.this.hasReaded = true;
                        }
                        ChatDetailActivity.this.dealBottomRl(((ChatDetailActivity)ChatDetailActivity.this).detail.status);
                        ChatDetailActivity.this.chatAdapter = new ChatAdapter((Context)ChatDetailActivity.this, ChatDetailActivity.this.detail);
                        ChatDetailActivity.this.chatListview.setAdapter((ListAdapter)ChatDetailActivity.this.chatAdapter);
                        ChatDetailActivity.this.handler.sendEmptyMessage(1);
                    }
                });
            }

            @Override
            public void onFail(String msg, int code) {
                ChatDetailActivity.this.hideLoading();
                ChatDetailActivity.this.showError(code);
            }
        });
    }

    public void finish() {
        if (this.hasClosed || this.hasReaded) {
            Intent intent = new Intent();
            if (this.hasReaded) {
                intent.putExtra(Constants.KEY_ORDER_CHANGE_TYPE, Constants.ORDER_CHANGE_TO_READED);
            }
            if (this.hasClosed) {
                intent.putExtra(Constants.KEY_ORDER_CHANGE_TYPE, Constants.ORDER_CHANGE_TO_CLOSED);
            }
            intent.putExtra(Constants.KEY_ORDER_ID, this.id);
            this.setResult(17, intent);
        }
        super.finish();
    }

    private void openGallery() {
        PictureSelector.create((Activity)this).openGallery(PictureMimeType.ofImage()).loadImageEngine((ImageEngine)GlideEngine.createGlideEngine()).defTheme().setDefPictureStyle((Context)this).loadCacheResourcesCallback((CacheResourcesEngine)GlideCacheEngine.createCacheEngine()).maxSelectNum(3).minSelectNum(0).maxVideoSelectNum(0).imageSpanCount(4).isReturnEmpty(false).setRequestedOrientation(1).isOriginalImageControl(false).selectionMode(2).previewImage(true).previewVideo(false).enablePreviewAudio(false).isCamera(false).isZoomAnim(true).enableCrop(false).compress(true).synOrAsy(true).isGif(false).openClickSound(false).selectionMedia(this.selectedPics).videoMinSecond(2).videoMaxSecond(30).cutOutQuality(90).minimumCompressSize(100).forResult((OnResultCallbackListener)new OnResultCallbackListener<LocalMedia>(){

            public void onResult(List<LocalMedia> result) {
                ArrayList<String> pics = new ArrayList<String>();
                for (LocalMedia media : result) {
                    if (PictureMimeType.eqVideo((String)media.getMimeType())) {
                        if (!media.getPath().endsWith(".mp4")) continue;
                        pics.add(media.getPath());
                        continue;
                    }
                    if (!PictureMimeType.eqImage((String)media.getMimeType())) continue;
                    if (media.getCompressPath().endsWith(".0")) {
                        String newPath = media.getCompressPath().substring(0, media.getCompressPath().length() - 2) + ".jpeg";
                        File errorFile = new File(media.getCompressPath());
                        if (errorFile.exists()) {
                            File newFile = new File(newPath);
                            errorFile.renameTo(newFile);
                            media.setCompressPath(newPath);
                        }
                    }
                    pics.add(media.getCompressPath());
                }
                ChatDetailActivity.this.upload(pics);
                ChatDetailActivity.this.selectedPics = result;
            }

            public void onCancel() {
                LogUtils.i("PictureSelector Cancel");
            }
        });
    }

    public void upload(ArrayList<String> pics) {
        LogUtils.i("pics is " + pics.toString());
        this.showLoading();
        BusinessRequest.uploadPics(pics, new RequestCallback<Map<String, List<Picture>>>(){

            @Override
            public void onSuccess(Map<String, List<Picture>> result) {
                ChatDetailActivity.this.hideLoading();
                if (result.containsKey(Constants.JSON_PICNAME)) {
                    ChatDetailActivity.this.picNames.addAll((Collection)result.get(Constants.JSON_PICNAME));
                }
                if (result.containsKey(Constants.JSON_VIDEONAME)) {
                    ChatDetailActivity.this.videoNames.addAll((Collection)result.get(Constants.JSON_VIDEONAME));
                }
                StringBuffer sb = new StringBuffer();
                for (Picture picture : ChatDetailActivity.this.picNames) {
                    sb.append(picture.getPicName() + "\n");
                }
                for (Picture picture : ChatDetailActivity.this.videoNames) {
                    sb.append(picture.getPicName() + "\n");
                }
                LogUtils.i("uploadPics result: " + sb.toString());
            }

            @Override
            public void onFail(String msg, final int code) {
                ChatDetailActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        ToastUtil.showToastTip(ChatDetailActivity.this.getApplicationContext(), CSSErrors.getErrorMessage(code), false);
                        ChatDetailActivity.this.hideLoading();
                    }
                });
            }
        });
    }
}

