/*
 * Decompiled with CFR 0.152.
 */
package com.css.sdk.cservice.activity;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import com.css.sdk.cservice.base.CSSErrors;
import com.css.sdk.cservice.base.Constants;
import com.css.sdk.cservice.base.utils.SpHelper;
import com.css.sdk.cservice.base.utils.ToastUtil;
import com.css.sdk.cservice.userdata.GlobalData;
import com.css.sdk.cservice.utils.CutoutUtil;
import com.css.sdk.cservice.utils.StatusNavUtils;

public class BaseActivity
extends AppCompatActivity {
    public boolean isLand;
    private int screenType;
    public SpHelper spHelper;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        this.fullScreen();
        this.hideNavigationBar(true);
        this.closeAutoFillonAndroid8();
        this.checkSpHelper();
        this.screenType = GlobalData.getScreenType();
        int orientation = this.getResources().getConfiguration().orientation;
        if (orientation == 2) {
            this.isLand = true;
        }
        StatusNavUtils.setStatusNavBar((Activity)this, this.screenType);
        if (CutoutUtil.hasNotchScreen((Activity)this) && this.isLand) {
            CutoutUtil.useNotch((Activity)this, this.screenType);
        }
        super.onCreate(savedInstanceState);
    }

    private void hideNavigationBar(boolean isHide) {
        Window mWindow = this.getWindow();
        WindowManager.LayoutParams params = mWindow.getAttributes();
        params.systemUiVisibility = 4098;
        mWindow.setAttributes(params);
    }

    private void fullScreen() {
        this.requestWindowFeature(1);
        this.getWindow().setFlags(1024, 1024);
    }

    private void closeAutoFillonAndroid8() {
        if (Build.VERSION.SDK_INT >= 26) {
            this.getWindow().getDecorView().setImportantForAutofill(8);
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        if (newConfig.orientation == 1 && this.isLand) {
            if (this.screenType == Constants.SCREEN_TYPE_LAND) {
                this.setRequestedOrientation(0);
            } else if (this.screenType == Constants.SCREEN_TYPE_REVERSE_LAND) {
                this.setRequestedOrientation(8);
            }
        }
        if (newConfig.orientation == 2 && !this.isLand) {
            this.setRequestedOrientation(1);
        }
        super.onConfigurationChanged(newConfig);
    }

    protected void onPause() {
        super.onPause();
    }

    protected void onResume() {
        super.onResume();
    }

    public void checkSpHelper() {
        if (this.spHelper == null) {
            this.spHelper = new SpHelper((Context)this, Constants.SP_NAME);
        }
    }

    public void hideSoftKeyboard() {
        View view = this.getCurrentFocus();
        if (view != null) {
            InputMethodManager inputMethodManager = (InputMethodManager)this.getSystemService("input_method");
            inputMethodManager.hideSoftInputFromWindow(view.getWindowToken(), 2);
        }
    }

    protected void showError(final int code) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                ToastUtil.showToastTip(BaseActivity.this.getApplicationContext(), CSSErrors.getErrorMessage(code), false);
            }
        });
    }

    protected void showError(final String msg) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                ToastUtil.showToastTip(BaseActivity.this.getApplicationContext(), msg, false);
            }
        });
    }
}

