package com.css.sdk.cservice.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.css.sdk.R;
import com.css.sdk.cservice.data.ImageFloder;
import com.css.sdk.cservice.imageloader.ImageLoader;

import java.util.ArrayList;
import java.util.List;

public class PictureAlbumDirectoryAdapter extends BaseAdapter {

    private Context context;
    private OnItemClickListener onItemClickListener;
    private List<ImageFloder> folders = new ArrayList<>();

    public void bindFolderData(List<ImageFloder> folders) {
        this.folders = folders;
        notifyDataSetChanged();
    }

    public List<ImageFloder> getFolderData() {
        if (folders == null) {
            folders = new ArrayList<>();
        }
        return folders;
    }


    public PictureAlbumDirectoryAdapter(Context context) {
        this.context = context;
    }

    @Override
    public int getCount() {
        return folders.size();
    }

    @Override
    public Object getItem(int position) {
        return null;
    }

    @Override
    public long getItemId(int position) {
        return 0;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        final ImageFloder folder = folders.get(position);
        String name = folder.getName();
        int imageNum = folder.images.size();
        String imagePath = folder.getFirstImagePath();
        ViewHolder holder = null;
        if (convertView == null) {
            convertView = LayoutInflater.from(context).inflate(R.layout.css_picture_album_folder_item, null);
            holder = new ViewHolder(convertView);
            convertView.setTag(holder);
        } else {
            holder = (ViewHolder) convertView.getTag();
        }

        ImageLoader.getInstance().load(imagePath,holder.firstImage);
        holder.imageNum.setText("(" + imageNum + ")");
        holder.folderNameTv.setText(name);
        holder.choose.setVisibility(folder.isChecked() ? View.VISIBLE : View.GONE);
        holder.itemRl.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if (onItemClickListener != null) {
                    for (ImageFloder mediaFolder : folders) {
                        mediaFolder.setChecked(false);
                    }
                    folder.setChecked(true);
                    notifyDataSetChanged();
                    onItemClickListener.onItemClick(folder.getName(), folder);
                }
            }
        });
        return convertView;
    }

    class ViewHolder {
        ImageView firstImage;
        TextView folderNameTv;
        TextView imageNum;
        RelativeLayout itemRl;
        ImageView choose;

        public ViewHolder(View view) {
            this.firstImage = (ImageView) view.findViewById(R.id.css_folder_first_image);
            this.folderNameTv = (TextView) view.findViewById(R.id.css_tv_folder_name);
            this.imageNum = (TextView) view.findViewById(R.id.css_pics_num);
            this.itemRl = (RelativeLayout) view.findViewById(R.id.css_album_item_rl);
            this.choose = (ImageView) view.findViewById(R.id.css_folder_choose);
        }
    }

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.onItemClickListener = onItemClickListener;
    }

    public interface OnItemClickListener {
        void onItemClick(String folderName, ImageFloder floder);
    }
}
