package com.css.sdk.cservice.activity;

import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.widget.GridView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.css.sdk.R;
import com.css.sdk.cservice.adapter.CssTextGridViewAdapter;
import com.css.sdk.cservice.adapter.GridImageAdapter;
import com.css.sdk.cservice.adapter.RecommendQaAapter;
import com.css.sdk.cservice.base.Constants;
import com.css.sdk.cservice.base.utils.LogUtils;
import com.css.sdk.cservice.business.BusinessRequest;
import com.css.sdk.cservice.business.RequestCallback;
import com.css.sdk.cservice.data.FaqItem;
import com.css.sdk.cservice.data.FaqTypeItem;
import com.css.sdk.cservice.data.ProductUIConfigEntity;
import com.css.sdk.cservice.userdata.GlobalData;
import com.css.sdk.cservice.view.CssRoundBtn;

import org.json.JSONObject;

import java.util.List;

public class FeedBackActivity extends FeedBaseActivity implements RecommendQaAapter.RecommendQAItemClickListener, CssTextGridViewAdapter.GridViewItemClickListener, GridImageAdapter.picDeleteListener {
    private CssRoundBtn feedbackBtn;
//    private TextView feedbackHistoryTv;

    //
    private LinearLayout rootLl;
    private RelativeLayout titleTvRoot;
    // gridview for faqTag
    private GridView mGridView;
    private CssTextGridViewAdapter mGridAdapter;
    private String selectedQaType = "1";
    private boolean hasShow;
    private RecommendQaAapter recommendQaAapter;
    private List<FaqItem> faqList;
    private RelativeLayout contentRoot;
    // 推荐列表的loading
    private LinearLayout subLoadingView;
    public boolean mSubLoading;
    private List<FaqTypeItem> typeItems;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            getWindow()
                    .getDecorView()
                    .setImportantForAutofill(View.IMPORTANT_FOR_AUTOFILL_NO_EXCLUDE_DESCENDANTS);
        }
        super.onCreate(savedInstanceState);
        initData();
    }

    private void initData() {
        showLoading();
        BusinessRequest.getSubmitFaqTypeList(new RequestCallback<List<FaqTypeItem>>() {
            @Override
            public void onSuccess(List<FaqTypeItem> result) {
                hideLoading();
                typeItems = result;
                if (typeItems == null || typeItems.size() <= 0) {
                    showError(getResources().getString(R.string.css_string_system_error));
                    return;
                }
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        initView();
                    }
                });
            }

            @Override
            public void onFail(String msg, int code) {
                hideLoading();
                showError(msg);
            }
        });
    }

    @Override
    public int getLayoutId() {
        return R.layout.css_activity_feed_back;
    }

    private void initView() {
        mGridView = findViewById(R.id.css_faqtag_gridView);
        feedbackBtn = findViewById(R.id.css_btn_submit_qa);
        mGridAdapter = new CssTextGridViewAdapter(this, 0, typeItems, this);
        mGridView.setAdapter(mGridAdapter);
        hideTitleBack();
        showTitleName(R.string.css_text_submit_qa);
        showTitleClose();
        subLoadingView = findViewById(R.id.listview_loading);
        rootLl = findViewById(R.id.css_feedback_root);
//        feedbackHistoryTv = findViewById(R.id.css_feedback_history);
//        realTimeSearch(etFeedbackContent);
        feedbackBtn.changeBgColor(GlobalData.getUiColor(),GlobalData.getUiColor());
        feedbackBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                feedBack();
            }
        });

        recommendQaAapter = new RecommendQaAapter(this, this);
        checkSpHelper();
        hasShow = spHelper.getBooleanWithDefault(Constants.RECOMMENDED_QA_SHOW, true);

        // 显示推荐问题
//        dealRecommend(hasShow);
//        SoftHideKeyBoardUtil.assistActivity(rootLl, etFeedbackContent, contactEt);

        mSelectedPicsAdapter.setPicDeleteListener(this);
        contentRoot=findViewById(R.id.css_feedback_et_root);
        contentRoot.setBackgroundColor(GlobalData.getUiAlphaColor());
    }

    private void hideTitleBack() {
        titleBack = findViewById(R.id.css_title_back);
        titleBack.setVisibility(View.GONE);

        titleBack.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                finish();
            }
        });
    }

    private void showTitleName(int resId) {
        titleTvRoot = findViewById(R.id.rl_titile_text);
        titleTvRoot.setVisibility(View.VISIBLE);
        TextView titleTv = findViewById(R.id.css_title_tv);
        titleTv.setText(getResources().getString(resId));
    }

    private void showTitleClose() {
        RelativeLayout closeRoot = findViewById(R.id.css_title_close);
        closeRoot.setVisibility(View.VISIBLE);
        closeRoot.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                finish();
            }
        });
    }


    private void feedBack() {
        if (isContentEmpty()) {
            return;
        }
        if (mLoading) {
            return;
        }

        showLoading();
        BusinessRequest.feedBackN(this, "", picNames, videoNames, cancelPics, Integer.parseInt(selectedQaType), "", etFeedbackContent.getText().toString().trim(),
                new RequestCallback<String>() {
                    @Override
                    public void onSuccess(String result) {
                        runOnUiThread(new Runnable() {
                            @Override
                            public void run() {
                                //   获得result 中的id和matchFaqs 传递给下一页
                                hideLoading();
                                try {
                                    JSONObject jsonObject = new JSONObject(result);
                                    String msg = jsonObject.optString("message");
                                    if (!msg.equals("SUCCESS")) {
                                        showError(0);
                                        return;
                                    }
                                    Intent intent = new Intent(FeedBackActivity.this, SubmitSuccessActivity.class);
                                    intent.putExtra("result", result);
                                    startActivity(intent);
                                    clearData();
                                    finish();

                                } catch (Exception e) {
                                    showError(e.getMessage());
                                }
//                                spHelper.putString(Constants.LAST_QA_TYPE, selectedQaType.getTag());
                            }
                        });
                    }

                    @Override
                    public void onFail(String msg, int code) {
                        hideLoading();
                        showError(code);
                    }
                });
    }


    @Override
    protected void onDestroy() {
//        ImageLoader.getInstance().stop();
        if (GlobalData.getIsSensorLand()) {
            setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_SENSOR_LANDSCAPE);
        }
        getWindow().getDecorView().findViewById(android.R.id.content).setPadding(0, 0, 0, 0);
        super.onDestroy();
    }

    private void getFaqListMatch(String content) {
        showSubLoading();
        BusinessRequest.getFaqMatchList(content, new RequestCallback<List<FaqItem>>() {
            @Override
            public void onSuccess(final List<FaqItem> result) {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        if (result.isEmpty()) {
//                            changeRecommendList();
                            return;
                        }
                        faqList = result;
//                        emptyRecommned.setVisibility(View.GONE);
//                        recommendList.setVisibility(View.VISIBLE);
                        if (hasShow) {
                            recommendQaAapter.bindData(result);
                        }
                        hideSubLoading();
                    }
                });
            }

            @Override
            public void onFail(String msg, int code) {
                hideLoading();
                showError(code);
            }
        });
    }

    /**
     * 显示下方推荐类别的loading
     */
    public void showSubLoading() {
//        recommendRl.setClickable(false);
        mSubLoading = true;
//        subLoadingView.setVisibility(View.VISIBLE);
    }

    public void hideSubLoading() {
//        recommendRl.setClickable(true);
        mSubLoading = false;
//        subLoadingView.setVisibility(View.GONE);
    }

    /**
     * 显示整个页面的loading
     */
    @Override
    public void showLoading() {
        super.showLoading();
    }

    @Override
    public void hideLoading() {
        super.hideLoading();
    }

    @Override
    public void onItemClick(int position, FaqItem faqItem) {
        Intent i = new Intent(FeedBackActivity.this, FaqDetailActvity.class);
        i.putExtra(Constants.KEY_RECOMMEND_ID, faqItem.id);
        startActivity(i);
    }

    @Override
    public void onGridItemClick(int id) {
        selectedQaType = typeItems.get(id).getId();
    }

    /**
     * 图片删除的回调
     *
     * @param postion
     */
    @Override
    public void deleted(int postion) {
        cancelPics.add(picNames.get(postion));
        if (picNames.contains(picNames.get(postion))) {
            picNames.remove(picNames.get(postion));
        }
    }
}
