/*
 * Decompiled with CFR 0.152.
 */
package com.css.sdk.cservice.refresh;

import android.animation.TimeInterpolator;
import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.LinearInterpolator;
import android.widget.AbsListView;
import android.widget.ImageView;
import android.widget.TextView;
import com.css.sdk.R;
import com.css.sdk.cservice.refresh.RefreshLayout;
import com.css.sdk.cservice.refresh.Swipe;

class HeadManager
implements Swipe.OnChangeViewHeight,
Swipe.OnChangeViewTip {
    private ViewGroup headView;
    private TextView tvHeadTip;
    private Context mContext;
    private int refreshViewHeight;
    private ImageView ivHeadArrow;
    private ImageView ivHeadRefresh;
    private TextView tvRefreshTime;
    private ViewGroup.LayoutParams headViewLayoutParams;
    private ViewGroup.LayoutParams headChildViewLayoutParams;
    private View headChildView;
    private int tempHeight;
    private int currentHeadTips = 0;

    HeadManager(Context context, RefreshLayout refreshLayout) {
        this.mContext = context;
        if (refreshLayout != null) {
            this.refreshViewHeight = refreshLayout.REFRESH_VIEW_HEIGHT_DP;
            refreshLayout.setOnChangeViewTip(this);
            refreshLayout.setOnChangeViewHeight(this);
        }
    }

    public View getHeadView() {
        this.headView = (ViewGroup)LayoutInflater.from((Context)this.mContext).inflate(R.layout.css_refresh_head, null, false);
        this.headChildView = this.headView.getChildAt(0);
        this.headChildViewLayoutParams = this.headChildView.getLayoutParams();
        this.headChildViewLayoutParams.height = 0;
        this.headChildView.setLayoutParams(this.headChildViewLayoutParams);
        this.headViewLayoutParams = new AbsListView.LayoutParams(-1, 0);
        this.headView.setLayoutParams(this.headViewLayoutParams);
        this.tvHeadTip = (TextView)this.headView.findViewById(R.id.css_tv_head_tip);
        this.ivHeadArrow = (ImageView)this.headView.findViewById(R.id.css_iv_head_arrow);
        this.ivHeadArrow.animate().setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.ivHeadRefresh = (ImageView)this.headView.findViewById(R.id.css_iv_head_refresh);
        this.ivHeadRefresh.animate().setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.tvRefreshTime = (TextView)this.headView.findViewById(R.id.css_tv_refresh_time);
        if (!TextUtils.isEmpty((CharSequence)Swipe.getLastRefreshTime(this.mContext))) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.mContext.getString(R.string.css_string_last_update_time)).append(Swipe.getLastRefreshTime(this.mContext));
            this.tvRefreshTime.setText((CharSequence)sb.toString());
        } else {
            this.tvRefreshTime.setVisibility(8);
        }
        return this.headView;
    }

    public void setHeadView(ViewGroup headView) {
        this.headView = headView;
        if (headView.getChildCount() == 1) {
            this.headChildView = headView.getChildAt(0);
            this.headChildViewLayoutParams = this.headChildView.getLayoutParams();
            this.headChildViewLayoutParams.height = 0;
            this.headChildView.setLayoutParams(this.headChildViewLayoutParams);
            this.headViewLayoutParams = new AbsListView.LayoutParams(-1, 0);
        } else {
            this.headViewLayoutParams = new AbsListView.LayoutParams(-1, 1);
        }
        headView.setLayoutParams(this.headViewLayoutParams);
    }

    @Override
    public void changeHeadViewHeight(int headViewHeight) {
        if (this.headView != null && headViewHeight >= 0) {
            if (this.headChildView == null && headViewHeight == 0) {
                headViewHeight = 1;
            }
            this.headViewLayoutParams.height = headViewHeight;
            this.headView.setLayoutParams(this.headViewLayoutParams);
        }
        if (this.headChildView != null && headViewHeight >= 0) {
            int n = this.headChildViewLayoutParams.height = headViewHeight == 0 ? 0 : this.refreshViewHeight;
            if (this.tempHeight != this.headChildViewLayoutParams.height) {
                this.headChildView.setLayoutParams(this.headChildViewLayoutParams);
                this.tempHeight = this.headChildViewLayoutParams.height;
            }
        }
    }

    @Override
    public void changeHeadTips(int tips) {
        if (this.currentHeadTips != tips) {
            this.currentHeadTips = tips;
            if (this.tvHeadTip != null) {
                this.tvHeadTip.setText(tips);
            }
            if (this.ivHeadArrow != null && this.ivHeadRefresh != null) {
                if (tips == RefreshLayout.PULL_DOWN) {
                    this.ivHeadArrow.setVisibility(0);
                    this.ivHeadRefresh.setVisibility(8);
                    this.ivHeadArrow.animate().rotation(0.0f);
                } else if (tips == RefreshLayout.RELEASE_REFRESH) {
                    this.ivHeadArrow.setVisibility(0);
                    this.ivHeadRefresh.setVisibility(8);
                    this.ivHeadArrow.animate().rotation(180.0f);
                } else if (tips == RefreshLayout.REFRESHING) {
                    this.ivHeadArrow.setVisibility(8);
                    this.ivHeadRefresh.setVisibility(0);
                    this.ivHeadArrow.animate().rotation(0.0f);
                    this.ivHeadRefresh.animate().rotation(216000.0f).setDuration(600000L);
                } else if (tips == RefreshLayout.REFRESH_FINISH) {
                    String time = Swipe.saveLastRefreshTime(this.mContext);
                    if (this.tvRefreshTime.getVisibility() != 0) {
                        this.tvRefreshTime.setVisibility(0);
                    }
                    StringBuilder sb = new StringBuilder();
                    sb.append(this.mContext.getString(R.string.css_string_last_update_time)).append(time);
                    this.tvRefreshTime.setText((CharSequence)sb.toString());
                    this.ivHeadRefresh.animate().cancel();
                } else {
                    this.ivHeadArrow.animate().cancel();
                    this.ivHeadRefresh.setVisibility(8);
                }
            }
        }
    }
}

