/*
 * Decompiled with CFR 0.152.
 */
package com.css.sdk.cservice.activity;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import com.css.sdk.R;
import com.css.sdk.cservice.activity.AbstractBaseActivity;
import com.css.sdk.cservice.base.Constants;
import com.css.sdk.cservice.business.BusinessRequest;
import com.css.sdk.cservice.business.RequestCallback;
import com.css.sdk.cservice.data.SystemMsgDetailEntity;
import com.css.sdk.cservice.view.CssQDWebView;
import com.qmuiteam.qmui.util.QMUILangHelper;
import com.qmuiteam.qmui.util.QMUIResHelper;
import com.qmuiteam.qmui.widget.QMUITopBarLayout;
import com.qmuiteam.qmui.widget.dialog.QMUITipDialog;
import com.qmuiteam.qmui.widget.webview.QMUIWebView;
import com.qmuiteam.qmui.widget.webview.QMUIWebViewClient;
import com.qmuiteam.qmui.widget.webview.QMUIWebViewContainer;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

public class CssWebExplorerActivity
extends AbstractBaseActivity {
    private static final int PROGRESS_PROCESS = 0;
    private static final int PROGRESS_GONE = 1;
    QMUITopBarLayout mTopBarLayout;
    QMUIWebViewContainer mWebViewContainer;
    ProgressBar mProgressBar;
    protected CssQDWebView mWebView;
    private String mUrl;
    private String mTitle;
    private ProgressHandler mProgressHandler;
    private boolean mIsPageFinished = false;
    private boolean mNeedDecodeUrl = false;
    private String msgId = "";
    private QMUITipDialog tipDialog;

    @Override
    protected void initExtraData() {
        this.mTitle = this.getIntent().getStringExtra(Constants.KEY_DETAIL_NAME);
        this.msgId = this.getIntent().getStringExtra(Constants.KEY_DETAIL_ID);
    }

    @Override
    public int getLayoutId() {
        return R.layout.css_activity_webexplorer;
    }

    @Override
    public void initView() {
        this.mTopBarLayout = (QMUITopBarLayout)this.findViewById(R.id.topbar);
        this.mWebViewContainer = (QMUIWebViewContainer)this.findViewById(R.id.webview_container);
        this.mProgressBar = (ProgressBar)this.findViewById(R.id.progress_bar);
        this.initTopbar();
        this.mProgressHandler = new ProgressHandler();
    }

    @Override
    public void initData() {
        this.requestData();
    }

    protected void initTopbar() {
        this.mTopBarLayout.addRightImageButton(R.drawable.css_icon_close_small, R.drawable.css_icon_close).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CssWebExplorerActivity.this.finish();
            }
        });
        this.updateTitle(this.mTitle);
    }

    public void finish() {
        Intent intent = new Intent();
        intent.putExtra(Constants.KEY_ORDER_CHANGE_TYPE, Constants.SYSTEM_MSG_READED);
        intent.putExtra(Constants.KEY_ORDER_ID, this.msgId);
        this.setResult(19, intent);
        super.finish();
    }

    protected boolean needDispatchSafeAreaInset() {
        return false;
    }

    protected void initWebView() {
        this.mWebView = new CssQDWebView((Context)this);
        boolean needDispatchSafeAreaInset = this.needDispatchSafeAreaInset();
        this.mWebViewContainer.addWebView((QMUIWebView)this.mWebView, needDispatchSafeAreaInset);
        this.mWebViewContainer.setCustomOnScrollChangeListener(new QMUIWebView.OnScrollChangeListener(){

            public void onScrollChange(View v, int scrollX, int scrollY, int oldScrollX, int oldScrollY) {
                CssWebExplorerActivity.this.onScrollWebContent(scrollX, scrollY, oldScrollX, oldScrollY);
            }
        });
        FrameLayout.LayoutParams containerLp = (FrameLayout.LayoutParams)this.mWebViewContainer.getLayoutParams();
        this.mWebViewContainer.setFitsSystemWindows(!needDispatchSafeAreaInset);
        containerLp.topMargin = needDispatchSafeAreaInset ? 0 : QMUIResHelper.getAttrDimen((Context)this, (int)R.attr.qmui_topbar_height);
        this.mWebViewContainer.setLayoutParams((ViewGroup.LayoutParams)containerLp);
        this.mWebView.setWebChromeClient(new WebChromeClient(){

            public void onProgressChanged(WebView view, int newProgress) {
                super.onProgressChanged(view, newProgress);
                if (newProgress > CssWebExplorerActivity.this.mProgressHandler.mDstProgressIndex) {
                    CssWebExplorerActivity.this.sendProgressMessage(0, newProgress, 100);
                }
            }

            public void onReceivedTitle(WebView view, String title) {
                super.onReceivedTitle(view, title);
                CssWebExplorerActivity.this.updateTitle(view.getTitle());
            }

            public void onShowCustomView(View view, WebChromeClient.CustomViewCallback callback) {
                callback.onCustomViewHidden();
            }
        });
        this.mWebView.setWebViewClient((WebViewClient)this.getWebViewClient());
        this.mWebView.requestFocus(130);
        CssWebExplorerActivity.setZoomControlGone((WebView)this.mWebView);
        this.configWebView(this.mWebViewContainer, this.mWebView);
        this.mWebView.loadUrl(this.mUrl);
    }

    protected void configWebView(QMUIWebViewContainer webViewContainer, QMUIWebView webView) {
    }

    protected void onScrollWebContent(int scrollX, int scrollY, int oldScrollX, int oldScrollY) {
    }

    private void handleUrl(String url) {
        if (this.mNeedDecodeUrl) {
            String decodeURL;
            try {
                decodeURL = URLDecoder.decode(url, "utf-8");
            }
            catch (UnsupportedEncodingException ignored) {
                decodeURL = url;
            }
            this.mUrl = decodeURL;
        } else {
            this.mUrl = url;
        }
    }

    protected QMUIWebViewClient getWebViewClient() {
        return new ExplorerWebViewClient(this.needDispatchSafeAreaInset());
    }

    public void onDestroy() {
        super.onDestroy();
        this.mWebViewContainer.destroy();
        this.mWebView = null;
    }

    public static void setZoomControlGone(WebView webView) {
        webView.getSettings().setDisplayZoomControls(false);
    }

    private void sendProgressMessage(int progressType, int newProgress, int duration) {
        Message msg = new Message();
        msg.what = progressType;
        msg.arg1 = newProgress;
        msg.arg2 = duration;
        this.mProgressHandler.sendMessage(msg);
    }

    private void updateTitle(String title) {
        if (title != null && !title.equals("")) {
            this.mTitle = title;
            this.mTopBarLayout.setTitle(this.mTitle);
        }
    }

    private void hideLoading() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                CssWebExplorerActivity.this.tipDialog.dismiss();
            }
        });
    }

    private void showLoading() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                CssWebExplorerActivity.this.tipDialog = new QMUITipDialog.Builder((Context)CssWebExplorerActivity.this).setIconType(1).setTipWord((CharSequence)CssWebExplorerActivity.this.getResources().getString(R.string.css_string_loading)).create();
                CssWebExplorerActivity.this.tipDialog.show();
            }
        });
    }

    private void requestData() {
        this.showLoading();
        BusinessRequest.getSystemMsgDetail(this.msgId, new RequestCallback<SystemMsgDetailEntity>(){

            @Override
            public void onSuccess(final SystemMsgDetailEntity result) {
                CssWebExplorerActivity.this.hideLoading();
                if (result == null) {
                    CssWebExplorerActivity.this.showError(CssWebExplorerActivity.this.getResources().getString(R.string.css_string_system_error));
                    return;
                }
                CssWebExplorerActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        CssWebExplorerActivity.this.mUrl = result.content;
                        CssWebExplorerActivity.this.initWebView();
                        if (!TextUtils.isEmpty((CharSequence)result.title)) {
                            CssWebExplorerActivity.this.updateTitle(result.title);
                        }
                    }
                });
            }

            @Override
            public void onFail(String msg, int code) {
                CssWebExplorerActivity.this.hideLoading();
                CssWebExplorerActivity.this.showError(code);
            }
        });
    }

    private class ProgressHandler
    extends Handler {
        private int mDstProgressIndex;
        private int mDuration;
        private ObjectAnimator mAnimator;

        private ProgressHandler() {
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    CssWebExplorerActivity.this.mIsPageFinished = false;
                    this.mDstProgressIndex = msg.arg1;
                    this.mDuration = msg.arg2;
                    CssWebExplorerActivity.this.mProgressBar.setVisibility(0);
                    if (this.mAnimator != null && this.mAnimator.isRunning()) {
                        this.mAnimator.cancel();
                    }
                    this.mAnimator = ObjectAnimator.ofInt((Object)CssWebExplorerActivity.this.mProgressBar, (String)"progress", (int[])new int[]{this.mDstProgressIndex});
                    this.mAnimator.setDuration((long)this.mDuration);
                    this.mAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                        public void onAnimationEnd(Animator animation) {
                            if (CssWebExplorerActivity.this.mProgressBar.getProgress() == 100) {
                                ProgressHandler.this.sendEmptyMessageDelayed(1, 500L);
                            }
                        }
                    });
                    this.mAnimator.start();
                    break;
                }
                case 1: {
                    this.mDstProgressIndex = 0;
                    this.mDuration = 0;
                    CssWebExplorerActivity.this.mProgressBar.setProgress(0);
                    CssWebExplorerActivity.this.mProgressBar.setVisibility(8);
                    if (this.mAnimator != null && this.mAnimator.isRunning()) {
                        this.mAnimator.cancel();
                    }
                    this.mAnimator = ObjectAnimator.ofInt((Object)CssWebExplorerActivity.this.mProgressBar, (String)"progress", (int[])new int[]{0});
                    this.mAnimator.setDuration(0L);
                    this.mAnimator.removeAllListeners();
                    CssWebExplorerActivity.this.mIsPageFinished = true;
                    break;
                }
            }
        }
    }

    protected class ExplorerWebViewClient
    extends QMUIWebViewClient {
        public ExplorerWebViewClient(boolean needDispatchSafeAreaInset) {
            super(needDispatchSafeAreaInset, true);
        }

        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            super.onPageStarted(view, url, favicon);
            if (QMUILangHelper.isNullOrEmpty((CharSequence)CssWebExplorerActivity.this.mTitle)) {
                CssWebExplorerActivity.this.updateTitle(view.getTitle());
            }
            if (CssWebExplorerActivity.this.mProgressHandler.mDstProgressIndex == 0) {
                CssWebExplorerActivity.this.sendProgressMessage(0, 30, 500);
            }
        }

        public void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, url);
            CssWebExplorerActivity.this.sendProgressMessage(1, 100, 0);
            if (QMUILangHelper.isNullOrEmpty((CharSequence)CssWebExplorerActivity.this.mTitle)) {
                CssWebExplorerActivity.this.updateTitle(view.getTitle());
            }
        }
    }
}

