package com.css.sdk.cservice.utils;

import android.content.Context;
import android.text.TextUtils;

import com.css.sdk.cservice.data.FaqItem;

import java.util.ArrayList;
import java.util.List;

/**
 * @ProjectName: customerservicesdk
 * @Package: com.css.sdk.cservice.utils
 * @ClassName: DataFilter
 * @Description: DataFilter
 * @Author: Roy
 * @CreateDate: 2020/5/25 15:11
 */

public class DataFilter {

    // 根据语言显示faq
    public static List<FaqItem> fitLanguageData(Context context, List<FaqItem> data) {
        boolean isZhSimple = false;
        boolean isZhTrandition = false;
        if (data.isEmpty()) {
            return data;
        }
        ArrayList list = new ArrayList<String>();
        if (LocalInfo.getLanguage(context)== LocalInfo.LocalLanguage.ZHSIMPLE){
            isZhSimple = true;
        }else if(LocalInfo.getLanguage(context)== LocalInfo.LocalLanguage.ZHTrandition){
            isZhTrandition=true;
        }
        if (isZhSimple) {
            for (FaqItem item : data) {
                if (!TextUtils.isEmpty(item.questionZhSimple)) {
                    list.add(item);
                }
            }
            return list;
        }
        if (isZhTrandition) {
            for (FaqItem item : data) {
                if (!TextUtils.isEmpty(item.questionZh)) {
                    list.add(item);
                }
            }
            return list;
        }
        for (FaqItem item : data) {
            if (!TextUtils.isEmpty(item.questionEn)) {
                list.add(item);
            }
        }
        return list;
    }

}
