package com.css.sdk.cservice.request;

import android.text.TextUtils;
import android.util.Log;

import com.css.sdk.BuildConfig;
import com.css.sdk.cservice.base.http.HttpClientHelper;
import com.css.sdk.cservice.base.http.HttpResponse;
import com.css.sdk.cservice.base.http.HttpsClientHelper;
import com.css.sdk.cservice.base.http.UrlQuery;
import com.css.sdk.cservice.base.utils.LogUtils;
import com.css.sdk.cservice.base.utils.NetUtils;
import com.css.sdk.cservice.base.utils.Utils;
import com.css.sdk.cservice.userdata.GlobalData;

import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;

import static com.css.sdk.cservice.adapter.GridImageAdapter.TAG;
import static com.css.sdk.cservice.base.CSSErrors.CSS_ERROR_RESPONSE_HTTP_EXCEPTION;
import static com.css.sdk.cservice.base.CSSErrors.CSS_NO_NETWORK_OR_CONTEXT_NULL;

public class HttpRequest {

    public static void requestHttpByPost(final String url, final Map<String, String> params, final HttpCallback<String> callback) {
        HttpThread.execute(new RunWrapper(new Runnable() {
            @Override
            public void run() {
                int code = 0;
                String result = null;
                String request = null;
                if (params != null && params.size() > 0) {
                    request = new UrlQuery().addParams(params).toString();
                }
                try {
                    HttpResponse response = HttpClientHelper.httpPost(url, request, null);
                    code = response.getResponseCode();
                    String temp=response.getBody();
                    if (code == 200) {
                        result = temp;
                    }
                } catch (UnknownHostException e) {
                    if (GlobalData.getContext() != null && NetUtils.isNetworkAvailable(GlobalData.getContext())) {
                        retryRequestByHttpDns(url, request, callback, e);
                    } else {
                        callback.onResponedFail(e, CSS_NO_NETWORK_OR_CONTEXT_NULL);
                    }
                    return;
                } catch (Throwable e) {
                    if (null != callback) {
                        if (GlobalData.getContext() != null && !NetUtils.isNetworkAvailable(GlobalData.getContext())){
                            callback.onResponedFail(e, CSS_NO_NETWORK_OR_CONTEXT_NULL);
                        }else {
                            callback.onResponedFail(e, CSS_ERROR_RESPONSE_HTTP_EXCEPTION);
                        }
                    }
                    return;
                }


                if (null != callback) {
                    if (200 == code) {
                        callback.onResponseSuccess(result);
                    } else {
                        callback.onResponedFail(new Exception("Url is:" + url), code);
                    }
                }
            }
        }));
    }

    public static void requestUploadByPost(final String url, final Map<String, String> params, final List<String> files, final HttpCallback<String> callback) {
        HttpThread.execute(new RunWrapper(new Runnable() {
            @Override
            public void run() {
                int code = 0;
                String result = null;
                try {
                    HttpResponse response = HttpClientHelper.httpUpload(url, params, files);
                    code = response.getResponseCode();
                    if (code == 200) {
                        result = response.getBody();
                        LogUtils.i("requestUploadByPost: code "+code+" result :"+result);
                    }else{
                        LogUtils.i("requestUploadByPost: code "+code+" result :"+result);
                    }
                    if (null != callback) {
                        if (200 == code) {
                            callback.onResponseSuccess(result);
                        } else {
                            callback.onResponedFail(new Exception("Url is:" + url), code);
                        }
                    }
                } catch (Throwable e) {

                    e.printStackTrace();
                    if (null != callback) {
                        callback.onResponedFail(e, CSS_ERROR_RESPONSE_HTTP_EXCEPTION);
                    }
                    return;
                }
            }
        }));
    }

    private static void retryRequestByHttpDns(final String url, final String request, final HttpCallback<String> callback, final Exception e) {


        if (TextUtils.isEmpty(HttpDnsManager.getUrlDomain())) {
            HttpDnsManager.addDnsMappingServers(BuildConfig.CSERVICE_DOMAIN, BuildConfig.CSERVICE_DNS_URL);
        }
        HttpDnsManager.callForClientDnsIp(new HttpCallback<String>() {
            @Override
            public void onResponseSuccess(String result) {
                try {
                    String urlDomain = HttpDnsManager.getUrlDomain();
                    if (!TextUtils.isEmpty(urlDomain)) {
                        ArrayList<String> sClientDnsIpList = Utils.getShuffleList(HttpDnsManager.getDnsMap().get(urlDomain));
                        if (sClientDnsIpList == null || sClientDnsIpList.isEmpty()) {
                            callback.onResponedFail(new Exception("HttpRequest has error: " + e.getMessage()), -1);
                            return;
                        }

                        doRequestByHttpAfterDnsGot(url, request, urlDomain, 0, callback, sClientDnsIpList);

                    } else {
                        callback.onResponedFail(e, -1);
                    }
                } catch (Throwable e1) {
                    e1.printStackTrace();
                    callback.onResponedFail(e1, -1);
                }
            }

            @Override
            public void onResponedFail(Throwable e, int code) {
                callback.onResponedFail(e, code);
            }
        });
    }

    private static void doRequestByHttpAfterDnsGot(final String originalUrl, final String request, final String domain, final int index, final HttpCallback callback, final ArrayList<String> clientDnsIpList) {
        LogUtils.i("HttpRequest doRequestByHttpAfterDnsGot index is " + index);
        String newUrl = originalUrl.replace(domain, clientDnsIpList.get(index));
//        newUrl = newUrl.replace("https", "http");
        LogUtils.i("HttpRequest doRequestByHttpAfterDnsGot url is \n" + newUrl);
        try {
            HttpResponse response = null;
            if (originalUrl.startsWith("http://")) {
                response = HttpClientHelper.httpPost(newUrl, request, null);
            } else {
                response = HttpsClientHelper.httpPost(newUrl, request, null);
            }
            int code = response.getResponseCode();
            if (code == 200) {
                String result = response.getBody();
                callback.onResponseSuccess(result);
            } else {
                callback.onResponedFail(new Exception("orginalUrl is:" + originalUrl + ", newUrl is :" + newUrl), code);
            }
        } catch (Throwable e) {
            //没有网络的判断
            if (GlobalData.getContext() == null || !NetUtils.isNetworkAvailable(GlobalData.getContext())) {
                callback.onResponedFail(e, CSS_NO_NETWORK_OR_CONTEXT_NULL);
                return;
            }

            final String msg = e.getMessage();
            // 超时，最大遍历所有的ip
            int max = 3;
            if (e instanceof SocketTimeoutException || e instanceof TimeoutException) {
                max = clientDnsIpList.size();
            }
            LogUtils.i(" Throwable in HttpRequest doRequestByHttpAfterDnsGot url is \n" + e.getMessage());
            int i = index + 1;
            if (i < Math.min(max, clientDnsIpList.size())) {
                doRequestByHttpAfterDnsGot(originalUrl, request, domain, i, callback, clientDnsIpList);
            } else {
                callback.onResponedFail(new Exception(msg), -1);
            }
        }
    }


    public static void requestHttpByPost(final String url, final Map<String, String> requestParams, final Map<String, String> heardMap, final HttpCallback<String> callback) {
        HttpThread.execute(new RunWrapper(new Runnable() {
            @Override
            public void run() {
                int code = 0;
                String result = null;
                String request = null;
                if (requestParams != null && requestParams.size() > 0) {
                    request = new UrlQuery().addParams(requestParams).toString();
                }
                try {
                    HttpResponse response = HttpClientHelper.httpPost(url, request, heardMap, null, "UTF-8");
                    code = response.getResponseCode();
                    if (code == 200) {
                        result = response.getBody();
                    }
                } catch (UnknownHostException e) {
                    //没有网络的判断
                    if (GlobalData.getContext() == null || !NetUtils.isNetworkAvailable(GlobalData.getContext())) {
                        callback.onResponedFail(e, CSS_NO_NETWORK_OR_CONTEXT_NULL);
                        return;
                    }
                    retryRequestByHttpDns2(url, request, heardMap, callback, e);
                    return;
                } catch (Throwable e) {
                    if (null != callback) {
                        callback.onResponedFail(e, CSS_ERROR_RESPONSE_HTTP_EXCEPTION);
                    }
                    return;
                }

                if (null != callback) {
                    if (200 == code) {
                        callback.onResponseSuccess(result);
                    } else {
                        callback.onResponedFail(new Exception("Url is :" + url), code);
                    }
                }
            }
        }));
    }

    private static void retryRequestByHttpDns2(final String url, final String request, final Map<String, String> heardMap, final HttpCallback<String> callback, final Exception e) {
        if (TextUtils.isEmpty(HttpDnsManager.getUrlDomain())) {
            HttpDnsManager.addDnsMappingServers(BuildConfig.CSERVICE_DOMAIN, BuildConfig.CSERVICE_DNS_URL);
        }
        HttpDnsManager.callForClientDnsIp(new HttpCallback<String>() {
            @Override
            public void onResponseSuccess(String result) {
                try {
                    String urlDomain = HttpDnsManager.getUrlDomain();
                    if (!TextUtils.isEmpty(urlDomain)) {

                        ArrayList<String> sClientDnsIpList = Utils.getShuffleList(HttpDnsManager.getDnsMap().get(urlDomain));
                        if (sClientDnsIpList == null || sClientDnsIpList.isEmpty()) {
                            callback.onResponedFail(new Exception("HttpRequest has error: " + e.getMessage()), -1);
                            return;
                        }

                        doRequestByHttpAfterDnsGot2(url, request, heardMap, urlDomain, 0, callback, sClientDnsIpList);

                    } else {
                        callback.onResponedFail(e, -1);
                    }
                } catch (Throwable e1) {
                    LogUtils.i(" Throwable in HttpRequest retryRequestByHttpDns2 url is \n" + e.getMessage());
                    e1.printStackTrace();
                    callback.onResponedFail(e1, -1);
                }
            }

            @Override
            public void onResponedFail(Throwable e, int code) {
                callback.onResponedFail(e, code);
            }
        });
    }

    private static void doRequestByHttpAfterDnsGot2(final String originalUrl, final String request, final Map<String, String> heardMap, final String domain, final int index, final HttpCallback callback, final ArrayList<String> clientDnsIpList) {
        String newUrl = originalUrl.replace(domain, clientDnsIpList.get(index));
//        newUrl = newUrl.replace("https", "http");
        LogUtils.i("HttpRequest doRequestByHttpAfterDnsGot2 url is \n" + newUrl);
        try {
            HttpResponse response = HttpClientHelper.httpPost(newUrl, request, heardMap, null, "UTF-8");
            int code = response.getResponseCode();
            if (code == 200) {
                String result = response.getBody();
                callback.onResponseSuccess(result);
            } else {
                callback.onResponedFail(new Exception("orginalUrl is:" + originalUrl + ", newUrl is :" + newUrl), code);
            }
        } catch (Throwable e) {
            //没有网络的判断
            if (GlobalData.getContext() == null || !NetUtils.isNetworkAvailable(GlobalData.getContext())) {
                callback.onResponedFail(e, CSS_NO_NETWORK_OR_CONTEXT_NULL);
                return;
            }
            final String msg = e.getMessage();
            int i = index + 1;
            // 超时，最大遍历所有的ip
            int max = 3;
            if (e instanceof SocketTimeoutException || e instanceof TimeoutException) {
                max = clientDnsIpList.size();
            }
            if (i < Math.min(max, clientDnsIpList.size())) {
                doRequestByHttpAfterDnsGot2(originalUrl, request, heardMap, domain, i, callback, clientDnsIpList);
            } else {
                callback.onResponedFail(new Exception(msg), -1);
            }
        }
    }


}
