package com.css.sdk.cservice.refresh;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.LinearInterpolator;
import android.widget.AbsListView;
import android.widget.ImageView;
import android.widget.TextView;

import com.css.sdk.R;

class HeadManager implements Swipe.OnChangeViewHeight, Swipe.OnChangeViewTip {
    private ViewGroup headView;
    private TextView tvHeadTip;
    private Context mContext;
    private int refreshViewHeight;
    private ImageView ivHeadArrow;
    private ImageView ivHeadRefresh;
    private TextView tvRefreshTime;

    HeadManager(Context context, RefreshLayout refreshLayout) {
        this.mContext = context;
        if (refreshLayout != null) {
            refreshViewHeight = refreshLayout.REFRESH_VIEW_HEIGHT_DP;
            refreshLayout.setOnChangeViewTip(this);
            refreshLayout.setOnChangeViewHeight(this);
        }
    }

    public View getHeadView() {
        headView = (ViewGroup) LayoutInflater.from(mContext).inflate(R.layout.css_refresh_head, null, false);
        headChildView = headView.getChildAt(0);
        headChildViewLayoutParams = headChildView.getLayoutParams();
        headChildViewLayoutParams.height = 0;
        headChildView.setLayoutParams(headChildViewLayoutParams);
        headViewLayoutParams = new AbsListView.LayoutParams(-1, 0);
        headView.setLayoutParams(headViewLayoutParams);
        tvHeadTip = headView.findViewById(R.id.css_tv_head_tip);
        ivHeadArrow = headView.findViewById(R.id.css_iv_head_arrow);
        ivHeadArrow.animate().setInterpolator(new LinearInterpolator());
        ivHeadRefresh = headView.findViewById(R.id.css_iv_head_refresh);
        ivHeadRefresh.animate().setInterpolator(new LinearInterpolator());
        tvRefreshTime = headView.findViewById(R.id.css_tv_refresh_time);
        if (!TextUtils.isEmpty(Swipe.getLastRefreshTime(mContext))) {
            StringBuilder sb = new StringBuilder();
            sb.append(mContext.getString(R.string.css_string_last_update_time)).append(Swipe.getLastRefreshTime(mContext));
            this.tvRefreshTime.setText(sb.toString());
        } else {
            this.tvRefreshTime.setVisibility(View.GONE);
        }
        return headView;
    }

    public void setHeadView(ViewGroup headView) {
        /*
         * 如果想让listview的item高度为0，只有当该viewgroup本身高度和其所有子view高度为0才能实现，
         * 所以，为了视觉效果，强烈建议自定义头view时让布局包裹一个viewgroup，再在该viewgroup中进行布局
         */
        this.headView = headView;
        if (headView.getChildCount() == 1) {
            headChildView = headView.getChildAt(0);
            headChildViewLayoutParams = headChildView.getLayoutParams();
            headChildViewLayoutParams.height = 0;
            headChildView.setLayoutParams(headChildViewLayoutParams);
            headViewLayoutParams = new AbsListView.LayoutParams(-1, 0);
        } else {
            headViewLayoutParams = new AbsListView.LayoutParams(-1, 1);
        }
        headView.setLayoutParams(headViewLayoutParams);
    }

    private ViewGroup.LayoutParams headViewLayoutParams;
    private ViewGroup.LayoutParams headChildViewLayoutParams;
    private View headChildView;
    private int tempHeight;

    @Override
    public void changeHeadViewHeight(int headViewHeight) {
        if (headView != null && headViewHeight >= 0) {
            if (headChildView == null && headViewHeight == 0) {
                headViewHeight = 1;
            }
            headViewLayoutParams.height = headViewHeight;
            headView.setLayoutParams(headViewLayoutParams);
        }
        if (headChildView != null && headViewHeight >= 0) {
            headChildViewLayoutParams.height = headViewHeight == 0 ? 0 : refreshViewHeight;
            if (tempHeight != headChildViewLayoutParams.height) {
                headChildView.setLayoutParams(headChildViewLayoutParams);
                tempHeight = headChildViewLayoutParams.height;
            }
        }
    }

    private int currentHeadTips = 0;

    @Override
    public void changeHeadTips(int tips) {
        if (currentHeadTips != tips) {
            currentHeadTips = tips;
            if (tvHeadTip != null) {
                tvHeadTip.setText(tips);
            }
            if (ivHeadArrow != null && ivHeadRefresh != null) {
                if (tips == RefreshLayout.PULL_DOWN) {
                    ivHeadArrow.setVisibility(View.VISIBLE);
                    ivHeadRefresh.setVisibility(View.GONE);
                    ivHeadArrow.animate().rotation(0);
                } else if (tips == RefreshLayout.RELEASE_REFRESH) {
                    ivHeadArrow.setVisibility(View.VISIBLE);
                    ivHeadRefresh.setVisibility(View.GONE);
                    ivHeadArrow.animate().rotation(180);
                } else if (tips == RefreshLayout.REFRESHING) {
                    ivHeadArrow.setVisibility(View.GONE);
                    ivHeadRefresh.setVisibility(View.VISIBLE);
                    ivHeadArrow.animate().rotation(0);
                    ivHeadRefresh.animate().rotation(360 * 60 * 10).setDuration(10 * 60 * 1000);
                } else if (tips == RefreshLayout.REFRESH_FINISH) {
                    String time = Swipe.saveLastRefreshTime(mContext);
                    if (tvRefreshTime.getVisibility() != View.VISIBLE) {
                        tvRefreshTime.setVisibility(View.VISIBLE);
                    }
                    StringBuilder sb = new StringBuilder();
                    sb.append(mContext.getString(R.string.css_string_last_update_time)).append(time);
                    tvRefreshTime.setText(sb.toString());
                    ivHeadRefresh.animate().cancel();
                } else {
                    ivHeadArrow.animate().cancel();
                    ivHeadRefresh.setVisibility(View.GONE);
                }
            }
        }
    }
}
