package com.css.sdk.cservice.data;

import com.css.sdk.cservice.constant.SubmitEntryModelEnum;

import org.json.JSONObject;

public class ProductUIConfigEntity {
    public String color;
    public SubmitEntryModelEnum modelEnum;

    public ProductUIConfigEntity(String color, SubmitEntryModelEnum modelEnum) {
        this.color = color;
        this.modelEnum = modelEnum;
    }

    public void parseJsonString(JSONObject jsonObject) throws Exception {
        this.color = jsonObject.optString("color").trim();
        String modelStr= jsonObject.optString("submitEntryModel");
        if (modelStr.toLowerCase().equals("normal")){
            modelEnum=SubmitEntryModelEnum.NORMAL;
        }else{
            modelEnum=SubmitEntryModelEnum.WEAK;
        }
    }

    @Override
    public String toString() {
        return "ProductUIConfigEntity{" +
                "color='" + color + '\'' +
                ", modelEnum=" + modelEnum +
                '}';
    }
}
