package com.css.sdk.cservice.data;

import org.json.JSONObject;

public class HistoryItem {
    public long id;
    /**
     * 待处理    WAITING
     * 待处理（追问）    WAITING_APPEND
     * 处理中    PROCESSING
     * 已处理    PROCESSED
     * 已处理（已读）    PROCESSED_READ
     * 已关闭    CLOSED
     * 已移除    DELETED
     * 超时关闭 CLOSE_TIMEOUT
     */
    public String status;
    public String title;
    public int pdtid;

    public void parseJsonString(JSONObject jsonObject) throws Exception {
        this.id = jsonObject.getLong("id");
        this.status = jsonObject.getString("status");
        this.title = jsonObject.getString("title");
        this.pdtid = jsonObject.getInt("pdtid");
    }

    @Override
    public String toString() {
        return "HistoryItem{" +
                "id=" + id +
                ", status='" + status + '\'' +
                ", title='" + title + '\'' +
                ", pdtid='" + pdtid + '\'' +
                '}';
    }
}
