package com.css.sdk.cservice.data;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;

public class Chat {
    public String send;//ask:用户，answer:客服
    public String original;
    public String translation = "";
    public String time;
    public ArrayList<String> pics = new ArrayList<>();
    public ArrayList<String> videos = new ArrayList<>();

    public void parseJsonString(JSONObject jsonObject) throws Exception{
        this.send = jsonObject.getString("send");
        this.original = jsonObject.getString("original");
        if(jsonObject.has("translation")){
            this.translation = jsonObject.getString("translation");
        }
        this.time = jsonObject.getString("time");
        if(jsonObject.has("pic")){
            JSONArray list = jsonObject.getJSONArray("pic");
            for (int i = 0; i < list.length(); i++) {
                pics.add(list.get(i).toString());
            }
        }
        if(jsonObject.has("video")){
            JSONArray list = jsonObject.getJSONArray("video");
            for (int i = 0; i < list.length(); i++) {
                videos.add(list.get(i).toString());
            }
        }
    }

    @Override
    public String toString() {
        return "Chat{" +
                "send='" + send + '\'' +
                ", original='" + original + '\'' +
                ", translation='" + translation + '\'' +
                ", time='" + time + '\'' +
                ", pics=" + pics +
                ", videos=" + videos +
                '}';
    }
}
