package com.css.sdk.cservice.business;

import android.content.Context;
import android.os.Looper;
import android.support.annotation.MainThread;
import android.text.TextUtils;
import android.widget.Button;

import com.css.sdk.BuildConfig;
import com.css.sdk.cservice.base.CSSErrors;
import com.css.sdk.cservice.base.Constants;
import com.css.sdk.cservice.base.utils.CpLog;
import com.css.sdk.cservice.base.utils.DeviceInfoHelper;
import com.css.sdk.cservice.base.utils.LogUtils;
import com.css.sdk.cservice.constant.SubmitEntryModelEnum;
import com.css.sdk.cservice.data.FaqDetail;
import com.css.sdk.cservice.data.FaqItem;
import com.css.sdk.cservice.data.FaqTypeItem;
import com.css.sdk.cservice.data.HistoryItem;
import com.css.sdk.cservice.data.OrderDetail;
import com.css.sdk.cservice.data.Picture;
import com.css.sdk.cservice.data.ProductUIConfigEntity;
import com.css.sdk.cservice.data.SystemMsgDetailEntity;
import com.css.sdk.cservice.data.SystemMsgEntity;
import com.css.sdk.cservice.data.SystemNoticeItem;
import com.css.sdk.cservice.listener.CSSExistNewReplyCallback;
import com.css.sdk.cservice.request.HttpCallback;
import com.css.sdk.cservice.request.HttpRequest;
import com.css.sdk.cservice.request.URLConstant;
import com.css.sdk.cservice.userdata.AASHelper;
import com.css.sdk.cservice.userdata.GlobalData;
import com.css.sdk.cservice.utils.LocalInfo;

import org.json.JSONArray;
import org.json.JSONObject;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

import static com.css.sdk.cservice.base.Constants.JSON_PICNAME;
import static com.css.sdk.cservice.base.Constants.JSON_VIDEONAME;

public class BusinessRequest {
    // 用于exist方法的调用限制
    private static AtomicLong existIsCalledLastTime = new AtomicLong(0);

    // 存放exist的回调
    private static List<CSSExistNewReplyCallback> newReplyCallBacks = new CopyOnWriteArrayList<>();

    /**
     * @param
     * @return
     * @description 获得系统消息详情
     */
    public static void getSystemMsgDetail(String msgId,RequestCallback<SystemMsgDetailEntity> callback) {
        String url = URLConstant.getSystemMsgDetail() + "?message_id="+msgId +"&"+ getCommonValue();
        LogUtils.i("getSystemMsgDetail : " + url);
        HttpRequest.requestHttpByPost(url, null, new HttpCallback<String>() {
            @Override
            public void onResponseSuccess(String result) {
                try {
                    JSONObject jsonObject = new JSONObject(result);
                    int code = jsonObject.getInt("code");
                    boolean isSuccess = jsonObject.getBoolean("success");
                    JSONObject data = jsonObject.getJSONObject("data");
                    JSONObject message = data.getJSONObject("message");
                    SystemMsgDetailEntity item = new SystemMsgDetailEntity();
                    item.parseJsonString(message);
                    if (code == 200 && isSuccess) {
                        callback.onSuccess(item);
                    } else {
                        callback.onFail("", code);
                    }
                } catch (Throwable e) {
                    LogUtils.w("getSystemMsgDetail has error :" + e.getMessage(), e);
                    callback.onFail(e.getMessage(), CSSErrors.CSS_ERROR_RESPONSE_JSON_EXCEPTION);
                }
            }

            @Override
            public void onResponedFail(Throwable e, int code) {
                callback.onFail(e.getMessage(), code);
            }
        });
    }





    /**
     * @param
     * @return
     * @description 获得产品提交时可用类型
     */
    public static void getSubmitFaqTypeList(final RequestCallback<List<FaqTypeItem>> callback) {
        String url = URLConstant.getSubmitTypeList() + "?" + getCommonValue();
        LogUtils.i("getSubmitFaqTypeList url is " + url);
        HttpRequest.requestHttpByPost(url, null, new HttpCallback<String>() {
            @Override
            public void onResponseSuccess(String result) {
                try {
                    JSONObject jsonObject = new JSONObject(result);
                    int code = jsonObject.getInt("code");
                    boolean isSuccess = jsonObject.getBoolean("success");
                    String msg = jsonObject.getString("message");
                    ArrayList<FaqTypeItem> list = new ArrayList<>();
                    if (jsonObject.has("data")) {
                        JSONObject data = jsonObject.getJSONObject("data");
                        JSONArray items = data.getJSONArray("types");
                        JSONObject row = null;
                        for (int i = 0; i < items.length(); i++) {
                            row = items.getJSONObject(i);
                            FaqTypeItem item = new FaqTypeItem();
                            item.parseJsonString(row);
                            list.add(item);
                        }
                    }
                    if (code == 200 && isSuccess) {
                        callback.onSuccess(list);
                    } else {
                        callback.onFail(msg, code);
                    }
                } catch (Throwable e) {
                    LogUtils.w("getSubmitFaqTypeList has error :" + e.getMessage(), e);
                    callback.onFail(e.getMessage(), CSSErrors.CSS_ERROR_RESPONSE_JSON_EXCEPTION);
                }
            }

            @Override
            public void onResponedFail(Throwable e, int code) {
                LogUtils.i("faqTypelist onResponedFail is " + code + " error " + e.getMessage());
                callback.onFail(e.getMessage(), code);
            }
        });
    }


    /**
     * @param
     * @return
     * @description 获得系统公告
     */
    public static void getSystemNoticeList(RequestCallback<ArrayList<SystemNoticeItem>> callback) {
        String url = URLConstant.noticeList() + "?" + getCommonValue();
        LogUtils.i("getSystemNoticeList : " + url);
        HttpRequest.requestHttpByPost(url, null, new HttpCallback<String>() {
            @Override
            public void onResponseSuccess(String result) {
                try {
                    JSONObject jsonObject = new JSONObject(result);
                    int code = jsonObject.getInt("code");
                    boolean isSuccess = jsonObject.getBoolean("success");
                    String msg = jsonObject.getString("message");
                    JSONObject data = jsonObject.getJSONObject("data");
                    JSONArray items = data.getJSONArray("notices");
                    JSONObject row = null;
                    ArrayList<SystemNoticeItem> list = new ArrayList<>();
                    for (int i = 0; i < items.length(); i++) {
                        row = items.getJSONObject(i);
                        SystemNoticeItem item = new SystemNoticeItem();
                        item.parseJsonString(row);
                        list.add(item);
                    }
                    if (code == 200 && isSuccess) {
                        callback.onSuccess(list);
                    } else {
                        callback.onFail(msg, code);
                    }
                } catch (Throwable e) {
                    LogUtils.w("getSystemNoticeList has error :" + e.getMessage(), e);
                    callback.onFail(e.getMessage(), CSSErrors.CSS_ERROR_RESPONSE_JSON_EXCEPTION);
                }
            }

            @Override
            public void onResponedFail(Throwable e, int code) {
                callback.onFail(e.getMessage(), code);
            }
        });
    }

    /**
     * @param
     * @return
     * @description 获得系统UI配置
     */
    public static void getProductUIConfig(RequestCallback<ProductUIConfigEntity> callback) {
        String url = URLConstant.getProductUIConfig() + "?" + getCommonValue();
        LogUtils.i("getProductUIConfig : " + url);
        HttpRequest.requestHttpByPost(url, null, new HttpCallback<String>() {
            @Override
            public void onResponseSuccess(String result) {
                try {
                    JSONObject jsonObject = new JSONObject(result);
                    int code = jsonObject.getInt("code");
                    boolean isSuccess = jsonObject.getBoolean("success");
                    String msg = jsonObject.getString("message");
                    JSONObject data = jsonObject.getJSONObject("data");
                    ProductUIConfigEntity item = new ProductUIConfigEntity("", SubmitEntryModelEnum.NORMAL);
                    item.parseJsonString(data);
                    if (code == 200 && isSuccess) {
                        callback.onSuccess(item);
                    } else {
                        callback.onFail(msg, code);
                    }
                } catch (Throwable e) {
                    LogUtils.w("getProductUIConfig has error :" + e.getMessage(), e);
                    callback.onFail(e.getMessage(), CSSErrors.CSS_ERROR_RESPONSE_JSON_EXCEPTION);
                }
            }

            @Override
            public void onResponedFail(Throwable e, int code) {
                callback.onFail(e.getMessage(), code);
            }
        });
    }


    /**
     * @param
     * @return
     * @description 获得系统消息
     */
    public static void getSystemMsgList(RequestCallback<ArrayList<SystemMsgEntity>> callback) {
        String url = URLConstant.systemMsgList() + "?" + getCommonValue();
        LogUtils.i("getSystemMsgList : " + url);
        HttpRequest.requestHttpByPost(url, null, new HttpCallback<String>() {
            @Override
            public void onResponseSuccess(String result) {
                try {
                    JSONObject jsonObject = new JSONObject(result);
                    int code = jsonObject.getInt("code");
                    boolean isSuccess = jsonObject.getBoolean("success");
                    String msg = jsonObject.getString("message");
                    JSONObject data = jsonObject.getJSONObject("data");
                    JSONArray items = data.getJSONArray("messages");
                    JSONObject row = null;
                    ArrayList<SystemMsgEntity> list = new ArrayList<>();
                    for (int i = 0; i < items.length(); i++) {
                        row = items.getJSONObject(i);
                        SystemMsgEntity item = new SystemMsgEntity();
                        item.parseJsonString(row);
                        list.add(item);
                    }
                    if (code == 200 && isSuccess) {
                        callback.onSuccess(list);
                    } else {
                        callback.onFail(msg, code);
                    }
                } catch (Throwable e) {
                    LogUtils.w("getSystemMsgList has error :" + e.getMessage(), e);
                    callback.onFail(e.getMessage(), CSSErrors.CSS_ERROR_RESPONSE_JSON_EXCEPTION);
                }
            }

            @Override
            public void onResponedFail(Throwable e, int code) {
                callback.onFail(e.getMessage(), code);
            }
        });
    }


    public static void getHistoryList(int statusType, final RequestCallback<ArrayList<HistoryItem>> callback) {
        String url = URLConstant.getFqaHistory() + "?" + getCommonValue() + "&status_type=" + statusType;
        LogUtils.i("getHistoryList" + url);
        HttpRequest.requestHttpByPost(url, null, new HttpCallback<String>() {
            @Override
            public void onResponseSuccess(String result) {
                try {
                    JSONObject jsonObject = new JSONObject(result);
                    int code = jsonObject.getInt("code");
                    boolean isSuccess = jsonObject.getBoolean("success");
                    String msg = jsonObject.getString("message");
                    JSONObject data = jsonObject.getJSONObject("data");
                    JSONArray items = data.getJSONArray("questions");
                    JSONObject row = null;
                    ArrayList<HistoryItem> list = new ArrayList<>();
                    for (int i = 0; i < items.length(); i++) {
                        row = items.getJSONObject(i);
                        HistoryItem item = new HistoryItem();
                        item.parseJsonString(row);
                        list.add(item);
                    }
                    if (code == 200 && isSuccess) {
                        callback.onSuccess(list);
                    } else {
                        callback.onFail(msg, code);
                    }
                } catch (Throwable e) {
                    LogUtils.w("getHistoryList has error :" + e.getMessage(), e);
                    callback.onFail(e.getMessage(), CSSErrors.CSS_ERROR_RESPONSE_JSON_EXCEPTION);
                }
            }

            @Override
            public void onResponedFail(Throwable e, int code) {
                callback.onFail(e.getMessage(), code);
            }
        });
    }

    public static void getDetail(long questionId, final RequestCallback<OrderDetail> callback) {
        String url = URLConstant.getOderDetail() + "?" + getCommonValue() + "&questionId=" + questionId;
        LogUtils.i("getDetail url : " + url);
        HttpRequest.requestHttpByPost(url, null, new HttpCallback<String>() {
            @Override
            public void onResponseSuccess(String result) {
                LogUtils.i("getDetail onResponseSuccess : " + result);
                try {
                    JSONObject jsonObject = new JSONObject(result);
                    int code = jsonObject.getInt("code");
                    boolean isSuccess = jsonObject.getBoolean("success");
                    String msg = jsonObject.getString("message");

                    JSONObject data = jsonObject.getJSONObject("data");
                    OrderDetail detail = new OrderDetail();
                    detail.parseJsonString(data);

                    if (code == 200 && isSuccess) {
                        callback.onSuccess(detail);
                    } else {
                        callback.onFail(msg, code);
                    }
                } catch (Throwable e) {
                    LogUtils.w("getDetail has error :" + e.getMessage(), e);
                    callback.onFail(e.getMessage(), CSSErrors.CSS_ERROR_RESPONSE_JSON_EXCEPTION);
                }
            }

            @Override
            public void onResponedFail(Throwable e, int code) {
                LogUtils.i("getDetail onResponedFail : code " + code + " msg " + e.getMessage());
                callback.onFail(e.getMessage(), code);
            }
        });
    }

    public static void feedBackN(Context context, String questionId, List<Picture> pics, List<Picture> videos, List<Picture> cancelPics, int typeId, String type, String content, final RequestCallback<String> callback) {
        String url = URLConstant.feedbackNew();
        url += "?" + getCommonValue()
                + "&accept_media=Y"
                + "&type_id=" + (typeId == -1 ? "" : typeId)
                + "&type=" + type
                + "&device_model="
                + DeviceInfoHelper.getBuildModel().replace(" ", "-");

        try {
            String str = URLEncoder.encode(URLEncoder.encode(content, "UTF-8"), "UTF-8");
            url += "&content=" + str;
        } catch (Exception e) {

        }

        if (!TextUtils.isEmpty(questionId)) {
            url += "&questionId=" + questionId;
        }

        if (!pics.isEmpty()) {
            url += "&pics=" + list2String(pics);
        }
        if (!videos.isEmpty()) {
            url += "&videos=" + list2String(videos);
        }

        if (!cancelPics.isEmpty()) {
            url += "&cancelPics=" + list2String(cancelPics);
        }
        url = addDeviceInfoInUrl(context, url);
        LogUtils.i("feedBackN request url is " + url);
        HttpRequest.requestHttpByPost(url, null, new HttpCallback<String>() {
            @Override
            public void onResponseSuccess(String result) {
                LogUtils.i("feedBackN onResponseSuccess result is " + result);
                try {
                    JSONObject jsonObject = new JSONObject(result);
                    int code = jsonObject.getInt("code");
                    if (code == 200) {
                        callback.onSuccess(result);
                    } else if (code == 403) {
                        callback.onFail("feedback error ", CSSErrors.CSS_REPORT_LIMIT_EXCEPTION);
                    }
                } catch (Throwable e) {
                    LogUtils.w("feedBackN has error :" + e.getMessage(), e);
                    callback.onFail(e.getMessage(), CSSErrors.CSS_ERROR_RESPONSE_JSON_EXCEPTION);
                }
            }

            @Override
            public void onResponedFail(Throwable e, int code) {
                LogUtils.i("feedBackN onResponedFail code: " + code + " msg :" + e.getMessage());
                callback.onFail(e.getMessage(), code);
            }
        });
    }

    private static void addMediaInfo(HashMap<String, String> maps, String tag, String content) {
        maps.put(tag, content);
    }

    private static String addDeviceInfoInUrl(Context context, String url) {
        url += "&memory=" + DeviceInfoHelper.getTotalMemory(context);
        url += "&memory_used=" + DeviceInfoHelper.getAvailMemory(context);
        url += "&net_type=" + DeviceInfoHelper.getNetWorkType(context);
        try {
            url += "&cpu_model=" + URLEncoder.encode(URLEncoder.encode(DeviceInfoHelper.getCpuInfo(), "UTF-8"), "UTF-8");
            ;
        } catch (Exception e) {
        }
        return url;
    }

    private static String list2String(List<Picture> list) {
        StringBuilder sb = new StringBuilder();
        for (Picture picture : list) {
            sb.append(picture.getPicName()).append(",");
        }
        String result = sb.toString();

        return result.substring(0, result.length() - 1);
    }

    public static void delete(String questionId, final RequestCallback<String> callback) {
        String url = URLConstant.deleteWorkOrder() + "?" + getCommonValue() + "&questionId=" + questionId;
        HttpRequest.requestHttpByPost(url, null, new HttpCallback<String>() {
            @Override
            public void onResponseSuccess(String result) {
                try {
                    JSONObject jsonObject = new JSONObject(result);
                    int code = jsonObject.getInt("code");
                    boolean isSuccess = jsonObject.getBoolean("success");
                    if (code == 200 && isSuccess) {
                        callback.onSuccess("success");
                    } else {
                        callback.onFail("fail", code);
                    }
                } catch (Throwable e) {
                    LogUtils.w("delete has error :" + e.getMessage(), e);

                    callback.onFail(e.getMessage(), CSSErrors.CSS_ERROR_RESPONSE_JSON_EXCEPTION);
                }
            }

            @Override
            public void onResponedFail(Throwable e, int code) {
                callback.onFail(e.getMessage(), code);
            }
        });
    }

    public static void fqaFinish(String questionId, final RequestCallback<String> callback) {
        String url = URLConstant.feedbackFinish() + "?" + getCommonValue() + "&questionId=" + questionId;

        HttpRequest.requestHttpByPost(url, null, new HttpCallback<String>() {
            @Override
            public void onResponseSuccess(String result) {
                try {
                    JSONObject jsonObject = new JSONObject(result);
                    int code = jsonObject.getInt("code");
                    boolean isSuccess = jsonObject.getBoolean("success");
                    if (code == 200 && isSuccess) {
                        callback.onSuccess("success");
                    } else {
                        callback.onFail("fail", code);
                    }
                } catch (Throwable e) {
                    LogUtils.w("fqaFinish has error :" + e.getMessage(), e);

                    callback.onFail(e.getMessage(), CSSErrors.CSS_ERROR_RESPONSE_JSON_EXCEPTION);
                }
            }

            @Override
            public void onResponedFail(Throwable e, int code) {
                callback.onFail(e.getMessage(), code);
            }
        });
    }

    public static void evaluateWorkOrder(String questionId, boolean satisfy, final RequestCallback<String> callback) {
        String s = satisfy ? "y" : "n";
        String url = URLConstant.evaluate() + "?" + getCommonValue() + "&questionId=" + questionId + "&satisfied=" + s;
        HttpRequest.requestHttpByPost(url, null, new HttpCallback<String>() {
            @Override
            public void onResponseSuccess(String result) {
                try {
                    JSONObject jsonObject = new JSONObject(result);
                    int code = jsonObject.getInt("code");
                    boolean isSuccess = jsonObject.getBoolean("success");
                    if (code == 200 && isSuccess) {
                        callback.onSuccess("success");
                    } else {
                        callback.onFail("fail", code);
                    }
                } catch (Throwable e) {
                    LogUtils.w("evaluateWorkOrder has error :" + e.getMessage(), e);

                    callback.onFail(e.getMessage(), CSSErrors.CSS_ERROR_RESPONSE_JSON_EXCEPTION);
                }
            }

            @Override
            public void onResponedFail(Throwable e, int code) {
                callback.onFail(e.getMessage(), code);
            }
        });
    }

    public static void uploadPics(final List<String> files, final RequestCallback<Map<String, List<Picture>>> callback) {
        String requestURL = URLConstant.uploadPic();
        Map<String, String> params = new HashMap<>();
        params.put("gameGuestId", GlobalData.getAasGgid());
        params.put("token", GlobalData.getAlyToken());
        HttpRequest.requestUploadByPost(requestURL, params, files, new HttpCallback<String>() {
            @Override
            public void onResponseSuccess(String result) {
                try {
                    JSONObject jsonObject = new JSONObject(result);
                    int code = jsonObject.getInt("code");
                    boolean isSuccess = jsonObject.getBoolean("success");
                    JSONObject data = jsonObject.getJSONObject("data");
                    List<Picture> picList = new ArrayList<>();
                    List<Picture> videoList = new ArrayList<>();
                    if (data.has(JSON_PICNAME)) {
                        JSONArray picItems = data.getJSONArray(JSON_PICNAME);
                        picList = new ArrayList<>();
                        for (int i = 0; i < picItems.length(); i++) {
                            Picture pic = new Picture();
                            pic.setPicName(picItems.get(i).toString());
                            pic.setUrl(files.get(i));
                            picList.add(pic);
                        }
                    }

                    if (data.has(JSON_VIDEONAME)) {
                        JSONArray videoItems = data.getJSONArray(JSON_VIDEONAME);
                        videoList = new ArrayList<>();
                        for (int i = 0; i < videoItems.length(); i++) {
                            Picture pic = new Picture();
                            pic.setPicName(videoItems.get(i).toString());
                            pic.setUrl(files.get(i));
                            videoList.add(pic);
                        }
                    }
                    Map<String, List<Picture>> resultMap = new HashMap<>();
                    if (!videoList.isEmpty()) {
                        resultMap.put(JSON_VIDEONAME, videoList);
                    }
                    if (!picList.isEmpty()) {
                        resultMap.put(JSON_PICNAME, picList);
                    }
                    if (code == 200 && isSuccess) {
                        callback.onSuccess(resultMap);
                    } else {
                        callback.onFail("fail", code);
                    }
                    LogUtils.i(" uploadPics onResponseSuccess: result" + result);
                } catch (Throwable e) {
                    LogUtils.i(" uploadPics onResponseSuccess: error " + e.getMessage());
                    callback.onFail(e.getMessage(), CSSErrors.CSS_ERROR_RESPONSE_JSON_EXCEPTION);
                }
            }

            @Override
            public void onResponedFail(Throwable e, int code) {
                callback.onFail(e.getMessage(), code);
            }
        });
    }

    public static void getFaqList(String typeId, final RequestCallback<List<FaqItem>> callback) {
        String url = URLConstant.getFaqList() + "?" + getCommonValue() + "&type_id=" + typeId+"&support_html=Y";
        LogUtils.i("faqlist url is " + url);
        HttpRequest.requestHttpByPost(url, null, new HttpCallback<String>() {
            @Override
            public void onResponseSuccess(String result) {
                try {
                    JSONObject jsonObject = new JSONObject(result);
                    int code = jsonObject.getInt("code");
                    boolean isSuccess = jsonObject.getBoolean("success");
                    String msg = jsonObject.getString("message");
                    ArrayList<FaqItem> list = new ArrayList<>();
                    if (jsonObject.has("data")) {
                        JSONObject data = jsonObject.getJSONObject("data");
                        JSONArray items = data.getJSONArray("questions");
                        JSONObject row = null;
                        for (int i = 0; i < items.length(); i++) {
                            row = items.getJSONObject(i);
                            FaqItem item = new FaqItem();
                            item.parseJsonString(row);
                            list.add(item);
                        }
                    }
                    if (code == 200 && isSuccess) {
                        callback.onSuccess(list);
                    } else {
                        callback.onFail(msg, code);
                    }
                } catch (Throwable e) {
                    LogUtils.w("getFaqList has error :" + e.getMessage(), e);
                    callback.onFail(e.getMessage(), CSSErrors.CSS_ERROR_RESPONSE_JSON_EXCEPTION);
                }
            }

            @Override
            public void onResponedFail(Throwable e, int code) {
                LogUtils.i("faqlist onResponedFail is " + code + " error " + e.getMessage());
                callback.onFail(e.getMessage(), code);
            }
        });
    }

    /**
     * 获得产品的faq类型列表
     *
     * @param callback
     */
    public static void getFaqTypeList(final RequestCallback<List<FaqTypeItem>> callback) {
        String url = URLConstant.getTypeList() + "?" + getCommonValue();
        LogUtils.i("faqTypelist url is " + url);
        HttpRequest.requestHttpByPost(url, null, new HttpCallback<String>() {
            @Override
            public void onResponseSuccess(String result) {
                try {
                    JSONObject jsonObject = new JSONObject(result);
                    int code = jsonObject.getInt("code");
                    boolean isSuccess = jsonObject.getBoolean("success");
                    String msg = jsonObject.getString("message");
                    ArrayList<FaqTypeItem> list = new ArrayList<>();
                    if (jsonObject.has("data")) {
                        JSONObject data = jsonObject.getJSONObject("data");
                        JSONArray items = data.getJSONArray("types");
                        JSONObject row = null;
                        for (int i = 0; i < items.length(); i++) {
                            row = items.getJSONObject(i);
                            FaqTypeItem item = new FaqTypeItem();
                            item.parseJsonString(row);
                            list.add(item);
                        }
                    }
                    if (code == 200 && isSuccess) {
                        callback.onSuccess(list);
                    } else {
                        callback.onFail(msg, code);
                    }
                } catch (Throwable e) {
                    LogUtils.w("getFaqList has error :" + e.getMessage(), e);
                    callback.onFail(e.getMessage(), CSSErrors.CSS_ERROR_RESPONSE_JSON_EXCEPTION);
                }
            }

            @Override
            public void onResponedFail(Throwable e, int code) {
                LogUtils.i("faqTypelist onResponedFail is " + code + " error " + e.getMessage());
                callback.onFail(e.getMessage(), code);
            }
        });
    }

    public static void getFaqMatchList(String content, final RequestCallback<List<FaqItem>> callback) {
        String url = "";
        try {
            content = URLEncoder.encode(content, "utf-8");
            url = URLConstant.getFaqMatch() + "?" + getCommonValue() + "&content=" + content;
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        LogUtils.i("getFaqMatchList url is " + url);
        HttpRequest.requestHttpByPost(url, null, new HttpCallback<String>() {
            @Override
            public void onResponseSuccess(String result) {
                try {
                    LogUtils.i("getFaqMatchList onResponseSuccess result is " + result);
                    JSONObject jsonObject = new JSONObject(result);
                    int code = jsonObject.getInt("code");
                    boolean isSuccess = jsonObject.getBoolean("success");
                    String msg = jsonObject.getString("message");
                    ArrayList<FaqItem> list = new ArrayList<>();
                    if (jsonObject.has("data")) {
                        JSONObject data = jsonObject.getJSONObject("data");
                        JSONArray items = data.getJSONArray("faqs");
                        JSONObject row = null;
                        for (int i = 0; i < items.length(); i++) {
                            row = items.getJSONObject(i);
                            FaqItem item = new FaqItem();
                            item.parseJsonString(row);
                            list.add(item);
                        }
                    }

                    if (code == 200 && isSuccess) {
                        callback.onSuccess(list);
                    } else {
                        callback.onFail(msg, code);
                    }
                } catch (Throwable e) {
                    LogUtils.i("getFaqMatchList onResponseSuccess has error  is " + e.getMessage());
                    callback.onFail(e.getMessage(), CSSErrors.CSS_ERROR_RESPONSE_JSON_EXCEPTION);
                }
            }

            @Override
            public void onResponedFail(Throwable e, int code) {
                LogUtils.i("getFaqMatchList onResponedFail  " + e.getMessage() + " code " + code);
                callback.onFail(e.getMessage(), code);
            }
        });
    }

    public static void getFaqDetail(Context context, String faqId, final RequestCallback<FaqDetail> callback) {
        String url = URLConstant.getFaqDetail() + "?" + getCommonValue() + "&faqId=" + faqId;
        HttpRequest.requestHttpByPost(url, null, new HttpCallback<String>() {
            @Override
            public void onResponseSuccess(String result) {
                LogUtils.i("faqdetail result is " + result);
                try {
                    JSONObject jsonObject = new JSONObject(result);
                    int code = jsonObject.getInt("code");
                    boolean isSuccess = jsonObject.getBoolean("success");
                    String msg = jsonObject.getString("message");

                    JSONObject data = jsonObject.getJSONObject("data");
                    FaqDetail detail = new FaqDetail();
                    detail.parseJsonString(context, data);

                    if (code == 200 && isSuccess) {
                        callback.onSuccess(detail);
                    } else {
                        callback.onFail(msg, code);
                    }
                } catch (Throwable e) {
                    LogUtils.w("getFaqDetail has error :" + e.getMessage(), e);

                    callback.onFail(e.getMessage(), CSSErrors.CSS_ERROR_RESPONSE_JSON_EXCEPTION);
                }
            }

            @Override
            public void onResponedFail(Throwable e, int code) {
                callback.onFail(e.getMessage(), code);
            }
        });
    }

    public static synchronized void getExistNewReply(final CSSExistNewReplyCallback callback) {

        if (!newReplyCallBacks.contains(callback)) {
            newReplyCallBacks.add(callback);
        }

        // 设置请求限制，一分钟只能请求一次
        if (existIsCalledLastTime.get() == 0) {
            existIsCalledLastTime.set(System.currentTimeMillis());
        } else {
            long timeSpan = System.currentTimeMillis() - existIsCalledLastTime.get();
            if (timeSpan < 60 * 1000) {
                return;
            }
            existIsCalledLastTime.set(System.currentTimeMillis());
        }
        String url = URLConstant.existNewReply() + "?" + getCommonValue();
        LogUtils.i("getExistNewReply url is " + url);

        HttpRequest.requestHttpByPost(url, null, new HttpCallback<String>() {
            @Override
            public void onResponseSuccess(String result) {
                LogUtils.i("getExistNewReply result is " + result);
                try {
                    JSONObject jsonObject = new JSONObject(result);
                    int code = jsonObject.getInt("code");
                    boolean isSuccess = jsonObject.getBoolean("success");
                    String msg = jsonObject.getString("message");

                    JSONObject data = jsonObject.getJSONObject("data");
                    String existNewReply = data.optString("existNewReply");
                    if (code == 200 && isSuccess) {
                        notifyNewReplayCallback(existNewReply);
                    } else {
                        notifyNewReplayCallback(msg + " code " + code);
                    }
                } catch (Throwable e) {
                    LogUtils.w("getFaqDetail has error :" + e.getMessage(), e);
                    notifyNewReplayCallback(e.getMessage());
                }
            }

            @Override
            public void onResponedFail(Throwable e, int code) {
                notifyNewReplayCallback(e.getMessage() + " code :" + code);

            }
        });
    }

    /**
     * 仅用于recommandFaqActivity中获得回复
     *
     * @param callback
     */
    public static void getExistNewReplyInner(CSSExistNewReplyCallback callback) {
        String url = URLConstant.existNewReply() + "?" + getCommonValue();
        LogUtils.i("getExistNewReply url is " + url);
        HttpRequest.requestHttpByPost(url, null, new HttpCallback<String>() {
            @Override
            public void onResponseSuccess(String result) {
                LogUtils.i("getExistNewReply result is " + result);
                try {
                    JSONObject jsonObject = new JSONObject(result);
                    int code = jsonObject.getInt("code");
                    boolean isSuccess = jsonObject.getBoolean("success");
                    String msg = jsonObject.getString("message");
                    JSONObject data = jsonObject.getJSONObject("data");
                    String existNewReply = data.optString("existNewReply");
                    if (code == 200 && isSuccess) {
                        if (existNewReply.equals("Y")) {
                            callback.hasNewReplySuccess(true);
                        } else if (existNewReply.equals("N")) {
                            callback.hasNewReplySuccess(false);
                        }
                    } else {
                        callback.hasNewReplyFail(msg + " code " + code);
                    }
                } catch (Throwable e) {
                    LogUtils.w("getFaqDetail has error :" + e.getMessage(), e);
                    callback.hasNewReplyFail(e.getMessage());
                }
            }

            @Override
            public void onResponedFail(Throwable e, int code) {
                callback.hasNewReplyFail(e.getMessage() + " code :" + code);

            }
        });

    }

    private static void notifyNewReplayCallback(String msg) {
        if (newReplyCallBacks.size() <= 0) {
            return;
        }
        for (CSSExistNewReplyCallback callback : newReplyCallBacks) {
            if (msg.equals("Y")) {
                callback.hasNewReplySuccess(true);
            } else if (msg.equals("N")) {
                callback.hasNewReplySuccess(false);
            } else {
                callback.hasNewReplyFail(msg);
            }
        }
    }

    public static void evaluateFqa(String faqId, boolean isHelp, final RequestCallback<String> callback) {
        String help = isHelp ? "y" : "n";
        String url = URLConstant.evaluateFaq() + "?" + getCommonValue() + "&faqId=" + faqId + "&help=" + help;

        HttpRequest.requestHttpByPost(url, null, new HttpCallback<String>() {
            @Override
            public void onResponseSuccess(String result) {
                try {
                    JSONObject jsonObject = new JSONObject(result);
                    int code = jsonObject.getInt("code");
                    boolean isSuccess = jsonObject.getBoolean("success");
                    String msg = jsonObject.getString("message");

                    if (code == 200 && isSuccess) {
                        callback.onSuccess("success");
                    } else {
                        callback.onFail(msg, code);
                    }
                } catch (Throwable e) {
                    LogUtils.w("evaluateFqa has error :" + e.getMessage(), e);

                    callback.onFail(e.getMessage(), CSSErrors.CSS_ERROR_RESPONSE_JSON_EXCEPTION);
                }
            }

            @Override
            public void onResponedFail(Throwable e, int code) {
                callback.onFail(e.getMessage(), code);
            }
        });
    }

    private void getDevicesInfo(Context context) {
        String totalMemory = DeviceInfoHelper.getTotalMemory(context);// Byte转换为KB或者MB，内存大小规格化
        String availableMe = DeviceInfoHelper.getAvailMemory(context);
        String netWork = DeviceInfoHelper.getNetWorkType(context);
        String cpuType = DeviceInfoHelper.getCpuInfo();
    }

    private static String getCommonValue() {
        Map<String, String> values = new HashMap<String, String>();
        // 如果用户在游戏中切换了账号，也需要同步切换数据内容
        AASHelper.freshGgid();
        values.put("gameGuestId", (GlobalData.getAasGgid() == null ? "" : GlobalData.getAasGgid()));
        values.put("token", GlobalData.getAlyToken());
        values.put("platform", Constants.PLATFORM_ANDROID);
        values.put("pdtid", GlobalData.getProductId());
        values.put("product_version", DeviceInfoHelper.getAppVersion(GlobalData.getContext()));
        values.put("system_version", DeviceInfoHelper.getSystemVersion());
        values.put("sdk_version", BuildConfig.VERSION_NAME);
        if (GlobalData.getContext() != null) {
            if (GlobalData.getContext().getResources().getConfiguration().locale != null) {
                values.put("language", GlobalData.getContext().getResources().getConfiguration().locale.getLanguage());
            }
        }
        String cpInfoStr = "";
        if (GlobalData.getCpInfo() != null) {
            cpInfoStr = "&" + map2Url(GlobalData.getCpInfo());
        }
        return map2Url(values) + cpInfoStr;
    }


    private static String map2Url(Map<String, String> map) {
        if (map == null || map.size() <= 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            stringBuilder.append(entry.getKey() + "=" + entry.getValue());
            stringBuilder.append("&");
        }
        String finalStr = stringBuilder.toString().substring(0, stringBuilder.length() - 1);
        return finalStr;
    }
}
