package com.css.sdk.cservice.base.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CpuUtils {
    public static int getNumCpuCores() {
        try {
            File dir = new File("/sys/devices/system/cpu/");
            File[] files = dir.listFiles(new FileFilter() {
                @Override
                public boolean accept(File file) {
                    if (Pattern.matches("cpu[0-9]+", file.getName())) {
                        return true;
                    }
                    return false;
                }
            });
            if (files == null || files.length <= 0) {
                return 0;
            } else {
                return files.length;
            }
        } catch (Throwable e) {
            return 1;
        }
    }

    public static boolean isCpu64() {
        if (Build.CPU_ABI != null && Build.CPU_ABI.toLowerCase().contains("arm64")) {
            return true;
        }

        try {
            String mProcessor = getFieldFromCpuinfo("Processor");
            if (mProcessor != null && mProcessor.toLowerCase().contains("aarch64")) {
                return true;
            }
        } catch (Throwable e) {
        }

        return false;
    }

    public static String getCpuAbi() {
        return Build.CPU_ABI;
    }

    public static String getCpuHardware() {
        return Build.HARDWARE;
    }

    public static long getCpuMaxFreq() {
        long result = 0L;
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader("/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_max_freq"));
            if ((line = br.readLine()) != null) {
                result = Long.parseLong(line);
            }
            br.close();
        } catch (Throwable e) {

        }
        return result;
    }

    public static long getCpuMinFreq() {
        long result = 0L;
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader("/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_min_freq"));
            if ((line = br.readLine()) != null) {
                result = Long.parseLong(line);
            }
            br.close();
        } catch (Throwable e) {

        }
        return result;
    }


    private static String getFieldFromCpuinfo(String field) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader("/proc/cpuinfo"));
        Pattern p = Pattern.compile(field + "\\s*:\\s*(.*)");

        try {
            String line;
            while ((line = br.readLine()) != null) {
                Matcher m = p.matcher(line);
                if (m.matches()) {
                    return m.group(1);
                }
            }
        } finally {
            br.close();
        }

        return null;
    }


}