package com.css.sdk.cservice.base.http;

import android.text.TextUtils;

import com.css.sdk.BuildConfig;

import java.util.Iterator;
import java.util.Map;

/**
 * Created by Holaverse on 2017/5/23.
 */

public class HttpsClientHelper {

    public static HttpResponse httpGet(final String url, final String userAgent) throws Exception {
        return httpSend("get", url, null, userAgent, null);
    }

    public static HttpResponse httpPost(final String url, final String requestBody, final String userAgent) throws Exception {
        return httpSend("post", url, requestBody, userAgent, null);
    }


    public static HttpResponse httpPost(final String url, final String requestBody, final String userAgent, final String enctyType) throws Exception {
        return httpSend("post", url, requestBody, userAgent, enctyType);
    }

    public static HttpResponse httpPost(final String url, final String requestBody, final Map<String, String> heardMap, final String userAgent, final String enctyType) throws Exception {
        return httpSend("post", url, requestBody, heardMap, userAgent, enctyType);
    }


    private static HttpResponse httpSend(String type, final String url, final String requestBody, final String userAgent, final String enctyType) throws Exception {
        HttpResponse body = null;
//        try {
        HttpsClient client = HttpsClient.builder().setmHostName(BuildConfig.CSERVICE_DOMAIN).setUrl(url);
        if (type.equals("post")) {
            client.setRequestMethod(HttpClient.METHOD_POST);
        }
        if (!TextUtils.isEmpty(requestBody)) {
            client.setRequestBody(requestBody);
        }
        if (!TextUtils.isEmpty(userAgent)) {
            client.setUserAgent(userAgent);
        }
        if (!TextUtils.isEmpty(enctyType)) {
            client.setEnctyType(enctyType);
        }
        body = client.request();
//        } catch (Throwable e) {
//
//        }
        return body;
    }

    /**
     * 使用带有header的http请求
     *
     * @param type
     * @param url
     * @param requestBody
     * @param headerMap
     * @param userAgent
     * @param enctyType
     * @return
     */
    private static HttpResponse httpSend(String type, final String url, final String requestBody, final Map<String, String> headerMap, final String userAgent, final String enctyType) throws Exception {
        HttpResponse body = null;
//        try {
        HttpsClient client = HttpsClient.builder().setmHostName(BuildConfig.CSERVICE_DOMAIN).setUrl(url);
        if (type.equals("post")) {
            client.setRequestMethod(HttpsClient.METHOD_POST);
        }
        if (!TextUtils.isEmpty(requestBody)) {
            client.setRequestBody(requestBody);
        }
        if (!TextUtils.isEmpty(userAgent)) {
            client.setUserAgent(userAgent);
        }
        if (!TextUtils.isEmpty(enctyType)) {
            client.setEnctyType(enctyType);
        }
        if (!TextUtils.isEmpty(enctyType)) {
            client.setEnctyType(enctyType);
        }
        if (headerMap != null && headerMap.size() != 0) {
            Iterator<Map.Entry<String, String>> iterator = headerMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> entry = iterator.next();
                String key = entry.getKey();
                String value = entry.getValue();
                client.setRequestHeader(key, value);
            }
        }
        body = client.request();
//        } catch (Throwable e) {
//
//        }
        return body;
    }

}
