package com.css.sdk.cservice.adapter;

import android.content.Context;
import android.graphics.Color;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.css.sdk.R;
import com.css.sdk.cservice.data.FaqItem;
import com.css.sdk.cservice.userdata.GlobalData;

import java.util.List;

/**
 * @ProjectName: customerservicesdk
 * @Package: com.css.sdk.cservice.adapter
 * @ClassName: CssTextGridViewAdapter
 * @Description: CssTextGridViewAdapter
 * @Author: Roy
 * @CreateDate: 2020/5/22 14:46
 */

public class SimpleTextGridViewAdapter extends BaseAdapter {
    private Context mContext;
    private List<FaqItem> data;

    public SimpleTextGridViewAdapter(Context mContext, List<FaqItem> data) {
        this.mContext = mContext;
        this.data = data;
    }

    public void setData(List<FaqItem> data) {
        this.data = data;
    }

    @Override
    public int getCount() {
        return data == null ? 0 : data.size();
    }

    @Override
    public Object getItem(int position) {
        return null;
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder viewHolder = null;
        if (convertView == null) {
            convertView = LayoutInflater.from(mContext).inflate(R.layout.css_gridview_recommadfaq_item, parent, false);
            viewHolder = new ViewHolder();
            viewHolder.content = convertView.findViewById(R.id.css_item_content);
            viewHolder.itemRoot = convertView.findViewById(R.id.css_faq_item_root);
            convertView.setTag(viewHolder);

        } else {
            viewHolder = (ViewHolder) convertView.getTag();
        }
        viewHolder.itemRoot.setBackgroundColor(GlobalData.getUiAlphaColor());
        if (TextUtils.isEmpty(data.get(position).id)) {
            viewHolder.itemRoot.setVisibility(View.INVISIBLE);
        } else {
            viewHolder.itemRoot.setVisibility(View.VISIBLE);

        }
        viewHolder.content.setText(data.get(position).getFaqTypeByLanguage(mContext));
        return convertView;
    }


    class ViewHolder {
        TextView content;
        RelativeLayout itemRoot;
    }


}
