package com.css.sdk.cservice.adapter;

import android.content.Context;
import android.system.Os;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.css.sdk.R;
import com.css.sdk.cservice.base.utils.DeviceInfoHelper;
import com.css.sdk.cservice.base.utils.LogUtils;
import com.css.sdk.cservice.data.FaqItem;
import com.css.sdk.cservice.utils.DataFilter;
import com.css.sdk.cservice.utils.LocalInfo;

import org.w3c.dom.Text;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class RecommendQaAapter extends BaseAdapter {
    private List<FaqItem> data;
    private Context context;
    private RecommendQAItemClickListener mClickListener;

    public RecommendQaAapter(Context context, RecommendQAItemClickListener listener) {
        this.context = context;
        this.mClickListener = listener;
    }

    public interface RecommendQAItemClickListener {
        public void onItemClick(int position, FaqItem faqItem);
    }

    public void bindData(List<FaqItem> list) {
        // 追加根据当前设备语言显示fqa
        this.data = DataFilter.fitLanguageData(context, list);
        notifyDataSetChanged();
    }

    @Override
    public int getCount() {
        return data == null ? 0 : data.size();
    }

    @Override
    public Object getItem(int position) {
        return null;
    }

    @Override
    public long getItemId(int position) {
        return 0;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder hold = null;
        LinearLayout root;
        if (convertView == null) {
            convertView = LayoutInflater.from(context).inflate(R.layout.css_recommend_qa_list_item, null);
            hold = new ViewHolder(convertView);
            convertView.setTag(hold);
        } else {
            hold = (ViewHolder) convertView.getTag();
        }

        hold.questionEn.setVisibility(View.GONE);
        hold.questionZh.setVisibility(View.VISIBLE);

        if (LocalInfo.getLanguage(context) == LocalInfo.LocalLanguage.ZHSIMPLE) {
            hold.questionZh.setText(data.get(position).questionZhSimple);
        } else if (LocalInfo.getLanguage(context) == LocalInfo.LocalLanguage.ZHTrandition) {
            hold.questionZh.setText(data.get(position).questionZh);
        } else {
            hold.questionZh.setText(data.get(position).questionEn);
        }
        hold.root.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                mClickListener.onItemClick(position, data.get(position));
            }
        });

        return convertView;
    }

    class ViewHolder {
        TextView questionZh;
        TextView questionEn;
        LinearLayout root;

        public ViewHolder(View view) {
            root = view.findViewById(R.id.recommend_item_root);
            questionZh = view.findViewById(R.id.css_recommend_question_zh);
            questionEn = view.findViewById(R.id.css_recommend_question_en);
        }
    }
}
