package com.css.sdk.cservice.adapter;

import android.content.Context;
import android.graphics.Color;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.css.sdk.R;
import com.css.sdk.cservice.data.PopWindowEntity;
import com.css.sdk.cservice.data.SystemMsgEntity;
import com.css.sdk.cservice.userdata.GlobalData;

import java.util.ArrayList;
import java.util.List;

import static com.css.sdk.cservice.base.Constants.SYSTEM_MSG_READED;
import static com.css.sdk.cservice.base.Constants.SYSTEM_MSG_UNREAD;

/**     
  * 
  * @ProjectName:    cssdk
  * @Package:        com.css.sdk.cservice.adapter
  * @ClassName:      PopupListAdapter
  * @Description:     java类作用描述 
  * @Author:         wan
  * @CreateDate:     2021/1/20 7:06 PM
  * @UpdateUser:     wan
  * @UpdateDate:     2021/1/20 7:06 PM
  * @UpdateRemark:   更新说明：
  * @Version:        1.0
 */

public class PopupListAdapter extends BaseAdapter {
    private Context mContext;
    private List<PopWindowEntity> dataList;

    public PopupListAdapter(Context mContext, List<PopWindowEntity> dataList) {
        this.mContext = mContext;
        this.dataList = dataList;
    }

    @Override
    public int getCount() {
        return dataList == null ? 0 : dataList.size();
    }

    @Override
    public Object getItem(int position) {
        return null;
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder holder = null;
        if (convertView == null) {
            convertView = LayoutInflater.from(mContext).inflate(R.layout.css_simple_list_item, parent, false);
            holder = new ViewHolder();
            holder.content = convertView.findViewById(R.id.css_simplelist_tv);
            holder.iv = convertView.findViewById(R.id.css_simplelist_iv);
            holder.notice = convertView.findViewById(R.id.css_simplelist_notice);
            convertView.setTag(holder);
        } else {
            holder = (ViewHolder) convertView.getTag();
        }
        final PopWindowEntity item = dataList.get(position);
        holder.content.setText(item.content);
        holder.content.setTextColor(GlobalData.getUiColor());
        if (item.status.equals(SYSTEM_MSG_UNREAD)) {
            faqNewMessage(holder);
        } else if (item.status.equals(SYSTEM_MSG_READED)) {
            faqReaded(holder);
        }
        holder.iv.setImageResource(item.imgId);
        return convertView;
    }

    public void setDataList(ArrayList<PopWindowEntity> msgList) {
        dataList = msgList;
    }

    class ViewHolder {
        TextView content;
        ImageView iv;
        ImageView notice;
    }
    private void faqNewMessage(ViewHolder viewHolder) {
        viewHolder.notice.setVisibility(View.VISIBLE);
    }

    private void faqReaded(ViewHolder viewHolder) {
        viewHolder.notice.setVisibility(View.INVISIBLE);
    }

}
