package com.css.sdk.cservice.activity;

import android.content.Intent;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.LinearLayout;

import com.css.sdk.R;
import com.css.sdk.cservice.adapter.SystemMsgListAdapter;
import com.css.sdk.cservice.base.Constants;
import com.css.sdk.cservice.base.utils.ToastUtil;
import com.css.sdk.cservice.business.BusinessRequest;
import com.css.sdk.cservice.business.RequestCallback;
import com.css.sdk.cservice.data.HistoryItem;
import com.css.sdk.cservice.data.SystemMsgDetailEntity;
import com.css.sdk.cservice.data.SystemMsgEntity;

import java.util.ArrayList;

import static com.css.sdk.cservice.base.Constants.SYSTEMMSG_RESULT_CODE;

public class SystemMsgActivity extends AbstractBaseActivity {
    private AbsListView aqsContentView;
    private SystemMsgListAdapter adapter;
    private LinearLayout loadingRl;
    private boolean mLoading;
    private ArrayList<SystemMsgEntity> msgList;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Override
    protected void initExtraData() {

    }

    @Override
    public int getLayoutId() {
        return R.layout.css_activity_history;
    }

    @Override
    public void initView() {
        super.initView();
        showTitleClose(false);
        showTitleBack(true);
        showTitleName(true, getResources().getString(R.string.css_systemmsg));
//        List<String> tags = new ArrayList<>();
//        tags.add(getResources().getString(R.string.css_text_tab_processing));
//        tags.add(getResources().getString(R.string.css_text_tab_fixed));
//        showTitleTab(true, tags, this);
        aqsContentView = findViewById(R.id.css_history_aqs);
        loadingRl = findViewById(R.id.css_loading_layout);
    }

    @Override
    public void initData() {
        requestData();
    }

    private void requestData() {
        showLoading();
        BusinessRequest.getSystemMsgList(new RequestCallback<ArrayList<SystemMsgEntity>>() {
            @Override
            public void onSuccess(final ArrayList<SystemMsgEntity> result) {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        hideLoading();
                        if (result == null || result.isEmpty()) {
                            ToastUtil.showToastTip(getApplicationContext(), R.string.css_string_history_empty, false);
                        }
                        msgList = result;
                        if (adapter == null) {
                            adapter = new SystemMsgListAdapter(SystemMsgActivity.this, msgList);
                            aqsContentView.setAdapter(adapter);
                            aqsContentView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
                                @Override
                                public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                                    goMsgDetail(position);
                                }
                            });
                        } else {
                            adapter.setDataList(msgList);
                            adapter.notifyDataSetChanged();
                        }

                    }
                });
            }

            @Override
            public void onFail(String msg, int code) {
                hideLoading();
                showError(code);
            }
        });
    }

    private void goMsgDetail(int position) {
        SystemMsgEntity item = msgList.get(position);
        // 判断是text还是html
        if (item == null) {
            showError(getResources().getString(R.string.css_string_system_error));
            return;
        }
        Intent intent;
        if (item.type == SystemMsgDetailEntity.SystemMsgType.TEXT) {
            intent = new Intent(SystemMsgActivity.this, SystemMsgDetailActvity.class);
            intent.putExtra(Constants.KEY_DETAIL_ID, item.id);
            intent.putExtra(Constants.KEY_DETAIL_NAME, item.title);
        } else {
            intent = new Intent(SystemMsgActivity.this, CssWebExplorerActivity.class);
            intent.putExtra(Constants.KEY_DETAIL_ID, item.id);
        }
        startActivityForResult(intent,SYSTEMMSG_RESULT_CODE);
    }

    private void showLoading() {
        mLoading = true;
        loadingRl.setVisibility(View.VISIBLE);
    }

    private void hideLoading() {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                mLoading = false;
                loadingRl.setVisibility(View.GONE);

            }
        });
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (mLoading && keyCode == KeyEvent.KEYCODE_BACK) {
            return true;//不执行父类点击事件
        }
        return super.onKeyDown(keyCode, event);//继续执行父类其他点击事件
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (resultCode == Constants.SYSTEMMSG_RESULT_CODE) {
            if (data != null) {
                Bundle bundle = data.getExtras();
                if (bundle != null) {
                    String orderId = bundle.getString(Constants.KEY_ORDER_ID);
                    String type = bundle.getString(Constants.KEY_ORDER_CHANGE_TYPE);
                    if (msgList != null && !msgList.isEmpty()) {
                        for (SystemMsgEntity item : msgList) {
                            if (item.id.equals(orderId)) {
                                if (type.equals(Constants.SYSTEM_MSG_READED) ) {
                                    item.status = Constants.SYSTEM_MSG_READED;
                                } else  {
                                    item.status = Constants.SYSTEM_MSG_UNREAD;
                                }
                                adapter.setDataList(msgList);
                                adapter.notifyDataSetChanged();
                                break;
                            }
                        }
                    }
                }
            }
        }
    }
}
