/*
 * Tencent is pleased to support the open source community by making QMUI_Android available.
 *
 * Copyright (C) 2017-2018 THL A29 Limited, a Tencent company. All rights reserved.
 *
 * Licensed under the MIT License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 *
 * http://opensource.org/licenses/MIT
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.css.sdk.cservice.activity;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.app.Activity;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.DownloadListener;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;

import com.css.sdk.R;
import com.css.sdk.cservice.base.Constants;
import com.css.sdk.cservice.base.utils.LogUtils;
import com.css.sdk.cservice.business.BusinessRequest;
import com.css.sdk.cservice.business.RequestCallback;
import com.css.sdk.cservice.data.SystemMsgDetailEntity;
import com.css.sdk.cservice.view.CssQDWebView;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;
import com.qmuiteam.qmui.util.QMUILangHelper;
import com.qmuiteam.qmui.util.QMUIResHelper;
import com.qmuiteam.qmui.widget.QMUITopBarLayout;
import com.qmuiteam.qmui.widget.dialog.QMUIDialog;
import com.qmuiteam.qmui.widget.dialog.QMUIDialogAction;
import com.qmuiteam.qmui.widget.dialog.QMUITipDialog;
import com.qmuiteam.qmui.widget.webview.QMUIWebView;
import com.qmuiteam.qmui.widget.webview.QMUIWebViewClient;
import com.qmuiteam.qmui.widget.webview.QMUIWebViewContainer;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

import static com.css.sdk.cservice.base.Constants.KEY_DETAIL_NAME;
import static com.css.sdk.cservice.base.Constants.WEBVIEW_URL;


/**
 * Created by cgspine on 2017/12/4.
 */

public class CssWebExplorerActivity extends AbstractBaseActivity {
    private final static int PROGRESS_PROCESS = 0;
    private final static int PROGRESS_GONE = 1;
    QMUITopBarLayout mTopBarLayout;
    QMUIWebViewContainer mWebViewContainer;
    ProgressBar mProgressBar;
    protected CssQDWebView mWebView;
    private String mUrl;
    private String mTitle;
    private ProgressHandler mProgressHandler;
    private boolean mIsPageFinished = false;
    private boolean mNeedDecodeUrl = false;
    private String msgId = "";
    // loading
    private QMUITipDialog tipDialog;


    @Override
    protected void initExtraData() {
        mTitle = getIntent().getStringExtra(KEY_DETAIL_NAME);
        msgId = getIntent().getStringExtra(Constants.KEY_DETAIL_ID);
    }

    @Override
    public int getLayoutId() {
        return R.layout.css_activity_webexplorer;
    }

    @Override
    public void initView() {
        mTopBarLayout = findViewById(R.id.topbar);
        mWebViewContainer = findViewById(R.id.webview_container);
        mProgressBar = findViewById(R.id.progress_bar);
        initTopbar();
        mProgressHandler = new ProgressHandler();
    }

    @Override
    public void initData() {
        requestData();
    }

    protected void initTopbar() {
        mTopBarLayout.addRightImageButton(R.drawable.css_icon_close_small,R.drawable.css_icon_close).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                finish();
            }
        });
        updateTitle(mTitle);
    }
    @Override
    public void finish() {
        Intent intent = new Intent();
        intent.putExtra(Constants.KEY_ORDER_CHANGE_TYPE, Constants.SYSTEM_MSG_READED);
        intent.putExtra(Constants.KEY_ORDER_ID, msgId);
        setResult(Constants.SYSTEMMSG_RESULT_CODE, intent);
        super.finish();
    }
    protected boolean needDispatchSafeAreaInset() {
        return false;
    }

    protected void initWebView() {
        mWebView = new CssQDWebView(this);
        boolean needDispatchSafeAreaInset = needDispatchSafeAreaInset();
        mWebViewContainer.addWebView(mWebView, needDispatchSafeAreaInset);
        mWebViewContainer.setCustomOnScrollChangeListener(new QMUIWebView.OnScrollChangeListener() {
            @Override
            public void onScrollChange(View v, int scrollX, int scrollY, int oldScrollX, int oldScrollY) {
                onScrollWebContent(scrollX, scrollY, oldScrollX, oldScrollY);
            }
        });
        FrameLayout.LayoutParams containerLp = (FrameLayout.LayoutParams) mWebViewContainer.getLayoutParams();
        mWebViewContainer.setFitsSystemWindows(!needDispatchSafeAreaInset);
        containerLp.topMargin = needDispatchSafeAreaInset ? 0 : QMUIResHelper.getAttrDimen(this, R.attr.qmui_topbar_height);
        mWebViewContainer.setLayoutParams(containerLp);

//        mWebView.setDownloadListener(new DownloadListener() {
//            @Override
//            public void onDownloadStart(String url, String userAgent, String contentDisposition, String mimetype, long contentLength) {
//                boolean needConfirm = !url.startsWith("http://qmuiteam.com") && !url.startsWith("https://qmuiteam.com");
//                if (needConfirm) {
//                    final String finalURL = url;
//                    new QMUIDialog.MessageDialogBuilder(CssWebExplorerActivity.this)
//                            .setMessage("确认下载此文件？")
//                            .addAction(R.string.css_string_cancel, new QMUIDialogAction.ActionListener() {
//                                @Override
//                                public void onClick(QMUIDialog dialog, int index) {
//                                    dialog.dismiss();
//                                }
//                            })
//                            .addAction(R.string.css_string_finish, new QMUIDialogAction.ActionListener() {
//                                @Override
//                                public void onClick(QMUIDialog dialog, int index) {
//                                    dialog.dismiss();
//                                    doDownload(finalURL);
//                                }
//                            })
//                            .show();
//                } else {
//                    doDownload(url);
//                }
//            }
//
//            private void doDownload(String url) {
//
//            }
//        });

        mWebView.setWebChromeClient(new WebChromeClient() {

            @Override
            public void onProgressChanged(WebView view, int newProgress) {
                super.onProgressChanged(view, newProgress);
                // 修改进度条
                if (newProgress > mProgressHandler.mDstProgressIndex) {
                    sendProgressMessage(PROGRESS_PROCESS, newProgress, 100);
                }
            }

            @Override
            public void onReceivedTitle(WebView view, String title) {
                super.onReceivedTitle(view, title);
                updateTitle(view.getTitle());
            }

            @Override
            public void onShowCustomView(View view, CustomViewCallback callback) {
                callback.onCustomViewHidden();
            }

        });
        mWebView.setWebViewClient(getWebViewClient());
        mWebView.requestFocus(View.FOCUS_DOWN);
        setZoomControlGone(mWebView);
        configWebView(mWebViewContainer, mWebView);
        mWebView.loadUrl(mUrl);
    }

    protected void configWebView(QMUIWebViewContainer webViewContainer, QMUIWebView webView) {

    }

    protected void onScrollWebContent(int scrollX, int scrollY, int oldScrollX, int oldScrollY) {

    }

    private void handleUrl(String url) {
        if (mNeedDecodeUrl) {
            String decodeURL;
            try {
                decodeURL = URLDecoder.decode(url, "utf-8");
            } catch (UnsupportedEncodingException ignored) {
                decodeURL = url;
            }
            mUrl = decodeURL;
        } else {
            mUrl = url;
        }
    }

    protected QMUIWebViewClient getWebViewClient() {
        return new ExplorerWebViewClient(needDispatchSafeAreaInset());
    }


    @Override
    public void onDestroy() {
        super.onDestroy();
        mWebViewContainer.destroy();
        mWebView = null;
    }

    public static void setZoomControlGone(WebView webView) {
        webView.getSettings().setDisplayZoomControls(false);
//        @SuppressWarnings("rawtypes")
//        Class classType;
//        Field field;
//        try {
//            classType = WebView.class;
//            field = classType.getDeclaredField("mZoomButtonsController");
//            field.setAccessible(true);
//            ZoomButtonsController zoomButtonsController = new ZoomButtonsController(
//                    webView);
//            zoomButtonsController.getZoomControls().setVisibility(View.GONE);
//            try {
//                field.set(webView, zoomButtonsController);
//            } catch (IllegalArgumentException | IllegalAccessException e) {
//                e.printStackTrace();
//            }
//        } catch (SecurityException | NoSuchFieldException e) {
//            e.printStackTrace();
//        }
    }

    private void sendProgressMessage(int progressType, int newProgress, int duration) {
        Message msg = new Message();
        msg.what = progressType;
        msg.arg1 = newProgress;
        msg.arg2 = duration;
        mProgressHandler.sendMessage(msg);
    }


    protected class ExplorerWebViewClient extends QMUIWebViewClient {

        public ExplorerWebViewClient(boolean needDispatchSafeAreaInset) {
            super(needDispatchSafeAreaInset, true);
        }

        @Override
        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            super.onPageStarted(view, url, favicon);
            if (QMUILangHelper.isNullOrEmpty(mTitle)) {
                updateTitle(view.getTitle());
            }
            if (mProgressHandler.mDstProgressIndex == 0) {
                sendProgressMessage(PROGRESS_PROCESS, 30, 500);
            }
        }

        @Override
        public void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, url);
            sendProgressMessage(PROGRESS_GONE, 100, 0);
            if (QMUILangHelper.isNullOrEmpty(mTitle)) {
                updateTitle(view.getTitle());
            }
        }
    }

    private void updateTitle(String title) {
        if (title != null && !title.equals("")) {
            mTitle = title;
            mTopBarLayout.setTitle(mTitle);
        }
    }

    private class ProgressHandler extends Handler {

        private int mDstProgressIndex;
        private int mDuration;
        private ObjectAnimator mAnimator;


        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case PROGRESS_PROCESS:
                    mIsPageFinished = false;
                    mDstProgressIndex = msg.arg1;
                    mDuration = msg.arg2;
                    mProgressBar.setVisibility(View.VISIBLE);
                    if (mAnimator != null && mAnimator.isRunning()) {
                        mAnimator.cancel();
                    }
                    mAnimator = ObjectAnimator.ofInt(mProgressBar, "progress", mDstProgressIndex);
                    mAnimator.setDuration(mDuration);
                    mAnimator.addListener(new AnimatorListenerAdapter() {
                        @Override
                        public void onAnimationEnd(Animator animation) {
                            if (mProgressBar.getProgress() == 100) {
                                sendEmptyMessageDelayed(PROGRESS_GONE, 500);
                            }
                        }
                    });
                    mAnimator.start();
                    break;
                case PROGRESS_GONE:
                    mDstProgressIndex = 0;
                    mDuration = 0;
                    mProgressBar.setProgress(0);
                    mProgressBar.setVisibility(View.GONE);
                    if (mAnimator != null && mAnimator.isRunning()) {
                        mAnimator.cancel();
                    }
                    mAnimator = ObjectAnimator.ofInt(mProgressBar, "progress", 0);
                    mAnimator.setDuration(0);
                    mAnimator.removeAllListeners();
                    mIsPageFinished = true;
                    break;
                default:
                    break;
            }
        }


    }

    private void hideLoading() {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                tipDialog.dismiss();
            }
        });
    }

    private void showLoading() {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                tipDialog = new QMUITipDialog.Builder(CssWebExplorerActivity.this)
                        .setIconType(QMUITipDialog.Builder.ICON_TYPE_LOADING)
                        .setTipWord(getResources().getString(R.string.css_string_loading))
                        .create();
                tipDialog.show();
            }
        });

    }

    private void requestData() {
        showLoading();
        BusinessRequest.getSystemMsgDetail(msgId, new RequestCallback<SystemMsgDetailEntity>() {
            @Override
            public void onSuccess(final SystemMsgDetailEntity result) {
                hideLoading();
                if (result == null) {
                    showError(getResources().getString(R.string.css_string_system_error));
                    return;
                }
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        mUrl = result.content;
                        initWebView();
                        if (!TextUtils.isEmpty(result.title)) {
                            updateTitle(result.title);
                        }
                    }
                });
            }

            @Override
            public void onFail(final String msg, int code) {
                hideLoading();
                showError(code);
            }
        });
    }
}
