package com.css.sdk.cservice.activity;

import android.app.Activity;
import android.content.pm.ActivityInfo;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;

import com.css.sdk.cservice.base.CSSErrors;
import com.css.sdk.cservice.base.Constants;
import com.css.sdk.cservice.base.utils.SpHelper;
import com.css.sdk.cservice.base.utils.ToastUtil;
import com.css.sdk.cservice.userdata.GlobalData;
import com.css.sdk.cservice.utils.CutoutUtil;
import com.css.sdk.cservice.utils.StatusNavUtils;

public class BaseActivity extends AppCompatActivity {
    public boolean isLand;
    private int screenType;
    public SpHelper spHelper;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        fullScreen();
        hideNavigationBar(true);
        closeAutoFillonAndroid8();
        checkSpHelper();
        screenType = GlobalData.getScreenType();
        int orientation = getResources().getConfiguration().orientation;
        if (orientation == Configuration.ORIENTATION_LANDSCAPE) {
            isLand = true;
        }

//        if (screenType == Constants.SCREEN_TYPE_REVERSE_LAND) {
//            isLand = true;
//            setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_REVERSE_LANDSCAPE);
//        } else if (screenType == Constants.SCREEN_TYPE_LAND) {
//            isLand = true;
//            setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE);
//        } else {
//            isLand = false;
//            setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);
//        }
        StatusNavUtils.setStatusNavBar(this, screenType);
        if (CutoutUtil.hasNotchScreen(this) && isLand) {
            CutoutUtil.useNotch(this, screenType);
        }
        super.onCreate(savedInstanceState);
    }

    /**
     * 是否隐藏navigation bar
     *
     * @param isHide
     */
    private void hideNavigationBar(boolean isHide) {
        Window mWindow = getWindow();
        WindowManager.LayoutParams params = mWindow.getAttributes();
        params.systemUiVisibility =View.SYSTEM_UI_FLAG_HIDE_NAVIGATION
                | View.SYSTEM_UI_FLAG_IMMERSIVE_STICKY;
        mWindow.setAttributes(params);
    }

    private void fullScreen() {
        //隐藏标题栏
        this.requestWindowFeature(Window.FEATURE_NO_TITLE);
//隐藏状态栏
        this.getWindow().setFlags(
                WindowManager.LayoutParams.FLAG_FULLSCREEN,
                WindowManager.LayoutParams.FLAG_FULLSCREEN);
    }

    private void closeAutoFillonAndroid8() {
        // 禁止自动填充
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            getWindow()
                    .getDecorView()
                    .setImportantForAutofill(View.IMPORTANT_FOR_AUTOFILL_NO_EXCLUDE_DESCENDANTS);
        }
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        if (newConfig.orientation == Configuration.ORIENTATION_PORTRAIT && isLand) {
            if (screenType == Constants.SCREEN_TYPE_LAND) {
                setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE);
            } else if (screenType == Constants.SCREEN_TYPE_REVERSE_LAND) {
                setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_REVERSE_LANDSCAPE);
            }
        }
        if (newConfig.orientation == Configuration.ORIENTATION_LANDSCAPE && !isLand) {
            setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);
        }
        super.onConfigurationChanged(newConfig);
    }

    @Override
    protected void onPause() {
        super.onPause();
    }

    @Override
    protected void onResume() {
        super.onResume();
    }

    public void checkSpHelper() {
        if (spHelper == null) {
            spHelper = new SpHelper(this, Constants.SP_NAME);
        }
    }

    /**
     * 隐藏软键盘(只适用于Activity，不适用于Fragment)
     */
    public void hideSoftKeyboard() {
        View view = getCurrentFocus();
        if (view != null) {
            InputMethodManager inputMethodManager = (InputMethodManager) getSystemService(Activity.INPUT_METHOD_SERVICE);
            inputMethodManager.hideSoftInputFromWindow(view.getWindowToken(), InputMethodManager.HIDE_NOT_ALWAYS);
        }
    }

    /**
     * 根据CSSErrors 中的code显示错误信息
     *
     * @param code
     */
    protected void showError(final int code) {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                ToastUtil.showToastTip(getApplicationContext(), CSSErrors.getErrorMessage(code), false);
            }
        });
    }

    /**
     * 根据CSSErrors 中的code显示错误信息
     */
    protected void showError(final String msg) {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                ToastUtil.showToastTip(getApplicationContext(), msg, false);
            }
        });
    }

}
