/*
 * Decompiled with CFR 0.152.
 */
package com.css.sdk.cservice.activity;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import com.css.sdk.R;
import com.css.sdk.cservice.activity.AbstractBaseActivity;
import com.css.sdk.cservice.activity.CssWebExplorerActivity;
import com.css.sdk.cservice.activity.SystemMsgDetailActvity;
import com.css.sdk.cservice.adapter.SystemMsgListAdapter;
import com.css.sdk.cservice.base.Constants;
import com.css.sdk.cservice.base.utils.ToastUtil;
import com.css.sdk.cservice.business.BusinessRequest;
import com.css.sdk.cservice.business.RequestCallback;
import com.css.sdk.cservice.data.SystemMsgDetailEntity;
import com.css.sdk.cservice.data.SystemMsgEntity;
import java.util.ArrayList;

public class SystemMsgActivity
extends AbstractBaseActivity {
    private AbsListView aqsContentView;
    private SystemMsgListAdapter adapter;
    private LinearLayout loadingRl;
    private boolean mLoading;
    private ArrayList<SystemMsgEntity> msgList;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Override
    protected void initExtraData() {
    }

    @Override
    public int getLayoutId() {
        return R.layout.css_activity_history;
    }

    @Override
    public void initView() {
        super.initView();
        this.showTitleClose(false);
        this.showTitleBack(true);
        this.showTitleName(true, this.getResources().getString(R.string.css_systemmsg));
        this.aqsContentView = (AbsListView)this.findViewById(R.id.css_history_aqs);
        this.loadingRl = (LinearLayout)this.findViewById(R.id.css_loading_layout);
    }

    @Override
    public void initData() {
        this.requestData();
    }

    private void requestData() {
        this.showLoading();
        BusinessRequest.getSystemMsgList(new RequestCallback<ArrayList<SystemMsgEntity>>(){

            @Override
            public void onSuccess(final ArrayList<SystemMsgEntity> result) {
                SystemMsgActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        SystemMsgActivity.this.hideLoading();
                        if (result == null || result.isEmpty()) {
                            ToastUtil.showToastTip(SystemMsgActivity.this.getApplicationContext(), R.string.css_string_history_empty, false);
                        }
                        SystemMsgActivity.this.msgList = result;
                        if (SystemMsgActivity.this.adapter == null) {
                            SystemMsgActivity.this.adapter = new SystemMsgListAdapter((Context)SystemMsgActivity.this, SystemMsgActivity.this.msgList);
                            SystemMsgActivity.this.aqsContentView.setAdapter((ListAdapter)SystemMsgActivity.this.adapter);
                            SystemMsgActivity.this.aqsContentView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                                public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                                    SystemMsgActivity.this.goMsgDetail(position);
                                }
                            });
                        } else {
                            SystemMsgActivity.this.adapter.setDataList(SystemMsgActivity.this.msgList);
                            SystemMsgActivity.this.adapter.notifyDataSetChanged();
                        }
                    }
                });
            }

            @Override
            public void onFail(String msg, int code) {
                SystemMsgActivity.this.hideLoading();
                SystemMsgActivity.this.showError(code);
            }
        });
    }

    private void goMsgDetail(int position) {
        Intent intent;
        SystemMsgEntity item = this.msgList.get(position);
        if (item == null) {
            this.showError(this.getResources().getString(R.string.css_string_system_error));
            return;
        }
        if (item.type == SystemMsgDetailEntity.SystemMsgType.TEXT) {
            intent = new Intent((Context)this, SystemMsgDetailActvity.class);
            intent.putExtra(Constants.KEY_DETAIL_ID, item.id);
            intent.putExtra(Constants.KEY_DETAIL_NAME, item.title);
        } else {
            intent = new Intent((Context)this, CssWebExplorerActivity.class);
            intent.putExtra(Constants.KEY_DETAIL_ID, item.id);
        }
        this.startActivityForResult(intent, 19);
    }

    private void showLoading() {
        this.mLoading = true;
        this.loadingRl.setVisibility(0);
    }

    private void hideLoading() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                SystemMsgActivity.this.mLoading = false;
                SystemMsgActivity.this.loadingRl.setVisibility(8);
            }
        });
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (this.mLoading && keyCode == 4) {
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        Bundle bundle;
        if (resultCode == 19 && data != null && (bundle = data.getExtras()) != null) {
            String orderId = bundle.getString(Constants.KEY_ORDER_ID);
            String type = bundle.getString(Constants.KEY_ORDER_CHANGE_TYPE);
            if (this.msgList != null && !this.msgList.isEmpty()) {
                for (SystemMsgEntity item : this.msgList) {
                    if (!item.id.equals(orderId)) continue;
                    item.status = type.equals(Constants.SYSTEM_MSG_READED) ? Constants.SYSTEM_MSG_READED : Constants.SYSTEM_MSG_UNREAD;
                    this.adapter.setDataList(this.msgList);
                    this.adapter.notifyDataSetChanged();
                    break;
                }
            }
        }
    }
}

