/*
 * Decompiled with CFR 0.152.
 */
package com.css.sdk.cservice.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.provider.MediaStore;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.view.View;
import android.widget.GridView;
import android.widget.ListAdapter;
import android.widget.TextView;
import com.css.sdk.R;
import com.css.sdk.cservice.activity.BaseActivity;
import com.css.sdk.cservice.activity.PreviewActivity;
import com.css.sdk.cservice.adapter.PictureAdapter;
import com.css.sdk.cservice.adapter.PictureAlbumDirectoryAdapter;
import com.css.sdk.cservice.base.Constants;
import com.css.sdk.cservice.base.utils.ThreadHelper;
import com.css.sdk.cservice.base.utils.ToastUtil;
import com.css.sdk.cservice.data.AlbumData;
import com.css.sdk.cservice.data.ImageFloder;
import com.css.sdk.cservice.view.FolderPopWindow;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;

public class SelectPictureActivity
extends BaseActivity {
    private int selectedPicNum;
    private int currentMaxNum;
    private TextView cancel;
    private TextView title;
    private TextView preview;
    private TextView submit;
    private GridView gridView;
    private FolderPopWindow folderPopWindow;
    private PictureAdapter adapter;
    private ImageFloder currentImageFolder;
    private ImageFloder imageAll;
    private ArrayList<ImageFloder> mDirPaths = new ArrayList();
    private static final int PERMISSION_READ_EXTERNAL_REQUEST_CODE = 17;
    private Handler mHandler;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.css_activity_select_picture);
        this.selectedPicNum = this.getIntent().getIntExtra("selectedPictureNum", 0);
        this.currentMaxNum = 3 - this.selectedPicNum;
        if (this.mHandler == null) {
            this.mHandler = new Handler(){

                public void handleMessage(Message msg) {
                    int what = msg.what;
                    switch (what) {
                        case 1: {
                            AlbumData data = (AlbumData)msg.obj;
                            SelectPictureActivity.this.mDirPaths.addAll(data.getDirPaths());
                            ((SelectPictureActivity)SelectPictureActivity.this).imageAll.images.addAll(data.getAllImages());
                            if (((SelectPictureActivity)SelectPictureActivity.this).imageAll.images.isEmpty()) {
                                ToastUtil.showToastTip(SelectPictureActivity.this.getApplicationContext(), R.string.css_string_album_empty, false);
                                SelectPictureActivity.this.finish();
                                break;
                            }
                            SelectPictureActivity.this.imageAll.setFirstImagePath(data.getAllImages().get(0));
                            SelectPictureActivity.this.adapter.notifyDataSetChanged();
                            SelectPictureActivity.this.folderPopWindow.bindFolder(SelectPictureActivity.this.mDirPaths);
                            break;
                        }
                    }
                }
            };
        }
        this.initView();
    }

    private void initView() {
        this.imageAll = new ImageFloder();
        this.imageAll.setDir(this.getResources().getString(R.string.css_string_all_picture));
        this.imageAll.setChecked(true);
        this.currentImageFolder = this.imageAll;
        this.mDirPaths.add(this.imageAll);
        this.cancel = (TextView)this.findViewById(R.id.css_tv_cancel);
        this.cancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SelectPictureActivity.this.back();
            }
        });
        this.title = (TextView)this.findViewById(R.id.css_tv_title);
        this.title.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (SelectPictureActivity.this.folderPopWindow.isShowing()) {
                    SelectPictureActivity.this.folderPopWindow.dismiss();
                } else if (((SelectPictureActivity)SelectPictureActivity.this).currentImageFolder.images != null && ((SelectPictureActivity)SelectPictureActivity.this).currentImageFolder.images.size() > 0) {
                    SelectPictureActivity.this.folderPopWindow.showAsDropDown((View)SelectPictureActivity.this.title);
                }
            }
        });
        this.preview = (TextView)this.findViewById(R.id.css_tv_preview);
        this.preview.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SelectPictureActivity.this.toPreviewActivity(SelectPictureActivity.this.adapter.getSelectedPics(), 0);
            }
        });
        this.submit = (TextView)this.findViewById(R.id.css_tv_submit);
        this.submit.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SelectPictureActivity.this.submit();
            }
        });
        this.gridView = (GridView)this.findViewById(R.id.css_gridview);
        this.adapter = new PictureAdapter((Activity)this, this.currentImageFolder.images, this.currentMaxNum);
        this.adapter.setListener(new PictureAdapter.OnEventListener(){

            @Override
            public void onPreview(int position) {
                SelectPictureActivity.this.toPreviewActivity(((SelectPictureActivity)SelectPictureActivity.this).currentImageFolder.images, position);
            }

            @Override
            public void selectChanged() {
                SelectPictureActivity.this.submit.setEnabled(SelectPictureActivity.this.adapter.getSelectedPics().size() > 0);
                SelectPictureActivity.this.changeUI();
            }
        });
        this.gridView.setAdapter((ListAdapter)this.adapter);
        this.folderPopWindow = new FolderPopWindow((Context)this);
        this.folderPopWindow.setPictureTitleView(this.title);
        this.folderPopWindow.setOnItemClickListener(new PictureAlbumDirectoryAdapter.OnItemClickListener(){

            @Override
            public void onItemClick(String folderName, ImageFloder floder) {
                SelectPictureActivity.this.title.setText((CharSequence)folderName);
                SelectPictureActivity.this.currentImageFolder = floder;
                SelectPictureActivity.this.adapter.bindDatas(((SelectPictureActivity)SelectPictureActivity.this).currentImageFolder.images);
                SelectPictureActivity.this.adapter.notifyDataSetChanged();
                SelectPictureActivity.this.folderPopWindow.dismiss();
            }
        });
        this.checkPermissionAndLoadImages();
    }

    private void back() {
        if (this.folderPopWindow.isShowing()) {
            this.folderPopWindow.dismiss();
        } else {
            this.finish();
        }
    }

    private void checkPermissionAndLoadImages() {
        if (!Environment.getExternalStorageState().equals("mounted")) {
            return;
        }
        int hasWriteExternalPermission = ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.WRITE_EXTERNAL_STORAGE");
        if (hasWriteExternalPermission == 0) {
            this.loadImageForSDCard();
        } else {
            ActivityCompat.requestPermissions((Activity)this, (String[])new String[]{"android.permission.READ_EXTERNAL_STORAGE"}, (int)17);
        }
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        if (requestCode == 17) {
            if (grantResults.length > 0 && grantResults[0] == 0) {
                this.loadImageForSDCard();
            } else {
                this.finish();
            }
        }
    }

    private void submit() {
        Intent intent = new Intent();
        Bundle bundle = new Bundle();
        bundle.putStringArrayList(Constants.KEY_SELECTED_PICS, this.adapter.getSelectedPics());
        intent.putExtras(bundle);
        this.setResult(-1, intent);
        this.back();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 18 && data != null) {
            Bundle b = data.getExtras();
            ArrayList list = b.getStringArrayList(Constants.KEY_SELECTED_PICS);
            if (list != null && !list.isEmpty()) {
                this.adapter.setSelectedPics(list);
            }
            if (data.getBooleanExtra("is_confirm", false)) {
                this.submit();
            } else {
                if (list != null && !list.isEmpty()) {
                    this.adapter.notifyDataSetChanged();
                }
                this.changeUI();
            }
        }
    }

    private void changeUI() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getResources().getString(R.string.css_string_submit)).append("(").append(this.adapter.getSelectedPics().size()).append("/").append(this.currentMaxNum).append(")");
        this.submit.setText((CharSequence)sb.toString());
        sb.delete(0, sb.length());
        sb.append(this.getString(R.string.css_string_preview)).append("(").append(this.adapter.getSelectedPics().size()).append(")");
        this.preview.setText((CharSequence)sb.toString());
    }

    private void loadImageForSDCard() {
        ThreadHelper.runOnWorkThread(new Runnable(){

            @Override
            public void run() {
                ArrayList<String> allImages = new ArrayList<String>();
                HashMap<String, Integer> tmpDir = new HashMap<String, Integer>();
                ArrayList<ImageFloder> mDirPaths = new ArrayList<ImageFloder>();
                Cursor mCursor = SelectPictureActivity.this.getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, new String[]{"_data", "_display_name", "date_added", "_id", "mime_type"}, null, null, "date_added");
                if (mCursor.moveToLast()) {
                    int _date = mCursor.getColumnIndex("_data");
                    do {
                        String path = mCursor.getString(_date);
                        allImages.add(path);
                        File parentFile = new File(path).getParentFile();
                        if (parentFile == null) continue;
                        ImageFloder imageFloder = null;
                        String dirPath = parentFile.getAbsolutePath();
                        if (!tmpDir.containsKey(dirPath)) {
                            imageFloder = new ImageFloder();
                            imageFloder.setDir(dirPath);
                            imageFloder.setFirstImagePath(path);
                            mDirPaths.add(imageFloder);
                            tmpDir.put(dirPath, mDirPaths.indexOf(imageFloder));
                        } else {
                            imageFloder = mDirPaths.get((Integer)tmpDir.get(dirPath));
                        }
                        imageFloder.images.add(path);
                    } while (mCursor.moveToPrevious());
                }
                mCursor.close();
                Message msg = new Message();
                AlbumData data = new AlbumData(allImages, mDirPaths);
                msg.obj = data;
                msg.what = 1;
                if (SelectPictureActivity.this.mHandler != null) {
                    SelectPictureActivity.this.mHandler.sendMessage(msg);
                }
            }
        });
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.mHandler != null) {
            this.mHandler.removeCallbacksAndMessages(null);
            this.mHandler = null;
        }
    }

    private void toPreviewActivity(ArrayList<String> images, int position) {
        if (images != null && !images.isEmpty()) {
            Intent intent = new Intent((Context)this, PreviewActivity.class);
            Bundle b = new Bundle();
            b.putStringArrayList(Constants.KEY_ALL_PICS, images);
            b.putStringArrayList(Constants.KEY_SELECTED_PICS, this.adapter.getSelectedPics());
            b.putInt(Constants.KEY_MAX_NUM, this.currentMaxNum);
            b.putInt(Constants.KEY_POSITION, position);
            b.putInt(Constants.KEY_PREVIEW_TYPE, Constants.PREVIEW_TYPE_SELECT);
            intent.putExtras(b);
            this.startActivityForResult(intent, 18);
        }
    }
}

