/*
 * Decompiled with CFR 0.152.
 */
package com.css.sdk.cservice.activity;

import android.content.Context;
import android.content.Intent;
import android.graphics.Point;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.design.widget.TabLayout;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.WindowManager;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.css.sdk.R;
import com.css.sdk.cservice.activity.BaseActivity;
import com.css.sdk.cservice.adapter.PopupListAdapter;
import com.css.sdk.cservice.base.Constants;
import com.css.sdk.cservice.data.PopWindowEntity;
import com.css.sdk.cservice.userdata.GlobalData;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;
import com.qmuiteam.qmui.widget.popup.QMUIListPopup;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractBaseActivity
extends BaseActivity {
    private QMUIListPopup mListPopup;

    protected abstract void initExtraData();

    public abstract int getLayoutId();

    public void initView() {
        this.changeTitleColor(GlobalData.getUiColor());
    }

    public abstract void initData();

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.initExtraData();
        this.setContentView(this.getLayoutId());
        this.initView();
        this.initData();
    }

    public void showTitleBack(boolean show) {
        RelativeLayout titleBack = (RelativeLayout)this.findViewById(R.id.css_title_back);
        titleBack.setVisibility(show ? 0 : 8);
        titleBack.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AbstractBaseActivity.this.finish();
            }
        });
    }

    public void changeTitleColor(int rgb) {
        RelativeLayout titleRoot = (RelativeLayout)this.findViewById(R.id.css_title_rl);
        titleRoot.setBackgroundColor(rgb);
    }

    protected void showTitleClose(boolean show) {
        RelativeLayout closeRoot = (RelativeLayout)this.findViewById(R.id.css_title_close);
        closeRoot.setVisibility(show ? 0 : 8);
        closeRoot.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AbstractBaseActivity.this.finish();
            }
        });
    }

    protected void showTitleName(boolean show, String name) {
        RelativeLayout titleTvRoot = (RelativeLayout)this.findViewById(R.id.rl_titile_text);
        titleTvRoot.setVisibility(show ? 0 : 8);
        if (!show) {
            return;
        }
        TextView titleTv = (TextView)this.findViewById(R.id.css_title_tv);
        titleTv.setText((CharSequence)name);
    }

    protected void showTitleName(boolean show, String name, int color2) {
        RelativeLayout titleTvRoot = (RelativeLayout)this.findViewById(R.id.rl_titile_text);
        titleTvRoot.setVisibility(show ? 0 : 8);
        if (!show) {
            return;
        }
        TextView titleTv = (TextView)this.findViewById(R.id.css_title_tv);
        titleTv.setText((CharSequence)name);
        titleTv.setTextColor(color2);
    }

    protected void showTitleLargeSearch(boolean show) {
        LinearLayout largeSeachRoot = (LinearLayout)this.findViewById(R.id.rl_title_largesearch);
        largeSeachRoot.setVisibility(show ? 0 : 8);
    }

    protected View showTitleShortSearch(boolean show) {
        LinearLayout searchRoot = (LinearLayout)this.findViewById(R.id.rl_title_shortsearch);
        searchRoot.setVisibility(show ? 0 : 8);
        return searchRoot;
    }

    protected void showTitleTab(boolean show, List<String> tags, TabLayout.BaseOnTabSelectedListener listener) {
        RelativeLayout tabLayout = (RelativeLayout)this.findViewById(R.id.rl_titile_tab);
        tabLayout.setVisibility(show ? 0 : 8);
        if (!show) {
            return;
        }
        TabLayout mTabLayout = (TabLayout)this.findViewById(R.id.css_title_tab_layout);
        for (String tag : tags) {
            mTabLayout.addTab(mTabLayout.newTab().setText((CharSequence)tag));
        }
        mTabLayout.addOnTabSelectedListener(listener);
    }

    protected void goActvityForResult(Context clz, Class targetClz, int requestCode) {
        Intent intent = new Intent(clz, targetClz);
        this.startActivityForResult(intent, requestCode);
    }

    protected void showTitleService(boolean show, boolean hasHistroyNotice, TitlePopListWindowListener listener) {
        final RelativeLayout serviceRoot = (RelativeLayout)this.findViewById(R.id.css_title_service);
        serviceRoot.setVisibility(show ? 0 : 8);
        ImageView alertIv = (ImageView)this.findViewById(R.id.css_title_service_reply);
        if (hasHistroyNotice) {
            alertIv.setVisibility(0);
        } else {
            alertIv.setVisibility(8);
        }
        if (listener == null) {
            return;
        }
        this.initListPopupIfNeed(hasHistroyNotice, listener);
        serviceRoot.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AbstractBaseActivity.this.mListPopup.setAnimStyle(3);
                AbstractBaseActivity.this.mListPopup.setPreferredDirection(1);
                AbstractBaseActivity.this.mListPopup.show((View)serviceRoot);
            }
        });
    }

    protected void showTitleServiceReply(boolean show) {
        ImageView serviceReply = (ImageView)this.findViewById(R.id.css_title_service_reply);
        serviceReply.setVisibility(show ? 0 : 8);
    }

    protected void showTitleSystemMsg(boolean show, View.OnClickListener listener) {
        RelativeLayout systemMsgRoot = (RelativeLayout)this.findViewById(R.id.css_title_system_msg);
        systemMsgRoot.setVisibility(show ? 0 : 8);
        if (listener == null) {
            return;
        }
        systemMsgRoot.setOnClickListener(listener);
    }

    protected void showTitleSystemMsgReply(boolean show) {
        ImageView msgReply = (ImageView)this.findViewById(R.id.css_title_system_msg_reply);
        msgReply.setVisibility(show ? 0 : 8);
    }

    protected int dp2px(Context context, float dpValue) {
        return (int)TypedValue.applyDimension((int)1, (float)dpValue, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    protected Point getScreenMsg(Context context) {
        Point point = new Point();
        WindowManager wm = (WindowManager)context.getSystemService("window");
        wm.getDefaultDisplay().getSize(point);
        return point;
    }

    private void initListPopupIfNeed(boolean showHistoryNotice, final TitlePopListWindowListener listener) {
        PopWindowEntity feedback = new PopWindowEntity(R.drawable.css_icon_edit_blue, this.getResources().getString(R.string.css_text_submit_qa));
        feedback.status = Constants.SYSTEM_MSG_READED;
        PopWindowEntity history = new PopWindowEntity(R.drawable.css_icon_viewlist, this.getResources().getString(R.string.css_string_feedback_history));
        history.status = showHistoryNotice ? Constants.SYSTEM_MSG_UNREAD : Constants.SYSTEM_MSG_READED;
        ArrayList<PopWindowEntity> data = new ArrayList<PopWindowEntity>();
        data.add(feedback);
        data.add(history);
        PopupListAdapter popupListAdapter = new PopupListAdapter((Context)this, data);
        this.mListPopup = new QMUIListPopup((Context)this, 2, (BaseAdapter)popupListAdapter);
        this.mListPopup.create(QMUIDisplayHelper.dp2px((Context)this, (int)100), QMUIDisplayHelper.dp2px((Context)this, (int)90), new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                AbstractBaseActivity.this.mListPopup.dismiss();
                if (listener != null) {
                    listener.onClick(i);
                }
            }
        });
    }

    public static interface TitlePopListWindowListener {
        public void onClick(int var1);
    }
}

