package com.css.sdk.cservice.adapter;

import android.content.Context;
import android.graphics.Color;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.css.sdk.R;
import com.css.sdk.cservice.base.Constants;
import com.css.sdk.cservice.data.HistoryItem;
import com.css.sdk.cservice.userdata.GlobalData;

import java.util.List;

/**
 * @ProjectName: customerservicesdk
 * @Package: com.css.sdk.cservice.adapter
 * @ClassName: CssTextGridViewAdapter
 * @Description: CssTextGridViewAdapter
 * @Author: Roy
 * @CreateDate: 2020/5/22 14:46
 */

public class HistoryGridViewAdapter extends BaseAdapter {
    private Context mContext;
    private List<HistoryItem> dataList;

    public HistoryGridViewAdapter(Context mContext, List<HistoryItem> dataList) {
        this.mContext = mContext;
        this.dataList = dataList;
    }

    public void setDataList(List<HistoryItem> dataList) {
        this.dataList = dataList;
    }

    @Override
    public int getCount() {
        return dataList == null ? 0 : dataList.size();
    }

    @Override
    public Object getItem(int position) {
        return null;
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder holder = null;
        if (convertView == null) {
            convertView = LayoutInflater.from(mContext).inflate(R.layout.css_gridview_history_faq_item, parent, false);
            holder = new ViewHolder();
            holder.root = convertView.findViewById(R.id.css_history_grideview_item_root);
            holder.content = convertView.findViewById(R.id.css_item_content);
            holder.msg = convertView.findViewById(R.id.css_iv_item_history_msg);
            convertView.setTag(holder);

        } else {
            holder = (ViewHolder) convertView.getTag();
        }

        final HistoryItem item = dataList.get(position);
        holder.content.setText(item.title);
        if (item.status.equals(Constants.QA_STATUS_PROCESSED)) {
            faqNewMessage(holder);
        } else if (item.status.equals(Constants.QA_STATUS_CLOSED)) {
            faqClose(holder);
        } else {
            faqDefault(holder);
        }

        return convertView;
    }


    class ViewHolder {
        RelativeLayout root;
        TextView content;
        ImageView msg;
    }

    private void faqNewMessage(ViewHolder viewHolder) {
        viewHolder.root.setBackgroundColor(GlobalData.getUiAlphaColor());
        viewHolder.msg.setVisibility(View.VISIBLE);
        viewHolder.content.setTextColor(mContext.getResources().getColor(R.color.css_default_blue));
    }

    private void faqDefault(ViewHolder viewHolder) {
        viewHolder.root.setBackgroundColor(GlobalData.getUiAlphaColor());
        viewHolder.msg.setVisibility(View.GONE);
        viewHolder.content.setTextColor(mContext.getResources().getColor(R.color.css_default_text_color_black));
    }

    private void faqClose(ViewHolder viewHolder) {
        viewHolder.root.setBackgroundColor(mContext.getResources().getColor(R.color.css_default_gray));
        viewHolder.msg.setVisibility(View.GONE);
        viewHolder.content.setTextColor(mContext.getResources().getColor(R.color.css_default_text_dark_gray));
    }

}
