package com.css.sdk.cservice.activity;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.text.method.ScrollingMovementMethod;
import android.view.View;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.css.sdk.R;
import com.css.sdk.cservice.base.Constants;
import com.css.sdk.cservice.business.BusinessRequest;
import com.css.sdk.cservice.business.RequestCallback;
import com.css.sdk.cservice.data.FaqDetail;
import com.css.sdk.cservice.userdata.GlobalData;
import com.css.sdk.cservice.utils.ToastHelper;
import com.css.sdk.cservice.view.CssQDWebView;
import com.css.sdk.cservice.view.CssRoundBtn;
import com.qmuiteam.qmui.util.QMUILangHelper;
import com.qmuiteam.qmui.widget.webview.QMUIWebViewClient;

import static com.css.sdk.cservice.base.Constants.KEY_DETIAL_EVALUATE_RESULT;
import static com.css.sdk.cservice.base.Constants.REQUESTCODE_SUBMITSUCCESS_FQADETAIL;

public class FaqDetailActvity extends AbstractBaseActivity {
    private String recommendId;
    private TextView answerTv;
    private CssRoundBtn unsolve;
    private CssRoundBtn solve;
    private LinearLayout loadingLl;
    private TextView bottomHintTv;
    private FaqDetail detail;
    private RelativeLayout bottomBtnLl;
    private String faqName;
    private String quId = "";
    private CssQDWebView webView;
    private final static int PROGRESS_PROCESS = 0;
    private final static int PROGRESS_GONE = 1;
    private boolean mIsPageFinished = false;
    private boolean mNeedDecodeUrl = false;
    private ProgressBar mProgressBar;
    private ProgressHandler mProgressHandler;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Override
    protected void initExtraData() {
        recommendId = getIntent().getStringExtra(Constants.KEY_RECOMMEND_ID);
        faqName = getIntent().getStringExtra(Constants.KEY_RECOMMEND_NAME);
        quId = getIntent().getStringExtra(Constants.KEY_QU_ID);
    }

    @Override
    public int getLayoutId() {
        return R.layout.css_activity_faq_detail_actvity;
    }

    @Override
    public void initView() {
        super.initView();
        showTitleClose(true);
        if (faqName.length() >= 60) {
            String substring = faqName.substring(0, 60);
            faqName = substring + "\n" + faqName.substring(60, faqName.length());
        }
        showTitleName(true, faqName);
        answerTv = findViewById(R.id.css_answer);
        answerTv.setMovementMethod(ScrollingMovementMethod.getInstance());
        answerTv.setVisibility(View.GONE);
        unsolve = findViewById(R.id.css_rl_unsolveqa);
        bottomHintTv = findViewById(R.id.css_hint);
        bottomBtnLl = findViewById(R.id.css_bottom_rl);
        bottomBtnLl.setVisibility(View.GONE);
        unsolve.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                evaluate(false);
            }
        });
        solve = findViewById(R.id.css_rl_solveqa);
        solve.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                evaluate(true);
            }
        });
        mProgressBar = findViewById(R.id.progress_bar);
        mProgressHandler = new ProgressHandler();
        loadingLl = findViewById(R.id.css_loading_layout);
        webView = findViewById(R.id.css_web);
        webView.setVisibility(View.GONE);
    }

    private void initWebView(String url) {
        webView.setWebChromeClient(new WebChromeClient() {
            @Override
            public void onProgressChanged(WebView view, int newProgress) {
                super.onProgressChanged(view, newProgress);
                // 修改进度条
                if (newProgress > mProgressHandler.mDstProgressIndex) {
                    sendProgressMessage(PROGRESS_PROCESS, newProgress, 100);
                }
            }

            @Override
            public void onReceivedTitle(WebView view, String title) {
                super.onReceivedTitle(view, title);
            }

            @Override
            public void onShowCustomView(View view, CustomViewCallback callback) {
                callback.onCustomViewHidden();
            }

        });
        webView.setWebViewClient(new QMUIWebViewClient(false, true) {

            @Override
            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                super.onPageStarted(view, url, favicon);
                if (mProgressHandler.mDstProgressIndex == 0) {
                    sendProgressMessage(PROGRESS_PROCESS, 30, 500);
                }
            }

            @Override
            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                sendProgressMessage(PROGRESS_GONE, 100, 0);
            }


        });
        webView.requestFocus(View.FOCUS_DOWN);
        webView.getSettings().setDisplayZoomControls(false);
        webView.loadUrl(url);
    }

    private void sendProgressMessage(int progressType, int newProgress, int duration) {
        Message msg = new Message();
        msg.what = progressType;
        msg.arg1 = newProgress;
        msg.arg2 = duration;
        mProgressHandler.sendMessage(msg);
    }


    @Override
    public void initData() {
        requestData();
    }

    private void showLoading() {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                if (!loadingLl.isShown()) {
                    loadingLl.setVisibility(View.VISIBLE);
                }
            }
        });
    }

    private void hideLoading() {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                if (loadingLl.isShown()) {
                    loadingLl.setVisibility(View.GONE);
                }
            }
        });
    }

    private void evaluate(boolean isHelp) {
        showLoading();
        BusinessRequest.evaluateFqa(recommendId, isHelp, new RequestCallback<String>() {
            @Override
            public void onSuccess(String result) {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        hideLoading();
                        if (isHelp) {
                            bottomHintTv.setText(R.string.css_string_thanks_for_evaluate);
                            bottomBtnLl.setVisibility(View.GONE);
                            if (TextUtils.isEmpty(quId)) {
                                ToastHelper.showShortToastCenter(getResources().getString(R.string.css_string_thanks_for_evaluate));
                            } else {
                                backToSubmitSuccess(isHelp);
                            }
                            finish();
                        } else {
                            if (TextUtils.isEmpty(quId)) {
                                bottomHintTv.setText(R.string.css_text_hint_nohelp);
                                bottomBtnLl.setVisibility(View.VISIBLE);
                                solve.setVisibility(View.GONE);
                                showFeedback();
                            } else {
                                ToastHelper.showShortToastCenter(getResources().getString(R.string.css_string_thanks_for_evaluate));
                                finish();
                            }
                        }

                    }
                });
            }

            @Override
            public void onFail(String msg, int code) {
                hideLoading();
                showError(code);
            }
        });
    }

    private void showFeedback() {
        unsolve.setBackground(getResources().getDrawable(R.drawable.css_shape_rounded_bg_whitesolied_blueline));
        unsolve.changeBgColor(GlobalData.getUiColor(),GlobalData.getUiColor());
        unsolve.setText(getResources().getString(R.string.css_string_feedback_new));
        unsolve.changeTextColor(Color.WHITE);
        unsolve.setImgVisible(View.GONE);
        unsolve.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent intent = new Intent(FaqDetailActvity.this, FeedBackActivity.class);
                startActivity(intent);
                finish();
            }
        });
    }

    private void backToSubmitSuccess(boolean isHelp) {
        Intent intent = new Intent(FaqDetailActvity.this, SubmitSuccessActivity.class);
        intent.putExtra(KEY_DETIAL_EVALUATE_RESULT, isHelp);
        FaqDetailActvity.this.setResult(REQUESTCODE_SUBMITSUCCESS_FQADETAIL, intent);
    }

    private void requestData() {
        showLoading();
        BusinessRequest.getFaqDetail(this, recommendId, new RequestCallback<FaqDetail>() {
            @Override
            public void onSuccess(final FaqDetail result) {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        hideLoading();
                        if (result == null) {
                            showError(getResources().getString(R.string.css_string_system_error));
                            return;
                        }
                        detail = result;
                        if (!TextUtils.isEmpty(detail.answer)) {
                            // 判断是文本还是html
                            showStyle(detail.format);
                            bottomBtnLl.setVisibility(View.VISIBLE);
                        } else {
                            answerTv.setVisibility(View.GONE);
                            bottomBtnLl.setVisibility(View.GONE);
                        }
                    }
                });
            }

            @Override
            public void onFail(final String msg, int code) {
                hideLoading();
                showError(code);
            }
        });
    }

    private void showStyle(String content) {
        if (content.equals("text")) {
            answerTv.setText(detail.answer);
            answerTv.setVisibility(View.VISIBLE);
            webView.setVisibility(View.GONE);
        } else {
            answerTv.setVisibility(View.GONE);
            webView.setVisibility(View.VISIBLE);
            initWebView(detail.answer);
        }

    }

    private class ProgressHandler extends Handler {
        private int mDstProgressIndex;
        private int mDuration;
        private ObjectAnimator mAnimator;

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case PROGRESS_PROCESS:
                    mIsPageFinished = false;
                    mDstProgressIndex = msg.arg1;
                    mDuration = msg.arg2;
                    mProgressBar.setVisibility(View.VISIBLE);
                    if (mAnimator != null && mAnimator.isRunning()) {
                        mAnimator.cancel();
                    }
                    mAnimator = ObjectAnimator.ofInt(mProgressBar, "progress", mDstProgressIndex);
                    mAnimator.setDuration(mDuration);
                    mAnimator.addListener(new AnimatorListenerAdapter() {
                        @Override
                        public void onAnimationEnd(Animator animation) {
                            if (mProgressBar.getProgress() == 100) {
                                sendEmptyMessageDelayed(PROGRESS_GONE, 500);
                            }
                        }
                    });
                    mAnimator.start();
                    break;
                case PROGRESS_GONE:
                    mDstProgressIndex = 0;
                    mDuration = 0;
                    mProgressBar.setProgress(0);
                    mProgressBar.setVisibility(View.GONE);
                    if (mAnimator != null && mAnimator.isRunning()) {
                        mAnimator.cancel();
                    }
                    mAnimator = ObjectAnimator.ofInt(mProgressBar, "progress", 0);
                    mAnimator.setDuration(0);
                    mAnimator.removeAllListeners();
                    mIsPageFinished = true;
                    break;
                default:
                    break;
            }
        }
    }
}
