package com.css.sdk.cservice.activity;

import android.content.Intent;
import android.graphics.Color;
import android.support.design.widget.TabLayout;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;

import com.css.sdk.R;
import com.css.sdk.cservice.adapter.HorizonTabAdapter;
import com.css.sdk.cservice.adapter.SimpleTextGridViewAdapter;
import com.css.sdk.cservice.base.CSSErrors;
import com.css.sdk.cservice.base.Constants;
import com.css.sdk.cservice.base.utils.LogUtils;
import com.css.sdk.cservice.business.BusinessRequest;
import com.css.sdk.cservice.business.RequestCallback;
import com.css.sdk.cservice.constant.SubmitEntryModelEnum;
import com.css.sdk.cservice.data.FaqItem;
import com.css.sdk.cservice.data.FaqTypeItem;
import com.css.sdk.cservice.data.SystemMsgEntity;
import com.css.sdk.cservice.data.SystemNoticeItem;
import com.css.sdk.cservice.listener.CSSExistNewReplyCallback;
import com.css.sdk.cservice.userdata.GlobalData;
import com.css.sdk.cservice.view.CommonDialog;
import com.css.sdk.cservice.view.CssRoundBtn;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class FaqActivity extends AbstractBaseActivity {

    private List<FaqItem> faqs = new ArrayList<>();
    List<FaqTypeItem> faqTypeItems;

    // land
    private ListView verticalTabs;
    private HorizonTabAdapter horizonTabAdapter;

    // port
    private TabLayout mTab;

    // common
    private AbsListView tabsContentView;
    private CssRoundBtn qaHistoryBtn;
    private CssRoundBtn qaSubmitBtn;
    private SimpleTextGridViewAdapter contentViewAdapter;
    private LinearLayout loadingView;
    private TextView nodataView;

    // notice relative
    private Map<String, CommonDialog> noticeDialogs = new LinkedHashMap<String, CommonDialog>();
    CommonDialog targetDialog = null;
    String targetId = "";
    private boolean newSevicesReply;

    @Override
    public int getLayoutId() {
        return R.layout.css_activity_faq;
    }

    @Override
    public void initView() {
        super.initView();
        if (isLand) {
            verticalTabs = findViewById(R.id.css_horizontab);
        } else {
            mTab = findViewById(R.id.css_tabs);
            mTab.setSelectedTabIndicatorColor(GlobalData.getUiColor());
            mTab.setTabTextColors(getResources().getColor(R.color.css_color_text_gray), GlobalData.getUiColor());
        }
        initCommonView();
    }

    private void initCommonView() {
        qaSubmitBtn = findViewById(R.id.css_btn_submit_qa);
        qaHistoryBtn = findViewById(R.id.css_faq_rightbtn);
        qaHistoryBtn.changeBgColor(Color.WHITE, GlobalData.getUiColor());
        qaHistoryBtn.changeTextColor(GlobalData.getUiColor());
        qaSubmitBtn.changeBgColor(GlobalData.getUiColor(), GlobalData.getUiColor());
        if (GlobalData.getSubmitModel() == SubmitEntryModelEnum.NORMAL) {
            showNormalStyle();
        } else if (GlobalData.getSubmitModel() == SubmitEntryModelEnum.WEAK) {
            showWeakStyle();
        }

        LinearLayout titleSearch = (LinearLayout) showTitleShortSearch(true);
        showTitleBack(true);

        tabsContentView = findViewById(R.id.css_faqs_list);
        loadingView = findViewById(R.id.css_loading_layout);
        nodataView = findViewById(R.id.css_recommedfaq_nodata);

        titleSearch.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                startActivity(new Intent(FaqActivity.this, FaqListActivity.class));
            }
        });

        tabsContentView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                // 有两个item是没有数据，只是用来充数的
                if (TextUtils.isEmpty(faqs.get(position).id)) {
                    return;
                }
                goToFaqDetail(position);
            }
        });
    }

    private void showNormalStyle() {
        qaSubmitBtn.setVisibility(View.VISIBLE);
        qaHistoryBtn.setVisibility(View.VISIBLE);
        qaHistoryBtn.setAlertIconVisible(View.GONE);
        qaHistoryBtn.setImgVisible(View.GONE);
        showTitleService(false, false, null);
        showTitleSystemMsg(true, new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                startActivity(new Intent(FaqActivity.this, SystemMsgActivity.class));
            }
        });
        qaSubmitBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                startActivity(new Intent(FaqActivity.this, FeedBackActivity.class));
            }
        });
        qaHistoryBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                startActivity(new Intent(FaqActivity.this, HistoryActivity.class));
            }
        });
    }

    private void showWeakStyle() {
        qaSubmitBtn.setVisibility(View.GONE);
        qaHistoryBtn.setVisibility(View.GONE);
        showTitleService(true, false, new TitlePopListWindowListener() {
            @Override
            public void onClick(int i) {
                if (i == 0) {
                    startActivity(new Intent(FaqActivity.this, FeedBackActivity.class));
                } else if (i == 1) {
                    startActivity(new Intent(FaqActivity.this, HistoryActivity.class));
                }
            }
        });
//        showTitleServiceReply(true);
        showTitleSystemMsg(true, new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                startActivity(new Intent(FaqActivity.this, SystemMsgActivity.class));
            }
        });
//        showTitleSystemMsgReply(true);
    }


    @Override
    protected void onResume() {
        super.onResume();
        getNewReply();
        // 没有status属性，没法作为未读的标志，暂时放弃
        getSystemMsg();

    }

    /**
     * @param
     * @return
     * @description 是否存在未读的系统消息
     */
    private void getSystemMsg() {
        BusinessRequest.getSystemMsgList(new RequestCallback<ArrayList<SystemMsgEntity>>() {
            @Override
            public void onSuccess(ArrayList<SystemMsgEntity> result) {
                boolean hasUnread = false;
                if (result != null && result.size() > 0) {
                    for (SystemMsgEntity msgEntity : result) {
                        if (msgEntity.status.equals(Constants.SYSTEM_MSG_UNREAD)) {
                            hasUnread = true;
                            break;
                        }
                    }
                    if (hasUnread) {
                        runOnUiThread(new Runnable() {
                            @Override
                            public void run() {
                                showTitleSystemMsgReply(true);
                            }
                        });
                    } else {
                        runOnUiThread(new Runnable() {
                            @Override
                            public void run() {
                                showTitleSystemMsgReply(false);
                            }
                        });
                    }
                }
            }

            @Override
            public void onFail(String msg, int code) {
                // 不做操作
            }
        });
    }


    /**
     * 是否存在未读的客服信息
     */
    private void getNewReply() {
        BusinessRequest.getExistNewReplyInner(new CSSExistNewReplyCallback() {
            @Override
            public void hasNewReplySuccess(boolean hasMsg) {
                newSevicesReply = hasMsg;
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        if (GlobalData.getSubmitModel() == SubmitEntryModelEnum.WEAK) {
                            showTitleService(true, hasMsg, new TitlePopListWindowListener() {
                                @Override
                                public void onClick(int i) {
                                    if (i == 0) {
                                        startActivity(new Intent(FaqActivity.this, FeedBackActivity.class));
                                    } else if (i == 1) {
                                        startActivity(new Intent(FaqActivity.this, HistoryActivity.class));
                                    }
                                }
                            });
                        } else {
                            if (hasMsg) {
                                qaHistoryBtn.setAlertIconVisible(View.VISIBLE);
                            } else {
                                qaHistoryBtn.setAlertIconVisible(View.GONE);
                            }
                        }

                    }
                });
            }

            @Override
            public void hasNewReplyFail(String msg) {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        qaHistoryBtn.setAlertIconVisible(View.VISIBLE);
                    }
                });
            }
        });
    }

    @Override
    public void initData() {
        faqTypeItems = GlobalData.getTypeItems();
        if (faqTypeItems == null || faqTypeItems.size() <= 0) {
            showError(CSSErrors.CSS_ERROR_RESPONSE_JSON_EXCEPTION);
            return;
        }
        if (isLand) {
            initDatainLand();
        } else {
            initDatainPort();
        }
        requestSystemNotice();
    }


    /**
     * @param
     * @return
     * @description 获得系统公告
     */
    private void requestSystemNotice() {
        showLoadingView();
        BusinessRequest.getSystemNoticeList(new RequestCallback<ArrayList<SystemNoticeItem>>() {
            @Override
            public void onSuccess(ArrayList<SystemNoticeItem> results) {
                hideLoadingView();
                // 创建dialogfragment然后显示
                if (results == null || results.size() <= 0) {
                    return;
                }
                // 初始化noticeDialog
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        for (SystemNoticeItem result : results) {
//                            if (!spHelper.getBoolean(result.id)) {
                                final CommonDialog dialog = new CommonDialog(FaqActivity.this);
                                dialog.setMessage(result.content)
                                        .setTitle(result.title)
                                        .setSingle(true)
                                        .setPositive(getResources().getString(R.string.css_string_got_it))
                                        .setPositiveColor(GlobalData.getUiColor());
                                noticeDialogs.put(result.id, dialog);
//                            }
                        }
                        if (noticeDialogs.size() > 0) {
                            showNoticeDialog();
                        }
                    }
                });
            }

            @Override
            public void onFail(String msg, int code) {
                hideLoadingView();

                LogUtils.i("requestSystemNotice onFail is " + msg);
            }
        });
    }

    private void showNoticeDialog() {
        for (Map.Entry<String, CommonDialog> entry : noticeDialogs.entrySet()) {
            targetId = entry.getKey();
            targetDialog = entry.getValue();
        }
        if (targetDialog == null) {
            return;
        }
        targetDialog.setOnClickBottomListener(new DialogBtnListener(targetId));
        targetDialog.show(this);
    }

    /**
     * @param
     * @description 通知阅读完后的操作
     * @return
     */
    class DialogBtnListener implements CommonDialog.OnClickBottomListener {
        private String targetId;

        public DialogBtnListener(String targetId) {
            this.targetId = targetId;
        }

        @Override
        public void onPositiveClick() {
            // save to sp and remove key in map
            spHelper.putBoolean(targetId, true);
            noticeDialogs.remove(targetId);
            targetDialog.dismiss();
            if (noticeDialogs.size() == 0) {
                return;
            }
            showNoticeDialog();
        }

        @Override
        public void onNegtiveClick() {
        }
    }

    private void initDatainPort() {
        // 初始化上方的tab页面
        initTabLayout();
        requestFaq(0);
        //初始化对应的listview
        initFaqList();
    }

    private void initFaqList() {
        tabsContentView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                // 有两个item是没有数据，只是用来充数的
                if (TextUtils.isEmpty(faqs.get(position).id)) {
                    return;
                }
                goToFaqDetail(position);
            }
        });

    }

    private void initTabLayout() {
        List<String> tabs = new ArrayList<>();
        for (FaqTypeItem item : faqTypeItems) {
            tabs.add(item.getFaqTypeByLanguage(this));
        }
        for (String tag : tabs) {
            mTab.addTab(mTab.newTab().setText(tag));
        }
        mTab.addOnTabSelectedListener(new TabLayout.OnTabSelectedListener() {
            @Override
            public void onTabSelected(TabLayout.Tab tab) {
                requestFaq(tab.getPosition());
                if (contentViewAdapter != null)
                    contentViewAdapter.notifyDataSetChanged();
            }

            @Override
            public void onTabUnselected(TabLayout.Tab tab) {

            }

            @Override
            public void onTabReselected(TabLayout.Tab tab) {

            }
        });
    }


    private void initDatainLand() {
        horizonTabAdapter = new HorizonTabAdapter(this, faqTypeItems);
        verticalTabs.setAdapter(horizonTabAdapter);
        requestFaq(0);
        verticalTabs.setSelection(0);
        verticalTabs.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                horizonTabAdapter.setSelectedId(position);
                horizonTabAdapter.notifyDataSetChanged();
                requestFaq(position);
            }
        });

    }

    private void goToFaqDetail(int position) {
        Intent i = new Intent(FaqActivity.this, FaqDetailActvity.class);
        i.putExtra(Constants.KEY_RECOMMEND_ID, faqs.get(position).id);
        i.putExtra(Constants.KEY_RECOMMEND_NAME, faqs.get(position).getFaqTypeByLanguage(FaqActivity.this));
        startActivity(i);
    }

    @Override
    protected void initExtraData() {

    }


    private void requestFaq(int position) {
        showLoadingView();
        hideNodataView();
        BusinessRequest.getFaqList(faqTypeItems.get(position).getId(), new RequestCallback<List<FaqItem>>() {
            @Override
            public void onSuccess(List<FaqItem> result) {
                hideLoadingView();
                faqs = result;
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {

                        if (faqs == null || faqs.size() <= 0) {
                            tabsContentView.setVisibility(View.GONE);
                            return;
                        } else {
                            // 为了空出最后一行，追加两个entity
                            tabsContentView.setVisibility(View.VISIBLE);
                            faqs.add(new FaqItem());
                            faqs.add(new FaqItem());
                        }
                        contentViewAdapter = new SimpleTextGridViewAdapter(FaqActivity.this, faqs);
                        tabsContentView.setAdapter(contentViewAdapter);
                    }
                });

            }

            @Override
            public void onFail(String msg, int code) {
                hideLoadingView();
                showNodataView();
            }
        });
    }

    private void showLoadingView() {
        if (!loadingView.isShown()) {
            loadingView.setVisibility(View.VISIBLE);
        }
    }

    private void hideLoadingView() {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                if (loadingView.isShown()) {
                    loadingView.setVisibility(View.GONE);
                }
            }
        });
    }

    private void showNodataView() {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                if (!nodataView.isShown()) {
                    nodataView.setVisibility(View.VISIBLE);
                }
            }
        });
    }

    private void hideNodataView() {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                if (nodataView.isShown()) {
                    nodataView.setVisibility(View.GONE);
                }
            }
        });
    }
}
