/*
 * Decompiled with CFR 0.152.
 */
package com.css.sdk.cservice.refresh;

import android.animation.ObjectAnimator;
import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.support.v4.widget.ListViewCompat;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.ListView;
import android.widget.Scroller;
import com.css.sdk.R;
import com.css.sdk.cservice.refresh.HeadManager;
import com.css.sdk.cservice.refresh.Swipe;

public class RefreshLayout
extends ViewGroup {
    public int REFRESH_VIEW_HEIGHT_DP = 50;
    static final int REFRESHING = R.string.css_string_refreshing;
    static final int RELEASE_REFRESH = R.string.css_string_release_to_refresh;
    static final int PULL_DOWN = R.string.css_string_pull_to_refresh;
    static final int REFRESH_FINISH = R.string.css_string_load_completed;
    private final int DRAG_ACTION_NULL = 0;
    private final int DRAG_ACTION_PULL_DOWN = 1;
    private final int DRAG_ACTION_PULL_DOWN_BACK = 2;
    private int dragAction = 0;
    private Context mContext;
    Scroller scroller;
    boolean isRefreshing = false;
    private int refreshHeightOffset = 10;
    private int headViewRefreshingHeight;
    private int headViewAccessRefreshDistance;
    private static final float DECELERATE_INTERPOLATION_FACTOR = 2.0f;
    private DecelerateInterpolator mDecelerateInterpolator;
    private int mTouchSlop;
    private View headView;
    private ListView listview;
    private float initialDownY;
    private float initialDownX;
    private final int ANIMATOR_TIME = 300;
    private int pullDownDistance = 0;
    Handler handler = new Handler(){

        public void handleMessage(Message msg) {
            if (msg.what == 1) {
                RefreshLayout.this.stopRefresh();
                RefreshLayout.this.scroller.startScroll(0, RefreshLayout.this.getScrollY(), 0, -RefreshLayout.this.getScrollY());
                RefreshLayout.this.invalidate();
            }
        }
    };
    private Swipe.OnChangeViewHeight onChangeViewHeight;
    private Swipe.OnChangeViewTip onChangeViewTip;
    private Swipe.OnRefreshListener onRefreshListener;

    public RefreshLayout(Context context) {
        super(context);
        this.scroller = new Scroller(context);
    }

    public RefreshLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        this.REFRESH_VIEW_HEIGHT_DP = this.dp2px(this.mContext, this.REFRESH_VIEW_HEIGHT_DP);
        this.refreshHeightOffset = this.dp2px(this.mContext, this.refreshHeightOffset);
        this.headViewRefreshingHeight = this.REFRESH_VIEW_HEIGHT_DP;
        this.headViewAccessRefreshDistance = this.headViewRefreshingHeight + this.refreshHeightOffset;
        this.mDecelerateInterpolator = new DecelerateInterpolator(2.0f);
        this.scroller = new Scroller(context, (Interpolator)this.mDecelerateInterpolator);
        this.addHead();
    }

    private void addHead() {
        HeadManager headManager = new HeadManager(this.mContext, this);
        this.addView(headManager.getHeadView());
    }

    public RefreshLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.measureChildren(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onLayout(boolean b, int i, int i1, int i2, int i3) {
        if (this.getChildCount() < 2) {
            return;
        }
        this.headView = this.getChildAt(0);
        this.headView.layout(0, -this.headView.getMeasuredHeight(), this.headView.getMeasuredWidth(), 0);
        this.listview = (ListView)this.getChildAt(1);
        this.listview.layout(0, 0, this.listview.getMeasuredWidth(), this.listview.getMeasuredHeight());
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        switch (ev.getAction()) {
            case 0: {
                this.initialDownY = ev.getRawY();
                break;
            }
            case 2: {
                float dy = ev.getRawY() - this.initialDownY;
                this.initialDownY = ev.getRawY();
                boolean a2 = this.canChildScrollUp();
                if (!(dy > (float)this.mTouchSlop) || a2) break;
                return true;
            }
        }
        return super.onInterceptTouchEvent(ev);
    }

    private boolean canChildScrollUp() {
        return ListViewCompat.canScrollList((ListView)this.listview, (int)-1);
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.pullDownDistance = 0;
                this.initialDownY = event.getY();
            }
            case 2: {
                int dy = (int)(event.getRawY() - this.initialDownY);
                if (!this.isRefreshing) {
                    this.scrollBy(0, -dy / 2);
                    if (dy > 0) {
                        this.onPullDown(dy);
                    } else {
                        this.onPullDownBack(dy);
                    }
                }
                this.initialDownY = event.getRawY();
                break;
            }
            case 1: {
                this.release();
                break;
            }
        }
        return super.onTouchEvent(event);
    }

    private void release() {
        if (this.dragAction == 1 || this.dragAction == 2) {
            if (this.pullDownDistance >= this.headViewAccessRefreshDistance) {
                this.isRefreshing = true;
                if (this.onRefreshListener != null) {
                    this.onRefreshListener.refresh();
                }
                if (this.onChangeViewTip != null) {
                    this.onChangeViewTip.changeHeadTips(REFRESHING);
                }
                this.adjustRefreshPosition();
            } else if (!this.isRefreshing) {
                this.scroller.startScroll(0, this.getScrollY(), 0, -this.getScrollY());
                this.cancelRefresh();
                this.invalidate();
            }
        }
    }

    private int getPullDownDistance() {
        return this.pullDownDistance;
    }

    private void setPullDownDistance(int pullDownDistance) {
        this.pullDownDistance = pullDownDistance;
        if (this.onChangeViewHeight != null) {
            this.onChangeViewHeight.changeHeadViewHeight(pullDownDistance);
        }
    }

    private void adjustRefreshPosition() {
        ObjectAnimator objectAnimator = ObjectAnimator.ofInt((Object)((Object)this), (String)"pullDownDistance", (int[])new int[]{this.pullDownDistance, this.headViewRefreshingHeight});
        objectAnimator.setDuration(300L);
        objectAnimator.start();
    }

    private void cancelRefresh() {
        ObjectAnimator objectAnimator = ObjectAnimator.ofInt((Object)((Object)this), (String)"pullDownDistance", (int[])new int[]{this.pullDownDistance, 0});
        objectAnimator.setDuration(300L);
        objectAnimator.start();
    }

    private void onPullDown(int dy) {
        this.dragAction = 1;
        this.pullDownDistance += Math.abs(dy) / 2;
        this.changeTipsRefresh();
        if (this.onChangeViewHeight != null) {
            this.onChangeViewHeight.changeHeadViewHeight(this.pullDownDistance);
        }
    }

    private void onPullDownBack(int dy) {
        this.dragAction = 2;
        this.pullDownDistance -= Math.abs(dy) / 2;
        this.changeTipsRefresh();
        if (this.onChangeViewHeight != null) {
            this.onChangeViewHeight.changeHeadViewHeight(this.pullDownDistance);
        }
    }

    private void changeTipsRefresh() {
        if (this.pullDownDistance >= this.headViewAccessRefreshDistance) {
            if (this.onChangeViewTip != null) {
                this.onChangeViewTip.changeHeadTips(RELEASE_REFRESH);
            }
        } else if (this.onChangeViewTip != null) {
            this.onChangeViewTip.changeHeadTips(PULL_DOWN);
        }
    }

    public void computeScroll() {
        if (this.scroller.computeScrollOffset()) {
            this.scrollTo(this.scroller.getCurrX(), this.scroller.getCurrY());
            this.invalidate();
        }
    }

    public void requestDisallowInterceptTouchEvent(boolean disallowIntercept) {
    }

    private void stopRefresh() {
        ObjectAnimator objectAnimator = ObjectAnimator.ofInt((Object)((Object)this), (String)"pullDownDistance", (int[])new int[]{this.pullDownDistance, 0});
        objectAnimator.setDuration(300L);
        objectAnimator.start();
    }

    public void finishRefresh() {
        this.isRefreshing = false;
        if (this.onChangeViewTip != null) {
            this.onChangeViewTip.changeHeadTips(REFRESH_FINISH);
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                RefreshLayout.this.handler.sendEmptyMessageDelayed(1, 500L);
            }
        }).start();
    }

    protected void setOnChangeViewHeight(Swipe.OnChangeViewHeight onChangeViewHeight) {
        this.onChangeViewHeight = onChangeViewHeight;
    }

    protected void setOnChangeViewTip(Swipe.OnChangeViewTip onChangeViewTip) {
        this.onChangeViewTip = onChangeViewTip;
    }

    public void setOnRefreshListener(Swipe.OnRefreshListener onRefreshListener) {
        this.onRefreshListener = onRefreshListener;
    }

    private int dp2px(Context context, float dpValue) {
        return (int)TypedValue.applyDimension((int)1, (float)dpValue, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }
}

