/*
 * Decompiled with CFR 0.152.
 */
package com.css.sdk.cservice.adapter;

import android.app.Activity;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.ImageView;
import com.css.sdk.R;
import com.css.sdk.cservice.base.utils.ToastUtil;
import com.css.sdk.cservice.imageloader.ImageLoader;
import java.util.ArrayList;

public class PictureAdapter
extends BaseAdapter {
    private ArrayList<String> images;
    private Activity mActivity;
    private int max_num;
    private LayoutInflater layoutInflater;
    private ArrayList<String> selectedPics = new ArrayList();
    private OnEventListener listener;

    public void setSelectedPics(ArrayList<String> selectedPics) {
        this.selectedPics = selectedPics;
    }

    public PictureAdapter(Activity activity, ArrayList<String> images, int maxnum) {
        this.images = images;
        this.mActivity = activity;
        this.max_num = maxnum;
        this.layoutInflater = LayoutInflater.from((Context)activity);
    }

    public void bindDatas(ArrayList<String> images) {
        this.images = images;
    }

    public void setListener(OnEventListener listener) {
        this.listener = listener;
    }

    public int getCount() {
        return this.images.size();
    }

    public Object getItem(int position) {
        return null;
    }

    public long getItemId(int position) {
        return 0L;
    }

    public View getView(final int position, View convertView, ViewGroup parent) {
        ViewHolder holder = null;
        if (convertView == null) {
            convertView = this.layoutInflater.inflate(R.layout.css_select_picture_item, parent, false);
            holder = new ViewHolder();
            holder.iv = (ImageView)convertView.findViewById(R.id.iv);
            holder.checkBox = (Button)convertView.findViewById(R.id.check);
            convertView.setTag((Object)holder);
        } else {
            holder = (ViewHolder)convertView.getTag();
        }
        holder.checkBox.setVisibility(0);
        ImageLoader.getInstance().load(this.images.get(position), holder.iv);
        boolean isSelected = this.selectedPics.contains(this.images.get(position));
        holder.checkBox.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!v.isSelected() && PictureAdapter.this.selectedPics.size() + 1 > PictureAdapter.this.max_num) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(PictureAdapter.this.mActivity.getResources().getString(R.string.css_string_chose_at_most)).append(" ").append(PictureAdapter.this.max_num).append(" ").append(PictureAdapter.this.mActivity.getResources().getString(R.string.css_string_sheet));
                    ToastUtil.showToastTip(PictureAdapter.this.mActivity.getApplicationContext(), sb.toString(), false);
                    return;
                }
                if (PictureAdapter.this.selectedPics.contains(PictureAdapter.this.images.get(position))) {
                    PictureAdapter.this.selectedPics.remove(PictureAdapter.this.images.get(position));
                } else {
                    PictureAdapter.this.selectedPics.add(PictureAdapter.this.images.get(position));
                }
                if (PictureAdapter.this.listener != null) {
                    PictureAdapter.this.listener.selectChanged();
                }
                v.setSelected(PictureAdapter.this.selectedPics.contains(PictureAdapter.this.images.get(position)));
            }
        });
        holder.iv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (PictureAdapter.this.listener != null) {
                    PictureAdapter.this.listener.onPreview(position);
                }
            }
        });
        holder.checkBox.setSelected(isSelected);
        return convertView;
    }

    public ArrayList<String> getSelectedPics() {
        return this.selectedPics;
    }

    public static interface OnEventListener {
        public void onPreview(int var1);

        public void selectChanged();
    }

    class ViewHolder {
        ImageView iv;
        Button checkBox;

        ViewHolder() {
        }
    }
}

