package com.css.sdk.cservice.base.utils;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;

/**
 * Created by Holaverse on 2017/4/19.
 */

public class ThreadHelper {
    private static Handler mMainHandler; // UI线程
    private static Handler mWorkHandler; // 轻量级任务、线程调度

    static {
        initMainHandler();
        initWorkHandler();
    }

    private static void initWorkHandler() {
        if (mWorkHandler == null) {
            final HandlerThread thread = new HandlerThread("css_sdk");
            thread.start();
            mWorkHandler = new Handler(thread.getLooper());
        }
    }

    private static void initMainHandler() {
        if (mMainHandler == null) {
            mMainHandler = new Handler(Looper.getMainLooper());
        }
    }

    public static void runOnMainThread(Runnable r) {
        initMainHandler();

        mMainHandler.post(r);
    }

    public static void runOnMainThread(Runnable r, long delay) {
        initMainHandler();
        mMainHandler.postDelayed(r, delay);
    }

    public static void removeOnMainThread(Runnable r) {
        if (mMainHandler != null && r != null) {
            mMainHandler.removeCallbacks(r);
        }
    }

    public static void runOnWorkThread(Runnable r) {
        initWorkHandler();

        mWorkHandler.post(r);
    }

    public static void runOnWorkThread(Runnable r, long delay) {
        initWorkHandler();

        mWorkHandler.postDelayed(r, delay);
    }

    public static void removeOnWorkThread(Runnable r) {
        if (mWorkHandler != null && r != null) {
            mWorkHandler.removeCallbacks(r);
        }
    }

}
