/*
 * Decompiled with CFR 0.152.
 */
package com.css.sdk.unity;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.css.sdk.cservice.CServiceSdk;
import com.css.sdk.cservice.InitCallback;
import com.css.sdk.cservice.listener.CSSExistNewReplyCallback;
import com.css.sdk.unity.CSSDKBaseProxy;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.json.JSONObject;

public class CSSDKProxy
extends CSSDKBaseProxy {
    private static Object sUnityPlayerObject;
    private static Method sUnitySendMessageMethod;
    private static String sGameObjectName;
    private static String sGameFunctionName;
    public static final String Function_CSSDK_REPLY_Success = "CSSDK_REPLY_Success";
    public static final String Function_CSSDK_REPLY_Fail = "CSSDK_REPLY_Fail";
    private static CSSDKProxyCallback polyProxyCallback;

    public static void init(String ptdid) {
        CSSDKProxy.tryToGetGameActivity();
        if (CSSDKProxy.getActivity() != null) {
            CServiceSdk.initSdk((Context)CSSDKProxy.getActivity(), ptdid, new InitCallback(){

                @Override
                public void onInitSuccess() {
                    Log.i((String)"CSSDKProxy ===>", (String)"---- unity init Susscess-----");
                }

                @Override
                public void onInitFailed(String s) {
                    Log.i((String)"CSSDKProxy ===>", (String)("---- unity init Fail----- reason" + s));
                }
            });
        } else {
            Log.i((String)"CSSDKProxy ===>", (String)"---- unity init Fail----- activity is null");
        }
    }

    public static void addExtraMsg(String msg) {
        if (!TextUtils.isEmpty((CharSequence)msg)) {
            CServiceSdk.addExtraMsg(CSSDKProxy.convertJsonToMap(msg));
        } else {
            Log.i((String)"CSSDKProxy ===>", (String)"---- addExtraMsg Fail----- msg is null");
        }
    }

    public static void feedback() {
        CSSDKProxy.tryToGetGameActivity();
        if (CSSDKProxy.getActivity() != null) {
            CServiceSdk.feedback((Context)CSSDKProxy.getActivity());
        } else {
            Log.i((String)"CSSDKProxy ===>", (String)"---- feedback Fail----- activity is null");
        }
    }

    public static void setNewReplayCallback(String gameName, String funname) {
        CSSDKProxy.unityLogi("setNewReplayCallback, sGameObjectName :" + gameName);
        CSSDKProxy.unityLogi("setNewReplayCallback, sGameFunctionName :" + funname);
        CSSDKProxy.setGameObjectName(gameName);
        CSSDKProxy.setGameFunctionName(funname);
        CSSDKProxy.tryToGetGameActivity();
        if (CSSDKProxy.getActivity() != null) {
            CServiceSdk.setNewReplayCallback(new CSSExistNewReplyCallback(){

                @Override
                public void hasNewReplySuccess(boolean b) {
                    polyProxyCallback.invokeUnitySendMessage(CSSDKProxy.Function_CSSDK_REPLY_Success, "success");
                }

                @Override
                public void hasNewReplyFail(String s) {
                    polyProxyCallback.invokeUnitySendMessage(CSSDKProxy.Function_CSSDK_REPLY_Fail, s);
                }
            });
            Log.i((String)"CSSDKProxy ===>", (String)"---- unity setNewReplayCallback  Susscess-----");
        } else {
            Log.i((String)"CSSDKProxy ===>", (String)"---- unity setNewReplayCallback  Fail----- activity is null");
        }
    }

    private static void tryToGetGameActivity() {
        if (CSSDKProxy.getActivity() == null) {
            CSSDKProxy.ivokeUnityActivity();
        }
        if (CSSDKProxy.getActivity() == null) {
            Activity sGameActivity = CSSDKProxy.getCurrentActivity();
            CSSDKProxy.setsActivity(sGameActivity);
        }
    }

    private static void ivokeUnityActivity() {
        block12: {
            try {
                Class<?> sUnityPlayer = null;
                if (sUnityPlayer == null) {
                    CSSDKProxy.unityLogi("try to load UnityPlayer");
                    sUnityPlayer = Class.forName("com.unity3d.player.UnityPlayer");
                }
                if (sUnityPlayer == null) break block12;
                CSSDKProxy.unityLogi("try to get currentActivity");
                Field field = sUnityPlayer.getDeclaredField("currentActivity");
                field.setAccessible(true);
                Object o = field.get(null);
                if (o != null && o instanceof Activity) {
                    CSSDKProxy.unityLogi("find the currentActivity");
                    CSSDKProxy.setsActivity((Activity)o);
                } else {
                    CSSDKProxy.unityLogi("will find the currentActivity in all fields.");
                    Field[] fields = sUnityPlayer.getDeclaredFields();
                    if (fields != null) {
                        for (Field f : fields) {
                            String typename = f.getType().getName();
                            CSSDKProxy.unityLogi(typename);
                            if (!typename.equals("android.app.Activity")) continue;
                            f.setAccessible(true);
                            o = f.get(null);
                            CSSDKProxy.setsActivity((Activity)o);
                            CSSDKProxy.unityLogi("has found the currentActivity");
                            break;
                        }
                    }
                }
                Activity gameActivity = CSSDKProxy.getActivity();
                if (gameActivity == null) break block12;
                CSSDKProxy.unityLogi("will find the avail unityplayer object.");
                Object unityPlayerObject = null;
                block5: for (Class<?> acls = gameActivity.getClass(); acls != null; acls = acls.getSuperclass()) {
                    try {
                        Field[] flds = acls.getDeclaredFields();
                        if (flds == null) continue;
                        for (Field f : flds) {
                            String typename = f.getType().getName();
                            if (!"com.unity3d.player.UnityPlayer".equals(typename)) continue;
                            f.setAccessible(true);
                            unityPlayerObject = f.get(gameActivity);
                            CSSDKProxy.unityLogi("has found the unityplayer object: " + unityPlayerObject);
                            continue block5;
                        }
                        continue;
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
                if (unityPlayerObject == null) break block12;
                CSSDKProxy.unityLogi("try to find the unityplayer UnitySendMessage method");
                Method[] ms = unityPlayerObject.getClass().getDeclaredMethods();
                if (ms == null) break block12;
                for (Method m : ms) {
                    String name = m.getName();
                    if (!name.equals("UnitySendMessage")) continue;
                    Method sendMessageMethod = m;
                    sendMessageMethod.setAccessible(true);
                    CSSDKProxy.setUnitySendMessageMethod(sendMessageMethod);
                    CSSDKProxy.setUnityPlayerObject(unityPlayerObject);
                    CSSDKProxy.unityLogi("has found the unityplayer UnitySendMessage method:" + CSSDKProxy.getUnitySendMessageMethod());
                    break;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    private static void setGameObjectName(String objectName) {
        sGameObjectName = objectName;
    }

    private static String getGameObjectName() {
        return sGameObjectName;
    }

    private static void setGameFunctionName(String functionName) {
        sGameFunctionName = functionName;
    }

    private static void setUnityPlayerObject(Object playerObject) {
        sUnityPlayerObject = playerObject;
    }

    private static Object getUnityPlayerObject() {
        return sUnityPlayerObject;
    }

    private static void setUnitySendMessageMethod(Method messageMethod) {
        sUnitySendMessageMethod = messageMethod;
    }

    private static Method getUnitySendMessageMethod() {
        return sUnitySendMessageMethod;
    }

    static {
        polyProxyCallback = new CSSDKProxyCallback(){

            @Override
            public void invokeUnitySendMessage(String function, String message) {
                Method unitySendMessageMethod = CSSDKProxy.getUnitySendMessageMethod();
                if (unitySendMessageMethod != null) {
                    try {
                        JSONObject json = new JSONObject();
                        json.put("callbackMessageKeyFunctionName", (Object)function);
                        json.put("msg", (Object)message);
                        String jsontext = json.toString();
                        unitySendMessageMethod.invoke(CSSDKProxy.getUnityPlayerObject(), sGameObjectName, sGameFunctionName, jsontext);
                        CSSDKBaseProxy.unityLogi("invokeUnitySendMessage" + jsontext);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }
        };
    }

    public static interface CSSDKProxyCallback {
        public void invokeUnitySendMessage(String var1, String var2);
    }
}

