/*
 * Decompiled with CFR 0.152.
 */
package com.css.sdk.cservice.imageloader.core;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Handler;
import android.os.Message;
import android.widget.ImageView;
import com.css.sdk.cservice.imageloader.core.ImageDecorder;
import com.css.sdk.cservice.imageloader.core.ImageRequest;
import com.css.sdk.cservice.imageloader.disk.LruDiskCache;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.concurrent.locks.ReentrantLock;

public class LoadImageTask
implements Runnable {
    public static final int MSG_LOAD_SUCCESS = 272;
    public static final int MSG_LOAD_FAIL = 273;
    protected Handler mUiHandler;
    protected ImageRequest request;
    private ImageDecorder mImageDecorder;
    private LruDiskCache mDisCache;

    public LoadImageTask(Context context, ImageRequest request, Handler uiHandler, LruDiskCache diskCache) {
        this.mUiHandler = uiHandler;
        this.request = request;
        this.mImageDecorder = new ImageDecorder(context);
        this.mDisCache = diskCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Bitmap bitmap = null;
        File diskCache = this.mDisCache.get(this.request.getUrl());
        ReentrantLock loadFromUriLock = this.request.loadFromUriLock;
        loadFromUriLock.lock();
        String imageUrl = this.request.getUrl();
        try {
            if (diskCache != null && diskCache.exists()) {
                bitmap = this.mImageDecorder.decodeByStream(new FileInputStream(diskCache), this.buildDecodeParams(this.request));
            } else {
                InputStream imageStream = this.mImageDecorder.getImageStream(imageUrl);
                if (imageUrl.startsWith("http") || imageUrl.startsWith("https")) {
                    this.saveToDisk(this.request.getUrl(), imageStream);
                }
                bitmap = this.mImageDecorder.decodeByStream(imageStream, this.buildDecodeParams(this.request));
            }
            if (bitmap != null) {
                this.request.setBitmap(bitmap);
                this.sendSuccessMsg(this.request);
            } else {
                this.sendErrorMsg(this.request);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.sendErrorMsg(this.request);
        }
        finally {
            loadFromUriLock.unlock();
        }
    }

    private void saveToDisk(String url, InputStream imageStream) throws Exception {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inSampleSize = 1;
        Bitmap bm = BitmapFactory.decodeStream((InputStream)imageStream, null, (BitmapFactory.Options)options);
        this.mDisCache.save(url, bm);
    }

    protected void sendSuccessMsg(ImageRequest request) {
        Message msg = Message.obtain(null, (int)272);
        msg.obj = request;
        this.mUiHandler.sendMessage(msg);
    }

    protected void sendErrorMsg(ImageRequest request) {
        Message msg = Message.obtain(null, (int)273);
        msg.obj = request;
        this.mUiHandler.sendMessage(msg);
    }

    protected ImageDecorder.ImageDecorderParams buildDecodeParams(ImageRequest request) {
        ImageDecorder.ImageDecorderParams params = new ImageDecorder.ImageDecorderParams();
        params.imageView = (ImageView)request.getTarget();
        params.expectSize = request.getExpectSize();
        params.url = request.getUrl();
        return params;
    }
}

