package com.css.sdk.cservice.data;

import android.content.Context;

import com.css.sdk.cservice.utils.LocalInfo;

import org.json.JSONException;
import org.json.JSONObject;

public class FaqItem {
    public String id;
    public String questionZh;
    public String questionZhSimple;
    public String questionEn;

    public void parseJsonString(JSONObject jsonObject) throws Exception {
        this.id = jsonObject.getString("id");
        this.questionZh = jsonObject.getString("questionZh");
        this.questionEn = jsonObject.getString("questionEn");
        this.questionZhSimple = jsonObject.getString("questionZhSimple");
    }

    @Override
    public String toString() {
        return "FaqItem{" +
                "id='" + id + '\'' +
                ", questionZh='" + questionZh + '\'' +
                ", questionZhSimple='" + questionZhSimple + '\'' +
                ", questionEn='" + questionEn + '\'' +
                '}';
    }
    /**
     * 根据语言返回对应的信息
     * @param context
     * @return
     */
    public String getFaqTypeByLanguage(Context context) {
        String resultStr = "";
        switch (LocalInfo.getLanguage(context)) {
            case EN:
                resultStr = this.questionEn;
                break;
            case ZHSIMPLE:
                resultStr = this.questionZhSimple;
                break;
            case ZHTrandition:
                resultStr = this.questionZh;
                break;
            default:
                resultStr = this.questionEn;
                break;
        }
        return resultStr;
    }
}
