/*
 * Decompiled with CFR 0.152.
 */
package com.css.sdk.cservice.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.Scroller;

public class SlideItem
extends LinearLayout {
    private View contentView = null;
    private View menuView = null;
    private Scroller mOpenScroller;
    private Scroller mCloseScroller;
    private int downX;
    private int state = 0;
    private static final int STATE_CLOSE = 0;
    private static final int STATE_OPEN = 1;
    private int mBaseX;

    public SlideItem(Context context) {
        super(context);
    }

    public SlideItem(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public SlideItem(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void setContentView(View contentView, View rightView) {
        this.contentView = contentView;
        this.menuView = rightView;
        this.mCloseScroller = new Scroller(this.getContext());
        this.mOpenScroller = new Scroller(this.getContext());
        this.initView();
    }

    private void initView() {
        LinearLayout.LayoutParams contentParams = new LinearLayout.LayoutParams(-1, -1);
        LinearLayout.LayoutParams rightParams = new LinearLayout.LayoutParams(-2, -1);
        this.contentView.setLayoutParams((ViewGroup.LayoutParams)contentParams);
        this.contentView.setPadding(10, 10, 10, 10);
        this.menuView.setLayoutParams((ViewGroup.LayoutParams)rightParams);
        this.addView(this.contentView);
        this.addView(this.menuView);
    }

    public boolean isOpen() {
        return this.state == 1;
    }

    public boolean onSwipe(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.downX = (int)event.getX();
                break;
            }
            case 2: {
                int dis = (int)((float)this.downX - event.getX());
                if (this.state == 1) {
                    dis += this.menuView.getWidth();
                }
                this.move(dis);
                break;
            }
            case 1: {
                if ((float)this.downX - event.getX() > (float)(this.menuView.getWidth() / 2)) {
                    this.smoothOpenMenu();
                    break;
                }
                this.smoothCloseMenu();
                return false;
            }
        }
        return true;
    }

    public void computeScroll() {
        if (this.state == 1) {
            if (this.mOpenScroller.computeScrollOffset()) {
                this.move(this.mOpenScroller.getCurrX());
                this.postInvalidate();
            }
        } else if (this.mCloseScroller.computeScrollOffset()) {
            this.move(this.mBaseX - this.mCloseScroller.getCurrX());
            this.postInvalidate();
        }
    }

    private void move(int dis) {
        if (dis > this.menuView.getWidth()) {
            dis = this.menuView.getWidth();
        }
        if (dis < 0) {
            dis = 0;
        }
        this.contentView.layout(-dis, this.contentView.getTop(), this.contentView.getWidth() - dis, this.getMeasuredHeight());
        this.menuView.layout(this.contentView.getWidth() - dis, this.menuView.getTop(), this.contentView.getWidth() + this.menuView.getWidth() - dis, this.menuView.getBottom());
    }

    public void smoothCloseMenu() {
        this.state = 0;
        this.mBaseX = -this.contentView.getLeft();
        this.mCloseScroller.startScroll(0, 0, this.mBaseX, 0, 350);
        this.postInvalidate();
    }

    public void closeMenu() {
        this.state = 0;
        this.mBaseX = -this.contentView.getLeft();
        this.mCloseScroller.startScroll(0, 0, this.mBaseX, 0);
        this.postInvalidate();
    }

    public void smoothOpenMenu() {
        this.state = 1;
        this.mOpenScroller.startScroll(-this.contentView.getLeft(), 0, this.menuView.getWidth(), 0, 350);
        this.postInvalidate();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.menuView != null) {
            this.menuView.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)this.getMeasuredHeight(), (int)0x40000000));
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        if (this.contentView != null) {
            this.contentView.layout(0, 0, this.getMeasuredWidth(), this.contentView.getMeasuredHeight());
        }
        if (this.menuView != null) {
            this.menuView.layout(this.getMeasuredWidth(), 0, this.getMeasuredWidth() + this.menuView.getMeasuredWidth(), this.contentView.getMeasuredHeight());
        }
    }
}

