/*
 * Decompiled with CFR 0.152.
 */
package com.css.sdk.cservice.imageloader;

import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import com.css.sdk.cservice.imageloader.ImageLoaderConfig;
import com.css.sdk.cservice.imageloader.core.CancelableRequestDelegate;
import com.css.sdk.cservice.imageloader.core.ImageRequest;
import com.css.sdk.cservice.imageloader.core.LoadImageTask;
import com.css.sdk.cservice.userdata.GlobalData;
import java.io.File;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.ReentrantLock;

public class ImageLoader {
    public static final int MSG_LOAD_SUCCESS = 272;
    public static final int MSG_LOAD_FAIL = 273;
    private Executor mTaskDistribute = Executors.newCachedThreadPool();
    private final Map<String, ReentrantLock> uriLocks = new WeakHashMap<String, ReentrantLock>();
    private ImageLoaderConfig mLoaderConfig;
    private CancelableRequestDelegate mCancelableRequestDelegate = new CancelableRequestDelegate();
    private Handler HANDLER = new Handler(){

        public void handleMessage(Message msg) {
            ImageRequest req = (ImageRequest)msg.obj;
            switch (msg.what) {
                case 273: {
                    req.setErrorImageRes();
                    break;
                }
                case 272: {
                    if (!req.setResBitmap()) break;
                    ((ImageLoader)ImageLoader.this).mLoaderConfig.mLruCache.put((Object)req.getCacheKey(), (Object)req.getBitmap());
                }
            }
        }
    };
    private static ImageLoader sInstance;

    public void init(ImageLoaderConfig loaderConfig) {
        this.mLoaderConfig = loaderConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ImageLoader getInstance() {
        if (sInstance != null) return sInstance;
        Class<ImageLoader> clazz = ImageLoader.class;
        synchronized (ImageLoader.class) {
            if (sInstance != null) return sInstance;
            sInstance = new ImageLoader();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public CancelableRequestDelegate getCancelableRequestDelegate() {
        return this.mCancelableRequestDelegate;
    }

    public void load(String path, ImageView imageView) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return;
        }
        if (this.mLoaderConfig == null) {
            this.mLoaderConfig = ImageLoaderConfig.createDefault(GlobalData.getContext());
        }
        this.setDefaultImageRes(imageView);
        final ImageRequest req = this.buildImageRequest(path, imageView);
        String cacheKey = req.getCacheKey();
        this.mCancelableRequestDelegate.putRequest(imageView.hashCode(), cacheKey);
        Bitmap bitmap = (Bitmap)this.mLoaderConfig.mLruCache.get((Object)cacheKey);
        if (bitmap != null) {
            imageView.setImageBitmap(bitmap);
            return;
        }
        this.mTaskDistribute.execute(new Runnable(){

            @Override
            public void run() {
                String uri = req.getUrl();
                LoadImageTask task = new LoadImageTask(GlobalData.getContext(), req, ImageLoader.this.HANDLER, ((ImageLoader)ImageLoader.this).mLoaderConfig.mDiskCache);
                File cache = ((ImageLoader)ImageLoader.this).mLoaderConfig.mDiskCache.get(uri);
                if (cache != null && cache.exists()) {
                    ((ImageLoader)ImageLoader.this).mLoaderConfig.taskExecutorForCachedImages.execute(task);
                } else {
                    ((ImageLoader)ImageLoader.this).mLoaderConfig.taskExecutor.execute(task);
                }
            }
        });
    }

    public void stop() {
        if (this.mLoaderConfig != null) {
            this.mLoaderConfig.stop();
        }
        this.mCancelableRequestDelegate.clear();
        this.uriLocks.clear();
    }

    private ReentrantLock getLockForUri(String uri) {
        ReentrantLock lock = this.uriLocks.get(uri);
        if (lock == null) {
            lock = new ReentrantLock();
            this.uriLocks.put(uri, lock);
        }
        return lock;
    }

    private void setDefaultImageRes(ImageView imageView) {
        if (this.mLoaderConfig.mDefaultResId != 0) {
            imageView.setImageResource(this.mLoaderConfig.mDefaultResId);
        }
    }

    private ImageRequest buildImageRequest(String path, ImageView imageView) {
        ImageRequest req = new ImageRequest(this, path, (View)imageView, this.mLoaderConfig, this.getLockForUri(path));
        return req;
    }
}

