/*
 * Decompiled with CFR 0.152.
 */
package com.css.sdk.cservice.base.utils;

import android.content.Context;
import android.content.SharedPreferences;
import com.css.sdk.cservice.base.Constants;

public class SpHelper {
    private SharedPreferences mSp = null;

    public SpHelper(Context context, String name) {
        this.mSp = context.getSharedPreferences(name, 0);
    }

    public boolean isCreated() {
        return this.mSp == null;
    }

    public void putString(String key, String value) {
        SharedPreferences.Editor editor = this.mSp.edit();
        editor.putString(key, value);
        editor.apply();
    }

    public String getString(String key) {
        return this.mSp.getString(key, null);
    }

    public static String getString(Context context, String key) {
        if (context == null) {
            return "";
        }
        SharedPreferences var2 = context.getSharedPreferences(Constants.SP_NAME, 0);
        return var2.getString(key, null);
    }

    public boolean contains(String key) {
        return this.mSp.contains(key);
    }

    public void remove(String key) {
        SharedPreferences.Editor editor = this.mSp.edit();
        editor.remove(key);
    }

    public void putBoolean(String key, boolean value) {
        SharedPreferences.Editor editor = this.mSp.edit();
        editor.putBoolean(key, value);
        editor.apply();
    }

    public SharedPreferences.Editor getEditor() {
        return this.mSp.edit();
    }

    public boolean getBoolean(String key) {
        return this.getBooleanWithDefault(key, false);
    }

    public boolean getBooleanWithDefault(String key, boolean value) {
        return this.mSp.getBoolean(key, value);
    }

    public void putInt(String key, int value) {
        SharedPreferences.Editor editor = this.mSp.edit();
        editor.putInt(key, value);
        editor.apply();
    }

    public int getInt(String key) {
        return this.getIntWithDefault(key, 0);
    }

    public int getIntWithDefault(String key, int value) {
        return this.mSp.getInt(key, value);
    }

    public void putLong(String key, long value) {
        SharedPreferences.Editor editor = this.mSp.edit();
        editor.putLong(key, value);
        editor.apply();
    }

    public long getLong(String key) {
        return this.getLongWithDefault(key, 0L);
    }

    public long getLongWithDefault(String key, long value) {
        return this.mSp.getLong(key, value);
    }

    public void putFloat(String key, float value) {
        SharedPreferences.Editor editor = this.mSp.edit();
        editor.putFloat(key, value);
        editor.apply();
    }

    public float getFloat(String key) {
        return this.getFloatDefault(key, 0L);
    }

    public float getFloatDefault(String key, long value) {
        return this.mSp.getFloat(key, (float)value);
    }
}

